/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class TranscodeTemplateDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        TranscodeTemplateDemo.describeMediaTemplates(cOSClient);
    }

    public static void createMediaTemplate(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTag("Transcode");
        mediaTemplateRequest.setName("mark-test-2");
        mediaTemplateRequest.getContainer().setFormat("mp4");
        MediaVideoObject mediaVideoObject = mediaTemplateRequest.getVideo();
        mediaVideoObject.setCodec("H.264");
        mediaVideoObject.setProfile("high");
        mediaVideoObject.setBitrate("1000");
        mediaVideoObject.setWidth("1280");
        mediaVideoObject.setFps("30");
        mediaVideoObject.setPreset("medium");
        mediaVideoObject.setBufSize("1000");
        mediaVideoObject.setMaxrate("10");
        MediaAudioObject mediaAudioObject = mediaTemplateRequest.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("1");
        MediaTransConfigObject mediaTransConfigObject = mediaTemplateRequest.getTransConfig();
        mediaTransConfigObject.setAdjDarMethod("scale");
        mediaTransConfigObject.setIsCheckReso("false");
        mediaTransConfigObject.setResoAdjMethod("1");
        MediaTimeIntervalObject mediaTimeIntervalObject = mediaTemplateRequest.getTimeInterval();
        mediaTimeIntervalObject.setStart("0");
        mediaTimeIntervalObject.setDuration("60");
        MediaTemplateResponse mediaTemplateResponse = cOSClient.createMediaTemplate(mediaTemplateRequest);
        System.out.println(mediaTemplateResponse);
    }

    public static void deleteMediaTemplate(COSClient cOSClient) {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTemplateId("t1619b0381be1a46738796e97fff4*****");
        Boolean bl = cOSClient.deleteMediaTemplate(mediaTemplateRequest);
        System.out.println(bl);
    }

    public static void describeMediaTemplates(COSClient cOSClient) {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTag("Transcode");
        MediaListTemplateResponse mediaListTemplateResponse = cOSClient.describeMediaTemplates(mediaTemplateRequest);
        List<MediaTemplateObject> list = mediaListTemplateResponse.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : list) {
            System.out.println(mediaTemplateObject);
        }
    }

    public static void updateMediaTemplate(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaTemplateRequest mediaTemplateRequest = new MediaTemplateRequest();
        mediaTemplateRequest.setBucketName("DemoBucket-123456789");
        mediaTemplateRequest.setTemplateId("t138b37dc82e59422d85f03bb7a8*****");
        mediaTemplateRequest.setTag("Transcode");
        mediaTemplateRequest.setName("mark-test-update-01");
        mediaTemplateRequest.getContainer().setFormat("mp4");
        MediaVideoObject mediaVideoObject = mediaTemplateRequest.getVideo();
        mediaVideoObject.setCodec("H.264");
        mediaVideoObject.setProfile("high");
        mediaVideoObject.setBitrate("1000");
        mediaVideoObject.setWidth("1280");
        mediaVideoObject.setFps("30");
        mediaVideoObject.setPreset("medium");
        mediaVideoObject.setBufSize("1000");
        mediaVideoObject.setMaxrate("10");
        MediaAudioObject mediaAudioObject = mediaTemplateRequest.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("1");
        MediaTransConfigObject mediaTransConfigObject = mediaTemplateRequest.getTransConfig();
        mediaTransConfigObject.setAdjDarMethod("scale");
        mediaTransConfigObject.setIsCheckReso("false");
        mediaTransConfigObject.setResoAdjMethod("1");
        MediaTimeIntervalObject mediaTimeIntervalObject = mediaTemplateRequest.getTimeInterval();
        mediaTimeIntervalObject.setStart("1");
        mediaTimeIntervalObject.setDuration("30");
        Boolean bl = cOSClient.updateMediaTemplate(mediaTemplateRequest);
        System.out.println(bl);
    }
}

