/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioMixObject;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import java.util.List;

public class TranscodeJobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        TranscodeJobDemo.createMediaJobs2(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setTag("Transcode");
        mediaJobsRequest.getInput().setObject("1.mp4");
        MediaTranscodeObject mediaTranscodeObject = mediaJobsRequest.getOperation().getTranscode();
        MediaContainerObject mediaContainerObject = mediaTranscodeObject.getContainer();
        mediaContainerObject.setFormat("mp4");
        MediaTranscodeVideoObject mediaTranscodeVideoObject = mediaTranscodeObject.getVideo();
        mediaTranscodeVideoObject.setCodec("H.264");
        mediaTranscodeVideoObject.setProfile("high");
        mediaTranscodeVideoObject.setBitrate("1000");
        mediaTranscodeVideoObject.setWidth("1280");
        mediaTranscodeVideoObject.setFps("30");
        mediaTranscodeVideoObject.setPreset("medium");
        mediaTranscodeVideoObject.setBufSize("0");
        mediaTranscodeVideoObject.setMaxrate("50000");
        MediaAudioObject mediaAudioObject = mediaTranscodeObject.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("4");
        MediaTimeIntervalObject mediaTimeIntervalObject = mediaTranscodeObject.getTimeInterval();
        mediaTimeIntervalObject.setStart("0");
        mediaTimeIntervalObject.setDuration("60");
        mediaJobsRequest.getOperation().getOutput().setBucket("demo-1234567890");
        mediaJobsRequest.getOperation().getOutput().setRegion("ap-chongqing");
        mediaJobsRequest.getOperation().getOutput().setObject("demo1.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a52170834");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse.getJobsDetail().getJobId());
    }

    public static void createMediaJobs2(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setTag("Transcode");
        mediaJobsRequest.getInput().setObject("1.mp4");
        MediaJobOperation mediaJobOperation = mediaJobsRequest.getOperation();
        MediaTranscodeObject mediaTranscodeObject = mediaJobOperation.getTranscode();
        MediaContainerObject mediaContainerObject = mediaTranscodeObject.getContainer();
        mediaContainerObject.setFormat("mkv");
        MediaTranscodeVideoObject mediaTranscodeVideoObject = mediaTranscodeObject.getVideo();
        mediaTranscodeVideoObject.setCodec("H.264");
        mediaTranscodeVideoObject.setProfile("high");
        mediaTranscodeVideoObject.setBitrate("1000");
        mediaTranscodeVideoObject.setWidth("1280");
        mediaTranscodeVideoObject.setFps("30");
        mediaTranscodeVideoObject.setPreset("medium");
        mediaTranscodeVideoObject.setBufSize("0");
        mediaTranscodeVideoObject.setMaxrate("50000");
        MediaAudioObject mediaAudioObject = mediaTranscodeObject.getAudio();
        mediaAudioObject.setCodec("aac");
        mediaAudioObject.setSamplerate("44100");
        mediaAudioObject.setBitrate("128");
        mediaAudioObject.setChannels("4");
        List<MediaAudioMixObject> list = mediaTranscodeObject.getAudioMixArray();
        MediaAudioMixObject mediaAudioMixObject = new MediaAudioMixObject();
        mediaAudioMixObject.setAudioSource("https://demo-1234567890.cos.ap-chongqing.myqcloud.com/1.mp3");
        mediaAudioMixObject.setReplace("true");
        list.add(mediaAudioMixObject);
        mediaAudioMixObject = new MediaAudioMixObject();
        mediaAudioMixObject.setAudioSource("https://demo-1234567890.cos.ap-chongqing.myqcloud.com/1.mp3");
        mediaAudioMixObject.setReplace("true");
        list.add(mediaAudioMixObject);
        mediaJobOperation.getOutput().setBucket("demo-1234567890");
        mediaJobOperation.getOutput().setRegion("ap-chongqing");
        mediaJobOperation.getOutput().setObject("demo2.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a52170834");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setJobId("j64f64980a6cc11ed8d022552f0a*****");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        mediaJobsRequest.setTag("Transcode");
        MediaListJobResponse mediaListJobResponse = cOSClient.describeMediaJobs(mediaJobsRequest);
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        for (MediaJobObject mediaJobObject : list) {
            System.out.println(mediaJobObject.getOperation().getTranscode());
        }
    }

    public static void cancelMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-123456789");
        mediaJobsRequest.setJobId("jbfb0d02a092111ebb3167781d*****");
        Boolean bl = cOSClient.cancelMediaJob(mediaJobsRequest);
        System.out.println(bl);
    }
}

