/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaQueueRequest;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class PicProcessJobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        PicProcessJobDemo.describePicProcessQueues(cOSClient);
    }

    public static void createPicProcessJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setTag("PicProcess");
        mediaJobsRequest.getInput().setObject("1.png");
        mediaJobsRequest.getOperation().getOutput().setBucket("demo-1234567890");
        mediaJobsRequest.getOperation().getOutput().setRegion("ap-chongqing");
        mediaJobsRequest.getOperation().getOutput().setObject("2.png");
        mediaJobsRequest.getOperation().getPicProcess().setProcessRule("imageMogr2/rotate/90");
        mediaJobsRequest.getOperation().getPicProcess().setIsPicInfo("true");
        mediaJobsRequest.setQueueId("p86ede0188f844ac99d50f5fa63005237");
        mediaJobsRequest.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse mediaJobResponse = cOSClient.createPicProcessJob(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setJobId("cabd41ea0355b11ed847a618901112dcf");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(Jackson.toJsonString(mediaJobResponse.getJobsDetail().getOperation()));
    }

    public static void describeJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("demo-1234567890");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        mediaJobsRequest.setTag("PicProcess");
        MediaListJobResponse mediaListJobResponse = cOSClient.describeMediaJobs(mediaJobsRequest);
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        for (MediaJobObject mediaJobObject : list) {
            System.out.println(mediaJobObject.getOperation().getTranscode());
        }
    }

    public static void describePicProcessQueues(COSClient cOSClient) {
        MediaQueueRequest mediaQueueRequest = new MediaQueueRequest();
        mediaQueueRequest.setBucketName("demo-1234567890");
        MediaListQueueResponse mediaListQueueResponse = cOSClient.describePicProcessQueues(mediaQueueRequest);
        System.out.println(mediaListQueueResponse);
    }
}

