/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class DigitalWatermarkJobDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        DigitalWatermarkJobDemo.createMediaJobs(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-1234567890");
        mediaJobsRequest.setTag("DigitalWatermark");
        mediaJobsRequest.getInput().setObject("1.mp4");
        MediaJobOperation mediaJobOperation = mediaJobsRequest.getOperation();
        MediaDigitalWatermark mediaDigitalWatermark = mediaJobOperation.getDigitalWatermark();
        mediaDigitalWatermark.setMessage("demo");
        mediaDigitalWatermark.setType("Text");
        mediaDigitalWatermark.setVersion("V1");
        mediaJobOperation.getOutput().setBucket("DemoBucket-1234567890");
        mediaJobOperation.getOutput().setRegion("ap-chongqing");
        mediaJobOperation.getOutput().setObject("DigitalWatermark.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-1234567890");
        mediaJobsRequest.setJobId("j625e550abb9f11ecae7dcbeb4a2*****");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-1234567890");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        mediaJobsRequest.setTag("DigitalWatermark");
        MediaListJobResponse mediaListJobResponse = cOSClient.describeMediaJobs(mediaJobsRequest);
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        for (MediaJobObject mediaJobObject : list) {
            System.out.println(mediaJobObject);
        }
    }

    public static void cancelMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("DemoBucket-1234567890");
        mediaJobsRequest.setJobId("jfb4039b0bb9e11ecbd2081a7c70******");
        Boolean bl = cOSClient.cancelMediaJob(mediaJobsRequest);
        System.out.println(bl);
    }
}

