/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class ConcatDemo {
    public static void main(String[] stringArray) throws Exception {
        COSClient cOSClient = ClientUtils.getTestClient();
        ConcatDemo.createMediaJobs(cOSClient);
    }

    public static void createMediaJobs(COSClient cOSClient) throws UnsupportedEncodingException {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("examplebucket-1250000000");
        mediaJobsRequest.setTag("Concat");
        mediaJobsRequest.getInput().setObject("demo.mp4");
        MediaConcatTemplateObject mediaConcatTemplateObject = mediaJobsRequest.getOperation().getMediaConcatTemplate();
        List<MediaConcatFragmentObject> list = mediaConcatTemplateObject.getConcatFragmentList();
        MediaConcatFragmentObject mediaConcatFragmentObject = new MediaConcatFragmentObject();
        mediaConcatFragmentObject.setMode("Start");
        mediaConcatFragmentObject.setUrl("http://examplebucket-1250000000.cos.ap-chongqing.myqcloud.com/demo1.mp4");
        list.add(mediaConcatFragmentObject);
        mediaConcatFragmentObject = new MediaConcatFragmentObject();
        mediaConcatFragmentObject.setMode("End");
        mediaConcatFragmentObject.setUrl("http://examplebucket-1250000000.cos.ap-chongqing.myqcloud.com/demo2.mp4");
        list.add(mediaConcatFragmentObject);
        MediaAudioObject mediaAudioObject = mediaConcatTemplateObject.getAudio();
        mediaAudioObject.setCodec("mp3");
        MediaVideoObject mediaVideoObject = mediaConcatTemplateObject.getVideo();
        mediaVideoObject.setCodec("H.264");
        mediaVideoObject.setBitrate("1000");
        mediaVideoObject.setWidth("1280");
        mediaVideoObject.setFps("30");
        MediaContainerObject mediaContainerObject = mediaConcatTemplateObject.getContainer();
        mediaContainerObject.setFormat("mp4");
        mediaConcatTemplateObject.setIndex("1");
        mediaJobsRequest.getOperation().getOutput().setBucket("examplebucket-1250000000");
        mediaJobsRequest.getOperation().getOutput().setRegion("ap-chongqing");
        mediaJobsRequest.getOperation().getOutput().setObject("concat.mp4");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        MediaJobResponse mediaJobResponse = cOSClient.createMediaJobs(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("examplebucket-1250000000");
        mediaJobsRequest.setJobId("j6fc9306c8bd411eb8b416b8ff9172c91");
        MediaJobResponse mediaJobResponse = cOSClient.describeMediaJob(mediaJobsRequest);
        System.out.println(mediaJobResponse);
    }

    public static void describeMediaJobs(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("examplebucket-1250000000");
        mediaJobsRequest.setQueueId("p9900025e4ec44b5e8225e70a521*****");
        mediaJobsRequest.setTag("Concat");
        mediaJobsRequest.setSize(100);
        MediaListJobResponse mediaListJobResponse = cOSClient.describeMediaJobs(mediaJobsRequest);
        List<MediaJobObject> list = mediaListJobResponse.getJobsDetailList();
        for (MediaJobObject mediaJobObject : list) {
            System.out.println(mediaJobObject);
        }
    }

    public static void cancelMediaJob(COSClient cOSClient) {
        MediaJobsRequest mediaJobsRequest = new MediaJobsRequest();
        mediaJobsRequest.setBucketName("examplebucket-1250000000");
        mediaJobsRequest.setJobId("jbfb0d02a092111ebb3167781d*****");
        Boolean bl = cOSClient.cancelMediaJob(mediaJobsRequest);
        System.out.println(bl);
    }
}

