/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.MultipleFileDownload;
import com.qcloud.cos.transfer.MultipleFileUpload;
import com.qcloud.cos.transfer.PersistableDownload;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TransferManagerDemo {
    private static void showTransferProgress(Transfer transfer) {
        System.out.println(transfer.getDescription());
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            TransferProgress transferProgress = transfer.getProgress();
            long l = transferProgress.getBytesTransferred();
            long l2 = transferProgress.getTotalBytesToTransfer();
            double d = transferProgress.getPercentTransferred();
            System.out.printf("[%d / %d] = %.02f%%\n", l, l2, d);
        } while (!transfer.isDone());
        System.out.println((Object)transfer.getState());
    }

    public static void uploadFile() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "aaa/bbb.txt";
        File file = new File("src/test/resources/len30M.txt");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        try {
            long l = System.currentTimeMillis();
            Upload upload = transferManager.upload(putObjectRequest);
            TransferManagerDemo.showTransferProgress(upload);
            UploadResult uploadResult = upload.waitForUploadResult();
            long l2 = System.currentTimeMillis();
            System.out.println("used time: " + (l2 - l) / 1000L);
            System.out.println(uploadResult.getETag());
            System.out.println(uploadResult.getCrc64Ecma());
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void pauseUploadFileAndResume() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "aaa/bbb.txt";
        File file = new File("src/test/resources/len30M.txt");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        try {
            Upload upload = transferManager.upload(putObjectRequest);
            Thread.sleep(10000L);
            PersistableUpload persistableUpload = upload.pause();
            upload = transferManager.resumeUpload(persistableUpload);
            TransferManagerDemo.showTransferProgress(upload);
            UploadResult uploadResult = upload.waitForUploadResult();
            System.out.println(uploadResult.getETag());
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void multipartUploadWithMetaData() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "aaa/bbb.txt";
        File file = new File("src/test/resources/len20M.txt");
        ObjectMetadata objectMetadata = new ObjectMetadata();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("usermeta", "hello-mult");
        objectMetadata.setUserMetadata(hashMap);
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        putObjectRequest.withMetadata(objectMetadata);
        try {
            long l = System.currentTimeMillis();
            Upload upload = transferManager.upload(putObjectRequest);
            UploadResult uploadResult = upload.waitForUploadResult();
            long l2 = System.currentTimeMillis();
            System.out.println("used time: " + (l2 - l) / 1000L);
            System.out.println(uploadResult.getETag());
            System.out.println(uploadResult.getCrc64Ecma());
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void uploadDirectory() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "/prefix";
        String string3 = "/to/mydir";
        Boolean bl = false;
        try {
            MultipleFileUpload multipleFileUpload = transferManager.uploadDirectory(string, string2, new File(string3), bl);
            TransferManagerDemo.showTransferProgress(multipleFileUpload);
            multipleFileUpload.waitForCompletion();
            System.out.println("upload directory done.");
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void downloadDirectory() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "/prefix";
        String string3 = "/to/mydir";
        try {
            MultipleFileDownload multipleFileDownload = transferManager.downloadDirectory(string, string2, new File(string3));
            TransferManagerDemo.showTransferProgress(multipleFileDownload);
            multipleFileDownload.waitForCompletion();
            System.out.println("download directory done.");
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void downLoadFile() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "aaa/bbb.txt";
        File file = new File("src/test/resources/download.txt");
        GetObjectRequest getObjectRequest = new GetObjectRequest(string, string2);
        try {
            Download download = transferManager.download(getObjectRequest, file);
            download.waitForCompletion();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void pauseDownloadFileAndResume() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        String string2 = "aaa/bbb.txt";
        File file = new File("src/test/resources/download.txt");
        GetObjectRequest getObjectRequest = new GetObjectRequest(string, string2);
        try {
            Download download = transferManager.download(getObjectRequest, file);
            Thread.sleep(5000L);
            PersistableDownload persistableDownload = download.pause();
            download = transferManager.resumeDownload(persistableDownload);
            TransferManagerDemo.showTransferProgress(download);
            download.waitForCompletion();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void copyFileForDiffRegion() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        Region region = new Region("ap-shanghai");
        String string = "srcBucket-1251668577";
        String string2 = "aaa/bbb.txt";
        String string3 = "destBucket-1251668577";
        String string4 = "ccc/ddd.txt";
        COSClient cOSClient2 = new COSClient(basicCOSCredentials, new ClientConfig(region));
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string, string2, string3, string4);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, cOSClient2, null);
            CopyResult copyResult = copy.waitForCopyResult();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient2.shutdown();
        cOSClient.shutdown();
    }

    public static void copyFileForSameRegion() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartCopyThreshold(0x1400000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        Region region = new Region("ap-beijing-1");
        String string = "srcBucket-1251668577";
        String string2 = "aaa/bbb.txt";
        String string3 = "destBucket-1251668577";
        String string4 = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string, string2, string3, string4);
        try {
            Copy copy = transferManager.copy(copyObjectRequest);
            CopyResult copyResult = copy.waitForCopyResult();
            System.out.println(copyResult.getCrc64Ecma());
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void copyFileSetMetadata() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        ClientConfig clientConfig2 = new ClientConfig(new Region("ap-shanghai"));
        COSClient cOSClient2 = new COSClient(basicCOSCredentials, clientConfig2);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartCopyThreshold(0x500000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        Region region = new Region("ap-shanghai");
        String string = "mysrcbucket-123456789";
        String string2 = "aaa/bbb.txt";
        String string3 = "mydestbucekt-123456789";
        String string4 = "bbb/ccc.txt";
        ObjectMetadata objectMetadata = new ObjectMetadata();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("usermeta", "hello-mult-copy");
        objectMetadata.setUserMetadata(hashMap);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string, string2, string3, string4);
        System.out.println(copyObjectRequest.getDestinationBucketName());
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, cOSClient2, null);
            CopyResult copyResult = copy.waitForCopyResult();
            System.out.println(copyResult.getCrc64Ecma());
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void resumableDownloadFile() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-shanghai"));
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        TransferManager transferManager = new TransferManager(cOSClient, executorService);
        GetObjectRequest getObjectRequest = new GetObjectRequest("mybucket-1000000000", "/path/to/key");
        File file = new File("dstFile");
        Download download = transferManager.download(getObjectRequest, file, true);
        TransferManagerDemo.showTransferProgress(download);
        try {
            download.waitForCompletion();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        transferManager.shutdownNow();
        cOSClient.shutdown();
    }

    public static void main(String[] stringArray) {
        TransferManagerDemo.resumableDownloadFile();
    }
}

