/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.LinkedList;

public class KmsUploadDemo {
    public static void main(String[] stringArray) {
        KmsUploadDemo.SimpleUploadWithKmsMeta();
        KmsUploadDemo.CopyObjectWithKmsMeta();
    }

    public static void SimpleUploadWithKmsMeta() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("SECRET_ID", "SECRET_KEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        String string2 = "aaa/bbb.txt";
        File file = new File("/test.log");
        PutObjectRequest putObjectRequest = new PutObjectRequest(string, string2, file);
        String string3 = "your-kms-key-id";
        String string4 = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());
        SSECOSKeyManagementParams sSECOSKeyManagementParams = new SSECOSKeyManagementParams(string3, string4);
        putObjectRequest.setSSECOSKeyManagementParams(sSECOSKeyManagementParams);
        System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
        try {
            PutObjectResult putObjectResult = cOSClient.putObject(putObjectRequest);
            String string5 = putObjectResult.getETag();
            String string6 = putObjectResult.getCrc64Ecma();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }

    public static void MultipartUploadWithKmsMeta() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("SECRET_ID", "SECRET_KEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "mybucket-1251668577";
        String string2 = "aaa/bbb.txt";
        String string3 = "your-kms-key-id";
        String string4 = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(string, string2);
        SSECOSKeyManagementParams sSECOSKeyManagementParams = new SSECOSKeyManagementParams(string3, string4);
        System.setProperty("com.Qcloud.services.cos.disablePutObjectMD5Validation", "true");
        initiateMultipartUploadRequest.setSSECOSKeyManagementParams(sSECOSKeyManagementParams);
        try {
            Object object;
            InitiateMultipartUploadResult initiateMultipartUploadResult = cOSClient.initiateMultipartUpload(initiateMultipartUploadRequest);
            LinkedList<PartETag> linkedList = new LinkedList<PartETag>();
            for (int i = 0; i < 2; ++i) {
                object = new byte[0x100000];
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(string);
                uploadPartRequest.setKey(string2);
                uploadPartRequest.setUploadId(initiateMultipartUploadResult.getUploadId());
                uploadPartRequest.setInputStream(new ByteArrayInputStream((byte[])object));
                uploadPartRequest.setPartSize(((byte[])object).length);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = cOSClient.uploadPart(uploadPartRequest);
                PartETag partETag = uploadPartResult.getPartETag();
                linkedList.add(partETag);
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(string, string2, initiateMultipartUploadResult.getUploadId(), linkedList);
            object = cOSClient.completeMultipartUpload(completeMultipartUploadRequest);
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }

    public static void CopyObjectWithKmsMeta() {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("SECRET_ID", "SECRET_KEY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cOSClient = new COSClient(basicCOSCredentials, clientConfig);
        String string = "your-kms-key-id";
        String string2 = Base64.encodeAsString("{\"Ssekmstest\":\"Ssekmstest\"}".getBytes());
        Region region = new Region("ap-guangzhou");
        String string3 = "mybucket-1251668577";
        String string4 = "aaa/bbb.txt";
        String string5 = "mybucket-1251668577";
        String string6 = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(region, string3, string4, string5, string6);
        copyObjectRequest.setSSECOSKeyManagementParams(new SSECOSKeyManagementParams(string, string2));
        try {
            CopyObjectResult copyObjectResult = cOSClient.copyObject(copyObjectRequest);
            String string7 = copyObjectResult.getCrc64Ecma();
        }
        catch (CosServiceException cosServiceException) {
            cosServiceException.printStackTrace();
        }
        catch (CosClientException cosClientException) {
            cosClientException.printStackTrace();
        }
        cOSClient.shutdown();
    }
}

