/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.StaticEncryptionMaterialsProvider;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class AsymmetricKeyEncryptionClientDemo {
    private static final String pubKeyPath = "pub.key";
    private static final String priKeyPath = "pri.key";
    private static final SecureRandom srand = new SecureRandom();
    static String bucketName = "mybucket-1251668577";
    static String key = "testKMS/asy.txt";
    static File localFile = new File("len1m.txt");
    static COSClient cosClient = AsymmetricKeyEncryptionClientDemo.createCosClient();

    static COSClient createCosClient() {
        return AsymmetricKeyEncryptionClientDemo.createCosClient("ap-guangzhou");
    }

    static COSClient createCosClient(String string) {
        BasicCOSCredentials basicCOSCredentials = new BasicCOSCredentials("AKIDxxxxxxxxxxxxxxxxxxxxxxxxxxx", "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
        ClientConfig clientConfig = new ClientConfig(new Region(string));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        KeyPair keyPair = null;
        try {
            keyPair = AsymmetricKeyEncryptionClientDemo.loadAsymKeyPair();
        }
        catch (Exception exception) {
            throw new CosClientException(exception);
        }
        EncryptionMaterials encryptionMaterials = new EncryptionMaterials(keyPair);
        CryptoConfiguration cryptoConfiguration = new CryptoConfiguration(CryptoMode.AesCtrEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
        COSEncryptionClient cOSEncryptionClient = new COSEncryptionClient(new COSStaticCredentialsProvider(basicCOSCredentials), new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfiguration);
        return cOSEncryptionClient;
    }

    private static void buildAndSaveAsymKeyPair() throws IOException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024, srand);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        FileOutputStream fileOutputStream = new FileOutputStream(pubKeyPath);
        fileOutputStream.write(x509EncodedKeySpec.getEncoded());
        fileOutputStream.close();
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        fileOutputStream = new FileOutputStream(priKeyPath);
        fileOutputStream.write(pKCS8EncodedKeySpec.getEncoded());
        fileOutputStream.close();
    }

    private static KeyPair loadAsymKeyPair() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File file = new File(pubKeyPath);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        File file2 = new File(priKeyPath);
        fileInputStream = new FileInputStream(file2);
        byte[] byArray2 = new byte[(int)file2.length()];
        fileInputStream.read(byArray2);
        fileInputStream.close();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    static void getObjectDemo() {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        File file = new File("downAsy.txt");
        ObjectMetadata objectMetadata = cosClient.getObject(getObjectRequest, file);
        System.out.println(objectMetadata.getRequestId());
    }

    static void putObjectDemo() {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        System.out.println(putObjectResult.getRequestId());
    }

    static void deleteObjectDemo() {
        cosClient.deleteObject(bucketName, key);
    }

    public static void main(String[] stringArray) throws Exception {
        AsymmetricKeyEncryptionClientDemo.putObjectDemo();
        AsymmetricKeyEncryptionClientDemo.getObjectDemo();
        cosClient.shutdown();
    }
}

