/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsFetcher;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceCredentialsUtils;
import com.qcloud.cos.exception.CosClientException;
import java.io.IOException;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpCredentialsFetcher
implements COSCredentialsFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCredentialsFetcher.class);
    private final CredentialsEndpointProvider cosCredentialsEndpointProvider;

    public abstract COSCredentials parse(String var1) throws CosClientException;

    protected HttpCredentialsFetcher(CredentialsEndpointProvider credentialsEndpointProvider) {
        this.cosCredentialsEndpointProvider = credentialsEndpointProvider;
    }

    @Override
    public COSCredentials fetch() throws CosClientException {
        if (null == this.cosCredentialsEndpointProvider) {
            String string = "The cos credentials endpoint provider is not specified.";
            LOG.error(string);
            throw new CosClientException(string);
        }
        try {
            String string = InstanceCredentialsUtils.getInstance().readResource(this.cosCredentialsEndpointProvider.getCredentialsEndpoint(), this.cosCredentialsEndpointProvider.getRetryPolicy(), this.cosCredentialsEndpointProvider.getHeaders());
            return this.parse(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CosClientException("The cos credentials uri is invalid.", uRISyntaxException);
        }
        catch (IOException iOException) {
            String string = String.format("The COSCredentialsFetcher [%s] fetch an exception.", this.getClass().getName());
            throw new CosClientException(string, iOException);
        }
    }

    @Override
    public COSCredentials fetch(int n) throws CosClientException {
        for (int i = 1; i <= n; ++i) {
            try {
                return this.fetch();
            }
            catch (CosClientException cosClientException) {
                String string = String.format("The COSCredentialsFetcher [%s] fetch failed, retry: %d/%d, exception:", this.getClass().getName(), i, n);
                LOG.error(string, cosClientException);
                continue;
            }
        }
        throw new CosClientException("Failed to fetch the CosCredentials from a instance metadata service: max retry times exceeded.");
    }
}

