/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCOSCachedCredentialsProvider
implements COSCredentialsProvider,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractCOSCachedCredentialsProvider.class);
    private volatile COSCredentials cachedCredentials = null;
    private volatile long lastRefreshTime = System.currentTimeMillis() / 1000L;
    private long refreshPeriodSeconds = 30L;
    private ScheduledExecutorService executors = null;

    public AbstractCOSCachedCredentialsProvider(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("refreshPeriodSeconds must be positive num");
        }
        this.refreshPeriodSeconds = l;
        this.executors = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable2) {
                Thread thread2 = Executors.defaultThreadFactory().newThread(runnable2);
                thread2.setName("credentials-refresh-daemon");
                thread2.setDaemon(true);
                return thread2;
            }
        });
        this.executors.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (AbstractCOSCachedCredentialsProvider.this.ifNeedToRefreshCredentials()) {
                    AbstractCOSCachedCredentialsProvider.this.updateCOSCredentials();
                }
            }
        }, 0L, l, TimeUnit.SECONDS);
    }

    public synchronized void updateCOSCredentials() {
        if (this.ifNeedToRefreshCredentials()) {
            COSCredentials cOSCredentials = null;
            try {
                cOSCredentials = this.fetchNewCOSCredentials();
                if (cOSCredentials != null) {
                    this.cachedCredentials = cOSCredentials;
                    this.updateRefreshTime();
                    log.info("update new cos credentials");
                } else {
                    log.error("fetchNewCOSCredentials return null");
                }
            }
            catch (Exception exception) {
                log.error("fetchNewCOSCredentials get exception.", exception);
            }
        }
    }

    private void updateRefreshTime() {
        this.lastRefreshTime = System.currentTimeMillis() / 1000L;
    }

    private boolean ifRefreshTimeExpired() {
        long l = System.currentTimeMillis() / 1000L;
        return l - this.lastRefreshTime >= this.refreshPeriodSeconds;
    }

    private boolean ifNeedToRefreshCredentials() {
        return this.cachedCredentials == null || this.ifRefreshTimeExpired();
    }

    @Override
    public COSCredentials getCredentials() {
        if (this.ifNeedToRefreshCredentials()) {
            this.updateCOSCredentials();
        }
        return this.cachedCredentials;
    }

    protected void finalize() throws Throwable {
        if (this.executors != null) {
            this.executors.shutdownNow();
            this.executors = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.executors != null) {
            this.executors.shutdownNow();
            this.executors = null;
        }
    }

    public abstract COSCredentials fetchNewCOSCredentials();
}

