/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class SimpleTimeLimiter
implements TimeLimiter {
    private final ExecutorService executor;

    private SimpleTimeLimiter(ExecutorService executorService) {
        this.executor = Preconditions.checkNotNull(executorService);
    }

    public static SimpleTimeLimiter create(ExecutorService executorService) {
        return new SimpleTimeLimiter(executorService);
    }

    @Override
    public <T> T newProxy(final T t2, Class<T> clazz, final long l, final TimeUnit timeUnit) {
        Preconditions.checkNotNull(t2);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(timeUnit);
        SimpleTimeLimiter.checkPositiveTimeout(l);
        Preconditions.checkArgument(clazz.isInterface(), "interfaceType must be an interface type");
        final Set<Method> set = SimpleTimeLimiter.findInterruptibleMethods(clazz);
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            @CheckForNull
            public Object invoke(Object object, Method method, @CheckForNull @Nullable Object[] objectArray) throws Throwable {
                Callable<@Nullable Object> callable = () -> {
                    try {
                        return method.invoke(t2, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw SimpleTimeLimiter.throwCause(invocationTargetException, false);
                    }
                };
                return SimpleTimeLimiter.this.callWithTimeout(callable, l, timeUnit, set.contains(method));
            }
        };
        return SimpleTimeLimiter.newProxy(clazz, invocationHandler);
    }

    private static <T> T newProxy(Class<T> clazz, InvocationHandler invocationHandler) {
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
        return clazz.cast(object);
    }

    @ParametricNullness
    private <T> T callWithTimeout(Callable<T> callable, long l, TimeUnit timeUnit, boolean bl) throws Exception {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeUnit);
        SimpleTimeLimiter.checkPositiveTimeout(l);
        Future<T> future = this.executor.submit(callable);
        try {
            return bl ? future.get(l, timeUnit) : Uninterruptibles.getUninterruptibly(future, l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            throw interruptedException;
        }
        catch (ExecutionException executionException) {
            throw SimpleTimeLimiter.throwCause(executionException, true);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw new UncheckedTimeoutException(timeoutException);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> callable, long l, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeUnit);
        SimpleTimeLimiter.checkPositiveTimeout(l);
        Future<T> future = this.executor.submit(callable);
        try {
            return future.get(l, timeUnit);
        }
        catch (InterruptedException | TimeoutException exception) {
            future.cancel(true);
            throw exception;
        }
        catch (ExecutionException executionException) {
            this.wrapAndThrowExecutionExceptionOrError(executionException.getCause());
            throw new AssertionError();
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long l, TimeUnit timeUnit) throws TimeoutException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeUnit);
        SimpleTimeLimiter.checkPositiveTimeout(l);
        Future<T> future = this.executor.submit(callable);
        try {
            return Uninterruptibles.getUninterruptibly(future, l, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw timeoutException;
        }
        catch (ExecutionException executionException) {
            this.wrapAndThrowExecutionExceptionOrError(executionException.getCause());
            throw new AssertionError();
        }
    }

    @Override
    public void runWithTimeout(Runnable runnable2, long l, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull(runnable2);
        Preconditions.checkNotNull(timeUnit);
        SimpleTimeLimiter.checkPositiveTimeout(l);
        Future<?> future = this.executor.submit(runnable2);
        try {
            future.get(l, timeUnit);
        }
        catch (InterruptedException | TimeoutException exception) {
            future.cancel(true);
            throw exception;
        }
        catch (ExecutionException executionException) {
            this.wrapAndThrowRuntimeExecutionExceptionOrError(executionException.getCause());
            throw new AssertionError();
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable2, long l, TimeUnit timeUnit) throws TimeoutException {
        Preconditions.checkNotNull(runnable2);
        Preconditions.checkNotNull(timeUnit);
        SimpleTimeLimiter.checkPositiveTimeout(l);
        Future<?> future = this.executor.submit(runnable2);
        try {
            Uninterruptibles.getUninterruptibly(future, l, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw timeoutException;
        }
        catch (ExecutionException executionException) {
            this.wrapAndThrowRuntimeExecutionExceptionOrError(executionException.getCause());
            throw new AssertionError();
        }
    }

    private static Exception throwCause(Exception exception, boolean bl) throws Exception {
        Throwable throwable = exception.getCause();
        if (throwable == null) {
            throw exception;
        }
        if (bl) {
            StackTraceElement[] stackTraceElementArray = ObjectArrays.concat(throwable.getStackTrace(), exception.getStackTrace(), StackTraceElement.class);
            throwable.setStackTrace(stackTraceElementArray);
        }
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw exception;
    }

    private static Set<Method> findInterruptibleMethods(Class<?> clazz) {
        HashSet<Method> hashSet = Sets.newHashSet();
        for (Method method : clazz.getMethods()) {
            if (!SimpleTimeLimiter.declaresInterruptedEx(method)) continue;
            hashSet.add(method);
        }
        return hashSet;
    }

    private static boolean declaresInterruptedEx(Method method) {
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (clazz != InterruptedException.class) continue;
            return true;
        }
        return false;
    }

    private void wrapAndThrowExecutionExceptionOrError(Throwable throwable) throws ExecutionException {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw new UncheckedExecutionException(throwable);
        }
        throw new ExecutionException(throwable);
    }

    private void wrapAndThrowRuntimeExecutionExceptionOrError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        throw new UncheckedExecutionException(throwable);
    }

    private static void checkPositiveTimeout(long l) {
        Preconditions.checkArgument(l > 0L, "timeout must be positive: %s", l);
    }
}

