/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.SequentialExecutor;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.common.util.concurrent.WrappingExecutorService;
import com.google.common.util.concurrent.WrappingScheduledExecutorService;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class MoreExecutors {
    private MoreExecutors() {
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor threadPoolExecutor, Duration duration) {
        return MoreExecutors.getExitingExecutorService(threadPoolExecutor, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor threadPoolExecutor, long l, TimeUnit timeUnit) {
        return new Application().getExitingExecutorService(threadPoolExecutor, l, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor threadPoolExecutor) {
        return new Application().getExitingExecutorService(threadPoolExecutor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, Duration duration) {
        return MoreExecutors.getExitingScheduledExecutorService(scheduledThreadPoolExecutor, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long l, TimeUnit timeUnit) {
        return new Application().getExitingScheduledExecutorService(scheduledThreadPoolExecutor, l, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return new Application().getExitingScheduledExecutorService(scheduledThreadPoolExecutor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void addDelayedShutdownHook(ExecutorService executorService, Duration duration) {
        MoreExecutors.addDelayedShutdownHook(executorService, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static void addDelayedShutdownHook(ExecutorService executorService, long l, TimeUnit timeUnit) {
        new Application().addDelayedShutdownHook(executorService, l, timeUnit);
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static void useDaemonThreadFactory(ThreadPoolExecutor threadPoolExecutor) {
        threadPoolExecutor.setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setThreadFactory(threadPoolExecutor.getThreadFactory()).build());
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ListeningExecutorService newDirectExecutorService() {
        return new DirectExecutorService();
    }

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Executor newSequentialExecutor(Executor executor) {
        return new SequentialExecutor(executor);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ListeningExecutorService listeningDecorator(ExecutorService executorService) {
        return executorService instanceof ListeningExecutorService ? (ListeningExecutorService)executorService : (executorService instanceof ScheduledExecutorService ? new ScheduledListeningDecorator((ScheduledExecutorService)executorService) : new ListeningDecorator(executorService));
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ListeningScheduledExecutorService listeningDecorator(ScheduledExecutorService scheduledExecutorService) {
        return scheduledExecutorService instanceof ListeningScheduledExecutorService ? (ListeningScheduledExecutorService)scheduledExecutorService : new ScheduledListeningDecorator(scheduledExecutorService);
    }

    @ParametricNullness
    @J2ktIncompatible
    @GwtIncompatible
    static <T> T invokeAnyImpl(ListeningExecutorService listeningExecutorService, Collection<? extends Callable<T>> collection, boolean bl, Duration duration) throws InterruptedException, ExecutionException, TimeoutException {
        return MoreExecutors.invokeAnyImpl(listeningExecutorService, collection, bl, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @ParametricNullness
    @J2ktIncompatible
    @GwtIncompatible
    static <T> T invokeAnyImpl(ListeningExecutorService listeningExecutorService, Collection<? extends Callable<T>> collection, boolean bl, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException executionException;
        ArrayList<ListenableFuture<T>> arrayList;
        block16: {
            Preconditions.checkNotNull(listeningExecutorService);
            Preconditions.checkNotNull(timeUnit);
            int n = collection.size();
            Preconditions.checkArgument(n > 0);
            arrayList = Lists.newArrayListWithCapacity(n);
            LinkedBlockingQueue<Future<T>> linkedBlockingQueue = Queues.newLinkedBlockingQueue();
            long l2 = timeUnit.toNanos(l);
            executionException = null;
            long l3 = bl ? System.nanoTime() : 0L;
            Iterator<Callable<T>> iterator2 = collection.iterator();
            arrayList.add(MoreExecutors.submitAndAddQueueListener(listeningExecutorService, iterator2.next(), linkedBlockingQueue));
            --n;
            int n2 = 1;
            while (true) {
                Object v;
                Future future;
                if ((future = (Future)linkedBlockingQueue.poll()) == null) {
                    if (n > 0) {
                        --n;
                        arrayList.add(MoreExecutors.submitAndAddQueueListener(listeningExecutorService, iterator2.next(), linkedBlockingQueue));
                        ++n2;
                    } else {
                        if (n2 == 0) break;
                        if (bl) {
                            future = (Future)linkedBlockingQueue.poll(l2, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            long l4 = System.nanoTime();
                            l2 -= l4 - l3;
                            l3 = l4;
                        } else {
                            future = (Future)linkedBlockingQueue.take();
                        }
                    }
                }
                if (future == null) continue;
                --n2;
                try {
                    v = future.get();
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception exception) {
                    executionException = new ExecutionException(exception);
                    continue;
                }
                return (T)v;
                break;
            }
            if (executionException != null) break block16;
            executionException = new ExecutionException(null);
        }
        throw executionException;
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static <T> ListenableFuture<T> submitAndAddQueueListener(ListeningExecutorService listeningExecutorService, Callable<T> callable, final BlockingQueue<Future<T>> blockingQueue) {
        Future future = listeningExecutorService.submit((Callable)callable);
        future.addListener(new Runnable((ListenableFuture)future){
            final /* synthetic */ ListenableFuture val$future;
            {
                this.val$future = listenableFuture;
            }

            @Override
            public void run() {
                blockingQueue.add(this.val$future);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static ThreadFactory platformThreadFactory() {
        if (!MoreExecutors.isAppEngineWithApiClasses()) {
            return Executors.defaultThreadFactory();
        }
        try {
            return (ThreadFactory)Class.forName("com.google.appengine.api.ThreadManager").getMethod("currentRequestThreadFactory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Throwables.propagate(invocationTargetException.getCause());
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static boolean isAppEngineWithApiClasses() {
        if (System.getProperty("com.google.appengine.runtime.environment") == null) {
            return false;
        }
        try {
            Class.forName("com.google.appengine.api.utils.SystemProperty");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        try {
            return Class.forName("com.google.apphosting.api.ApiProxy").getMethod("getCurrentEnvironment", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Thread newThread(String string, Runnable runnable2) {
        Preconditions.checkNotNull(string);
        Preconditions.checkNotNull(runnable2);
        Thread thread2 = Objects.requireNonNull(MoreExecutors.platformThreadFactory().newThread(runnable2));
        try {
            thread2.setName(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return thread2;
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Executor renamingDecorator(final Executor executor, final Supplier<String> supplier) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(supplier);
        return new Executor(){

            @Override
            public void execute(Runnable runnable2) {
                executor.execute(Callables.threadRenaming(runnable2, (Supplier<String>)supplier));
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static ExecutorService renamingDecorator(ExecutorService executorService, final Supplier<String> supplier) {
        Preconditions.checkNotNull(executorService);
        Preconditions.checkNotNull(supplier);
        return new WrappingExecutorService(executorService){

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Callables.threadRenaming(callable, (Supplier<String>)supplier);
            }

            @Override
            protected Runnable wrapTask(Runnable runnable2) {
                return Callables.threadRenaming(runnable2, (Supplier<String>)supplier);
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static ScheduledExecutorService renamingDecorator(ScheduledExecutorService scheduledExecutorService, final Supplier<String> supplier) {
        Preconditions.checkNotNull(scheduledExecutorService);
        Preconditions.checkNotNull(supplier);
        return new WrappingScheduledExecutorService(scheduledExecutorService){

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Callables.threadRenaming(callable, (Supplier<String>)supplier);
            }

            @Override
            protected Runnable wrapTask(Runnable runnable2) {
                return Callables.threadRenaming(runnable2, (Supplier<String>)supplier);
            }
        };
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static boolean shutdownAndAwaitTermination(ExecutorService executorService, Duration duration) {
        return MoreExecutors.shutdownAndAwaitTermination(executorService, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    @J2ktIncompatible
    @GwtIncompatible
    public static boolean shutdownAndAwaitTermination(ExecutorService executorService, long l, TimeUnit timeUnit) {
        long l2 = timeUnit.toNanos(l) / 2L;
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(l2, TimeUnit.NANOSECONDS)) {
                executorService.shutdownNow();
                executorService.awaitTermination(l2, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            executorService.shutdownNow();
        }
        return executorService.isTerminated();
    }

    static Executor rejectionPropagatingExecutor(final Executor executor, final AbstractFuture<?> abstractFuture) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(abstractFuture);
        if (executor == MoreExecutors.directExecutor()) {
            return executor;
        }
        return new Executor(){

            @Override
            public void execute(Runnable runnable2) {
                try {
                    executor.execute(runnable2);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    abstractFuture.setException(rejectedExecutionException);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static final class ScheduledListeningDecorator
    extends ListeningDecorator
    implements ListeningScheduledExecutorService {
        final ScheduledExecutorService delegate;

        ScheduledListeningDecorator(ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService);
            this.delegate = Preconditions.checkNotNull(scheduledExecutorService);
        }

        @Override
        public ListenableScheduledFuture<?> schedule(Runnable runnable2, long l, TimeUnit timeUnit) {
            TrustedListenableFutureTask<@Nullable Object> trustedListenableFutureTask = TrustedListenableFutureTask.create(runnable2, null);
            ScheduledFuture<?> scheduledFuture = this.delegate.schedule(trustedListenableFutureTask, l, timeUnit);
            return new ListenableScheduledTask<Object>(trustedListenableFutureTask, scheduledFuture);
        }

        @Override
        public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
            TrustedListenableFutureTask<V> trustedListenableFutureTask = TrustedListenableFutureTask.create(callable);
            ScheduledFuture<?> scheduledFuture = this.delegate.schedule(trustedListenableFutureTask, l, timeUnit);
            return new ListenableScheduledTask<V>(trustedListenableFutureTask, scheduledFuture);
        }

        @Override
        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable runnable2, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask(runnable2);
            ScheduledFuture<?> scheduledFuture = this.delegate.scheduleAtFixedRate(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            return new ListenableScheduledTask<Void>(neverSuccessfulListenableFutureTask, scheduledFuture);
        }

        @Override
        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable2, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask(runnable2);
            ScheduledFuture<?> scheduledFuture = this.delegate.scheduleWithFixedDelay(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            return new ListenableScheduledTask<Void>(neverSuccessfulListenableFutureTask, scheduledFuture);
        }

        @J2ktIncompatible
        @GwtIncompatible
        private static final class NeverSuccessfulListenableFutureTask
        extends AbstractFuture.TrustedFuture<Void>
        implements Runnable {
            private final Runnable delegate;

            public NeverSuccessfulListenableFutureTask(Runnable runnable2) {
                this.delegate = Preconditions.checkNotNull(runnable2);
            }

            @Override
            public void run() {
                try {
                    this.delegate.run();
                }
                catch (Throwable throwable) {
                    this.setException(throwable);
                    throw throwable;
                }
            }

            @Override
            protected String pendingToString() {
                return "task=[" + this.delegate + "]";
            }
        }

        private static final class ListenableScheduledTask<V>
        extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
        implements ListenableScheduledFuture<V> {
            private final ScheduledFuture<?> scheduledDelegate;

            public ListenableScheduledTask(ListenableFuture<V> listenableFuture, ScheduledFuture<?> scheduledFuture) {
                super(listenableFuture);
                this.scheduledDelegate = scheduledFuture;
            }

            @Override
            public boolean cancel(boolean bl) {
                boolean bl2 = super.cancel(bl);
                if (bl2) {
                    this.scheduledDelegate.cancel(bl);
                }
                return bl2;
            }

            @Override
            public long getDelay(TimeUnit timeUnit) {
                return this.scheduledDelegate.getDelay(timeUnit);
            }

            @Override
            public int compareTo(Delayed delayed) {
                return this.scheduledDelegate.compareTo(delayed);
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static class ListeningDecorator
    extends AbstractListeningExecutorService {
        private final ExecutorService delegate;

        ListeningDecorator(ExecutorService executorService) {
            this.delegate = Preconditions.checkNotNull(executorService);
        }

        @Override
        public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.awaitTermination(l, timeUnit);
        }

        @Override
        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public final void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public final List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public final void execute(Runnable runnable2) {
            this.delegate.execute(runnable2);
        }

        public final String toString() {
            return super.toString() + "[" + this.delegate + "]";
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static final class DirectExecutorService
    extends AbstractListeningExecutorService {
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private int runningTasks = 0;
        @GuardedBy(value="lock")
        private boolean shutdown = false;

        private DirectExecutorService() {
        }

        @Override
        public void execute(Runnable runnable2) {
            this.startTask();
            try {
                runnable2.run();
            }
            finally {
                this.endTask();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isShutdown() {
            Object object = this.lock;
            synchronized (object) {
                return this.shutdown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            Object object = this.lock;
            synchronized (object) {
                this.shutdown = true;
                if (this.runningTasks == 0) {
                    this.lock.notifyAll();
                }
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown();
            return Collections.emptyList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isTerminated() {
            Object object = this.lock;
            synchronized (object) {
                return this.shutdown && this.runningTasks == 0;
            }
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            long l2 = timeUnit.toNanos(l);
            Object object = this.lock;
            synchronized (object) {
                while (true) {
                    if (this.shutdown && this.runningTasks == 0) {
                        return true;
                    }
                    if (l2 <= 0L) {
                        return false;
                    }
                    long l3 = System.nanoTime();
                    TimeUnit.NANOSECONDS.timedWait(this.lock, l2);
                    l2 -= System.nanoTime() - l3;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startTask() {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdown) {
                    throw new RejectedExecutionException("Executor already shutdown");
                }
                ++this.runningTasks;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endTask() {
            Object object = this.lock;
            synchronized (object) {
                int n = --this.runningTasks;
                if (n == 0) {
                    this.lock.notifyAll();
                }
            }
        }
    }

    @J2ktIncompatible
    @GwtIncompatible
    @VisibleForTesting
    static class Application {
        Application() {
        }

        final ExecutorService getExitingExecutorService(ThreadPoolExecutor threadPoolExecutor, long l, TimeUnit timeUnit) {
            MoreExecutors.useDaemonThreadFactory(threadPoolExecutor);
            ExecutorService executorService = Executors.unconfigurableExecutorService(threadPoolExecutor);
            this.addDelayedShutdownHook(threadPoolExecutor, l, timeUnit);
            return executorService;
        }

        final ExecutorService getExitingExecutorService(ThreadPoolExecutor threadPoolExecutor) {
            return this.getExitingExecutorService(threadPoolExecutor, 120L, TimeUnit.SECONDS);
        }

        final ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long l, TimeUnit timeUnit) {
            MoreExecutors.useDaemonThreadFactory(scheduledThreadPoolExecutor);
            ScheduledExecutorService scheduledExecutorService = Executors.unconfigurableScheduledExecutorService(scheduledThreadPoolExecutor);
            this.addDelayedShutdownHook(scheduledThreadPoolExecutor, l, timeUnit);
            return scheduledExecutorService;
        }

        final ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
            return this.getExitingScheduledExecutorService(scheduledThreadPoolExecutor, 120L, TimeUnit.SECONDS);
        }

        final void addDelayedShutdownHook(final ExecutorService executorService, final long l, final TimeUnit timeUnit) {
            Preconditions.checkNotNull(executorService);
            Preconditions.checkNotNull(timeUnit);
            this.addShutdownHook(MoreExecutors.newThread("DelayedShutdownHook-for-" + executorService, new Runnable(this){

                @Override
                public void run() {
                    try {
                        executorService.shutdown();
                        executorService.awaitTermination(l, timeUnit);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }));
        }

        @VisibleForTesting
        void addShutdownHook(Thread thread2) {
            Runtime.getRuntime().addShutdownHook(thread2);
        }
    }
}

