/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public interface ListeningScheduledExecutorService
extends ListeningExecutorService,
ScheduledExecutorService {
    public ListenableScheduledFuture<?> schedule(Runnable var1, long var2, TimeUnit var4);

    default public ListenableScheduledFuture<?> schedule(Runnable runnable2, Duration duration) {
        return this.schedule(runnable2, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> var1, long var2, TimeUnit var4);

    default public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, Duration duration) {
        return this.schedule((Callable)callable, Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
    }

    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable var1, long var2, long var4, TimeUnit var6);

    default public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable runnable2, Duration duration, Duration duration2) {
        return this.scheduleAtFixedRate(runnable2, Internal.toNanosSaturated(duration), Internal.toNanosSaturated(duration2), TimeUnit.NANOSECONDS);
    }

    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, long var2, long var4, TimeUnit var6);

    default public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable2, Duration duration, Duration duration2) {
        return this.scheduleWithFixedDelay(runnable2, Internal.toNanosSaturated(duration), Internal.toNanosSaturated(duration2), TimeUnit.NANOSECONDS);
    }
}

