/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.LazyLogger;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.logging.Level;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
final class ListenerCallQueue<L> {
    private static final LazyLogger logger = new LazyLogger(ListenerCallQueue.class);
    private final List<PerListenerQueue<L>> listeners = Collections.synchronizedList(new ArrayList());

    ListenerCallQueue() {
    }

    public void addListener(L l, Executor executor) {
        Preconditions.checkNotNull(l, "listener");
        Preconditions.checkNotNull(executor, "executor");
        this.listeners.add(new PerListenerQueue<L>(l, executor));
    }

    public void enqueue(Event<L> event) {
        this.enqueueHelper(event, event);
    }

    public void enqueue(Event<L> event, String string) {
        this.enqueueHelper(event, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueHelper(Event<L> event, Object object) {
        Preconditions.checkNotNull(event, "event");
        Preconditions.checkNotNull(object, "label");
        List<PerListenerQueue<L>> list = this.listeners;
        synchronized (list) {
            for (PerListenerQueue<L> perListenerQueue : this.listeners) {
                perListenerQueue.add(event, object);
            }
        }
    }

    public void dispatch() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).dispatch();
        }
    }

    private static final class PerListenerQueue<L>
    implements Runnable {
        final L listener;
        final Executor executor;
        @GuardedBy(value="this")
        final Queue<Event<L>> waitQueue = Queues.newArrayDeque();
        @GuardedBy(value="this")
        final Queue<Object> labelQueue = Queues.newArrayDeque();
        @GuardedBy(value="this")
        boolean isThreadScheduled;

        PerListenerQueue(L l, Executor executor) {
            this.listener = Preconditions.checkNotNull(l);
            this.executor = Preconditions.checkNotNull(executor);
        }

        synchronized void add(Event<L> event, Object object) {
            this.waitQueue.add(event);
            this.labelQueue.add(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch() {
            boolean bl = false;
            PerListenerQueue perListenerQueue = this;
            synchronized (perListenerQueue) {
                if (!this.isThreadScheduled) {
                    this.isThreadScheduled = true;
                    bl = true;
                }
            }
            if (bl) {
                try {
                    this.executor.execute(this);
                }
                catch (Exception exception) {
                    PerListenerQueue perListenerQueue2 = this;
                    synchronized (perListenerQueue2) {
                        this.isThreadScheduled = false;
                    }
                    logger.get().log(Level.SEVERE, "Exception while running callbacks for " + this.listener + " on " + this.executor, exception);
                    throw exception;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                Object object;
                boolean bl = true;
                block14: while (true) {
                    while (true) {
                        Object object2;
                        PerListenerQueue perListenerQueue = this;
                        synchronized (perListenerQueue) {
                            Preconditions.checkState(this.isThreadScheduled);
                            object = this.waitQueue.poll();
                            object2 = this.labelQueue.poll();
                            if (object == null) {
                                this.isThreadScheduled = false;
                                bl = false;
                                break block18;
                            }
                        }
                        try {
                            object.call(this.listener);
                            continue block14;
                        }
                        catch (Exception exception) {
                            logger.get().log(Level.SEVERE, "Exception while executing callback: " + this.listener + " " + object2, exception);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (bl) {
                        object = this;
                        synchronized (object) {
                            this.isThreadScheduled = false;
                        }
                    }
                }
            }
        }
    }

    static interface Event<L> {
        public void call(L var1);
    }
}

