/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Platform;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    @CanIgnoreReturnValue
    public <T> T newProxy(T t2, Class<T> clazz, long l, TimeUnit timeUnit) {
        Preconditions.checkNotNull(t2);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(timeUnit);
        return t2;
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> callable, long l, TimeUnit timeUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException runtimeException) {
            throw new UncheckedExecutionException(runtimeException);
        }
        catch (Exception exception) {
            Platform.restoreInterruptIfIsInterruptedException(exception);
            throw new ExecutionException(exception);
        }
        catch (Error error) {
            throw new ExecutionError(error);
        }
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long l, TimeUnit timeUnit) throws ExecutionException {
        return this.callWithTimeout(callable, l, timeUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable2, long l, TimeUnit timeUnit) {
        Preconditions.checkNotNull(runnable2);
        Preconditions.checkNotNull(timeUnit);
        try {
            runnable2.run();
        }
        catch (Exception exception) {
            throw new UncheckedExecutionException(exception);
        }
        catch (Error error) {
            throw new ExecutionError(error);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable2, long l, TimeUnit timeUnit) {
        this.runWithTimeout(runnable2, l, timeUnit);
    }
}

