/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.Callable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(@ParametricNullness T t2) {
        return () -> t2;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <T> AsyncCallable<T> asAsyncCallable(Callable<T> callable, ListeningExecutorService listeningExecutorService) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(listeningExecutorService);
        return () -> listeningExecutorService.submit(callable);
    }

    @J2ktIncompatible
    @GwtIncompatible
    static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> supplier) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull(callable);
        return () -> {
            Thread thread2 = Thread.currentThread();
            String string = thread2.getName();
            boolean bl = Callables.trySetName((String)supplier.get(), thread2);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (bl) {
                    boolean bl2 = Callables.trySetName(string, thread2);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Runnable threadRenaming(Runnable runnable2, Supplier<String> supplier) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull(runnable2);
        return () -> {
            Thread thread2 = Thread.currentThread();
            String string = thread2.getName();
            boolean bl = Callables.trySetName((String)supplier.get(), thread2);
            try {
                runnable2.run();
            }
            finally {
                if (bl) {
                    boolean bl2 = Callables.trySetName(string, thread2);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static boolean trySetName(String string, Thread thread2) {
        try {
            thread2.setName(string);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

