/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int n) {
        this.longs = new AtomicLongArray(n);
    }

    public AtomicDoubleArray(double[] dArray) {
        int n = dArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = Double.doubleToRawLongBits(dArray[i]);
        }
        this.longs = new AtomicLongArray(lArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int n) {
        return Double.longBitsToDouble(this.longs.get(n));
    }

    public final void set(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        this.longs.set(n, l);
    }

    public final void lazySet(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        this.longs.lazySet(n, l);
    }

    public final double getAndSet(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        return Double.longBitsToDouble(this.longs.getAndSet(n, l));
    }

    public final boolean compareAndSet(int n, double d, double d2) {
        return this.longs.compareAndSet(n, Double.doubleToRawLongBits(d), Double.doubleToRawLongBits(d2));
    }

    public final boolean weakCompareAndSet(int n, double d, double d2) {
        return this.longs.weakCompareAndSet(n, Double.doubleToRawLongBits(d), Double.doubleToRawLongBits(d2));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int n, double d) {
        return this.getAndAccumulate(n, d, Double::sum);
    }

    @CanIgnoreReturnValue
    public double addAndGet(int n, double d) {
        return this.accumulateAndGet(n, d, Double::sum);
    }

    @CanIgnoreReturnValue
    public final double getAndAccumulate(int n, double d, DoubleBinaryOperator doubleBinaryOperator) {
        Preconditions.checkNotNull(doubleBinaryOperator);
        return this.getAndUpdate(n, d2 -> doubleBinaryOperator.applyAsDouble(d2, d));
    }

    @CanIgnoreReturnValue
    public final double accumulateAndGet(int n, double d, DoubleBinaryOperator doubleBinaryOperator) {
        Preconditions.checkNotNull(doubleBinaryOperator);
        return this.updateAndGet(n, d2 -> doubleBinaryOperator.applyAsDouble(d2, d));
    }

    @CanIgnoreReturnValue
    public final double getAndUpdate(int n, DoubleUnaryOperator doubleUnaryOperator) {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.longs.compareAndSet(n, l2 = this.longs.get(n), l = Double.doubleToRawLongBits(d2 = doubleUnaryOperator.applyAsDouble(d = Double.longBitsToDouble(l2))))) {
        }
        return d;
    }

    @CanIgnoreReturnValue
    public final double updateAndGet(int n, DoubleUnaryOperator doubleUnaryOperator) {
        double d;
        double d2;
        long l;
        long l2;
        while (!this.longs.compareAndSet(n, l2 = this.longs.get(n), l = Double.doubleToRawLongBits(d2 = doubleUnaryOperator.applyAsDouble(d = Double.longBitsToDouble(l2))))) {
        }
        return d2;
    }

    public String toString() {
        int n = this.length() - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(19 * (n + 1));
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(Double.longBitsToDouble(this.longs.get(n2)));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.length();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeDouble(this.get(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i = 0; i < n; ++i) {
            builder.add(Double.doubleToRawLongBits(objectInputStream.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

