/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.LazyLogger;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Platform;
import com.google.common.util.concurrent.Service;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractScheduledService
implements Service {
    private static final LazyLogger logger = new LazyLogger(AbstractScheduledService.class);
    private final AbstractService delegate = new ServiceDelegate();

    protected AbstractScheduledService() {
    }

    protected abstract void runOneIteration() throws Exception;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    protected abstract Scheduler scheduler();

    protected ScheduledExecutorService executor() {
        class ThreadFactoryImpl
        implements ThreadFactory {
            ThreadFactoryImpl() {
            }

            @Override
            public Thread newThread(Runnable runnable2) {
                return MoreExecutors.newThread(AbstractScheduledService.this.serviceName(), runnable2);
            }
        }
        final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryImpl());
        this.addListener(new Service.Listener(this){

            @Override
            public void terminated(Service.State state) {
                scheduledExecutorService.shutdown();
            }

            @Override
            public void failed(Service.State state, Throwable throwable) {
                scheduledExecutorService.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return scheduledExecutorService;
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.serviceName() + " [" + (Object)((Object)this.state()) + "]";
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    @CanIgnoreReturnValue
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    @Override
    public final void awaitRunning(Duration duration) throws TimeoutException {
        Service.super.awaitRunning(duration);
    }

    @Override
    public final void awaitRunning(long l, TimeUnit timeUnit) throws TimeoutException {
        this.delegate.awaitRunning(l, timeUnit);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    @Override
    public final void awaitTerminated(Duration duration) throws TimeoutException {
        Service.super.awaitTerminated(duration);
    }

    @Override
    public final void awaitTerminated(long l, TimeUnit timeUnit) throws TimeoutException {
        this.delegate.awaitTerminated(l, timeUnit);
    }

    public static abstract class CustomScheduler
    extends Scheduler {
        @Override
        final Cancellable schedule(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
            return new ReschedulableCallable(abstractService, scheduledExecutorService, runnable2).reschedule();
        }

        protected abstract Schedule getNextSchedule() throws Exception;

        protected static final class Schedule {
            private final long delay;
            private final TimeUnit unit;

            public Schedule(long l, TimeUnit timeUnit) {
                this.delay = l;
                this.unit = Preconditions.checkNotNull(timeUnit);
            }

            public Schedule(Duration duration) {
                this(Internal.toNanosSaturated(duration), TimeUnit.NANOSECONDS);
            }
        }

        private static final class SupplantableFuture
        implements Cancellable {
            private final ReentrantLock lock;
            @GuardedBy(value="lock")
            private Future<@Nullable Void> currentFuture;

            SupplantableFuture(ReentrantLock reentrantLock, Future<@Nullable Void> future) {
                this.lock = reentrantLock;
                this.currentFuture = future;
            }

            @Override
            public void cancel(boolean bl) {
                this.lock.lock();
                try {
                    this.currentFuture.cancel(bl);
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public boolean isCancelled() {
                this.lock.lock();
                try {
                    boolean bl = this.currentFuture.isCancelled();
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private final class ReschedulableCallable
        implements Callable<Void> {
            private final Runnable wrappedRunnable;
            private final ScheduledExecutorService executor;
            private final AbstractService service;
            private final ReentrantLock lock = new ReentrantLock();
            @CheckForNull
            @GuardedBy(value="lock")
            private SupplantableFuture cancellationDelegate;

            ReschedulableCallable(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
                this.wrappedRunnable = runnable2;
                this.executor = scheduledExecutorService;
                this.service = abstractService;
            }

            @Override
            @CheckForNull
            public Void call() throws Exception {
                this.wrappedRunnable.run();
                this.reschedule();
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CanIgnoreReturnValue
            public Cancellable reschedule() {
                Cancellable cancellable;
                Schedule schedule2;
                try {
                    schedule2 = CustomScheduler.this.getNextSchedule();
                }
                catch (Throwable throwable) {
                    Platform.restoreInterruptIfIsInterruptedException(throwable);
                    this.service.notifyFailed(throwable);
                    return new FutureAsCancellable(Futures.immediateCancelledFuture());
                }
                Throwable throwable = null;
                this.lock.lock();
                try {
                    cancellable = this.initializeOrUpdateCancellationDelegate(schedule2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    cancellable = new FutureAsCancellable(Futures.immediateCancelledFuture());
                }
                finally {
                    this.lock.unlock();
                }
                if (throwable != null) {
                    this.service.notifyFailed(throwable);
                }
                return cancellable;
            }

            @GuardedBy(value="lock")
            private Cancellable initializeOrUpdateCancellationDelegate(Schedule schedule2) {
                if (this.cancellationDelegate == null) {
                    this.cancellationDelegate = new SupplantableFuture(this.lock, this.submitToExecutor(schedule2));
                    return this.cancellationDelegate;
                }
                if (!this.cancellationDelegate.currentFuture.isCancelled()) {
                    this.cancellationDelegate.currentFuture = this.submitToExecutor(schedule2);
                }
                return this.cancellationDelegate;
            }

            private ScheduledFuture<@Nullable Void> submitToExecutor(Schedule schedule2) {
                return this.executor.schedule(this, schedule2.delay, schedule2.unit);
            }
        }
    }

    private static final class FutureAsCancellable
    implements Cancellable {
        private final Future<?> delegate;

        FutureAsCancellable(Future<?> future) {
            this.delegate = future;
        }

        @Override
        public void cancel(boolean bl) {
            this.delegate.cancel(bl);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    static interface Cancellable {
        public void cancel(boolean var1);

        public boolean isCancelled();
    }

    private final class ServiceDelegate
    extends AbstractService {
        @CheckForNull
        private volatile Cancellable runningTask;
        @CheckForNull
        private volatile ScheduledExecutorService executorService;
        private final ReentrantLock lock = new ReentrantLock();
        private final Runnable task = new Task();

        private ServiceDelegate() {
        }

        @Override
        protected final void doStart() {
            this.executorService = MoreExecutors.renamingDecorator(AbstractScheduledService.this.executor(), () -> AbstractScheduledService.this.serviceName() + " " + (Object)((Object)this.state()));
            this.executorService.execute(() -> {
                this.lock.lock();
                try {
                    AbstractScheduledService.this.startUp();
                    Objects.requireNonNull(this.executorService);
                    this.runningTask = AbstractScheduledService.this.scheduler().schedule(AbstractScheduledService.this.delegate, this.executorService, this.task);
                    this.notifyStarted();
                }
                catch (Throwable throwable) {
                    Platform.restoreInterruptIfIsInterruptedException(throwable);
                    this.notifyFailed(throwable);
                    if (this.runningTask != null) {
                        this.runningTask.cancel(false);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        @Override
        protected final void doStop() {
            Objects.requireNonNull(this.runningTask);
            Objects.requireNonNull(this.executorService);
            this.runningTask.cancel(false);
            this.executorService.execute(() -> {
                try {
                    this.lock.lock();
                    try {
                        if (this.state() != Service.State.STOPPING) {
                            return;
                        }
                        AbstractScheduledService.this.shutDown();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    this.notifyStopped();
                }
                catch (Throwable throwable) {
                    Platform.restoreInterruptIfIsInterruptedException(throwable);
                    this.notifyFailed(throwable);
                }
            });
        }

        @Override
        public String toString() {
            return AbstractScheduledService.this.toString();
        }

        class Task
        implements Runnable {
            Task() {
            }

            @Override
            public void run() {
                ServiceDelegate.this.lock.lock();
                try {
                    if (Objects.requireNonNull(ServiceDelegate.this.runningTask).isCancelled()) {
                        return;
                    }
                    AbstractScheduledService.this.runOneIteration();
                }
                catch (Throwable throwable) {
                    Platform.restoreInterruptIfIsInterruptedException(throwable);
                    try {
                        AbstractScheduledService.this.shutDown();
                    }
                    catch (Exception exception) {
                        Platform.restoreInterruptIfIsInterruptedException(exception);
                        logger.get().log(Level.WARNING, "Error while attempting to shut down the service after failure.", exception);
                    }
                    ServiceDelegate.this.notifyFailed(throwable);
                    Objects.requireNonNull(ServiceDelegate.this.runningTask).cancel(false);
                }
                finally {
                    ServiceDelegate.this.lock.unlock();
                }
            }
        }
    }

    public static abstract class Scheduler {
        public static Scheduler newFixedDelaySchedule(Duration duration, Duration duration2) {
            return Scheduler.newFixedDelaySchedule(Internal.toNanosSaturated(duration), Internal.toNanosSaturated(duration2), TimeUnit.NANOSECONDS);
        }

        public static Scheduler newFixedDelaySchedule(final long l, final long l2, final TimeUnit timeUnit) {
            Preconditions.checkNotNull(timeUnit);
            Preconditions.checkArgument(l2 > 0L, "delay must be > 0, found %s", l2);
            return new Scheduler(){

                @Override
                public Cancellable schedule(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
                    return new FutureAsCancellable(scheduledExecutorService.scheduleWithFixedDelay(runnable2, l, l2, timeUnit));
                }
            };
        }

        public static Scheduler newFixedRateSchedule(Duration duration, Duration duration2) {
            return Scheduler.newFixedRateSchedule(Internal.toNanosSaturated(duration), Internal.toNanosSaturated(duration2), TimeUnit.NANOSECONDS);
        }

        public static Scheduler newFixedRateSchedule(final long l, final long l2, final TimeUnit timeUnit) {
            Preconditions.checkNotNull(timeUnit);
            Preconditions.checkArgument(l2 > 0L, "period must be > 0, found %s", l2);
            return new Scheduler(){

                @Override
                public Cancellable schedule(AbstractService abstractService, ScheduledExecutorService scheduledExecutorService, Runnable runnable2) {
                    return new FutureAsCancellable(scheduledExecutorService.scheduleAtFixedRate(runnable2, l, l2, timeUnit));
                }
            };
        }

        abstract Cancellable schedule(AbstractService var1, ScheduledExecutorService var2, Runnable var3);

        private Scheduler() {
        }
    }
}

