/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.thirdparty.publicsuffix.PublicSuffixPatterns;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.List;
import javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class InternetDomainName {
    private static final CharMatcher DOTS_MATCHER = CharMatcher.anyOf(".\u3002\uff0e\uff61");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');
    private static final int NO_SUFFIX_FOUND = -1;
    private static final int SUFFIX_NOT_INITIALIZED = -2;
    private static final int MAX_PARTS = 127;
    private static final int MAX_LENGTH = 253;
    private static final int MAX_DOMAIN_PART_LENGTH = 63;
    private final String name;
    private final ImmutableList<String> parts;
    @LazyInit
    private int publicSuffixIndexCache = -2;
    @LazyInit
    private int registrySuffixIndexCache = -2;
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf("-_");
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange('0', '9');
    private static final CharMatcher LETTER_MATCHER = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z'));
    private static final CharMatcher PART_CHAR_MATCHER = DIGIT_MATCHER.or(LETTER_MATCHER).or(DASH_MATCHER);

    InternetDomainName(String string) {
        string = Ascii.toLowerCase(DOTS_MATCHER.replaceFrom((CharSequence)string, '.'));
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        Preconditions.checkArgument(string.length() <= 253, "Domain name too long: '%s':", (Object)string);
        this.name = string;
        this.parts = ImmutableList.copyOf(DOT_SPLITTER.split(string));
        Preconditions.checkArgument(this.parts.size() <= 127, "Domain has too many parts: '%s'", (Object)string);
        Preconditions.checkArgument(InternetDomainName.validateSyntax(this.parts), "Not a valid domain name: '%s'", (Object)string);
    }

    private InternetDomainName(String string, ImmutableList<String> immutableList) {
        Preconditions.checkArgument(!immutableList.isEmpty(), "Cannot create an InternetDomainName with zero parts.");
        this.name = string;
        this.parts = immutableList;
    }

    private int publicSuffixIndex() {
        int n = this.publicSuffixIndexCache;
        if (n == -2) {
            this.publicSuffixIndexCache = n = this.findSuffixOfType(Optional.absent());
        }
        return n;
    }

    private int registrySuffixIndex() {
        int n = this.registrySuffixIndexCache;
        if (n == -2) {
            this.registrySuffixIndexCache = n = this.findSuffixOfType(Optional.of(PublicSuffixType.REGISTRY));
        }
        return n;
    }

    private int findSuffixOfType(Optional<PublicSuffixType> optional) {
        int n = this.parts.size();
        for (int i = 0; i < n; ++i) {
            String string = DOT_JOINER.join(this.parts.subList(i, n));
            if (i > 0 && InternetDomainName.matchesType(optional, Optional.fromNullable(PublicSuffixPatterns.UNDER.get(string)))) {
                return i - 1;
            }
            if (InternetDomainName.matchesType(optional, Optional.fromNullable(PublicSuffixPatterns.EXACT.get(string)))) {
                return i;
            }
            if (!PublicSuffixPatterns.EXCLUDED.containsKey(string)) continue;
            return i + 1;
        }
        return -1;
    }

    @CanIgnoreReturnValue
    public static InternetDomainName from(String string) {
        return new InternetDomainName(Preconditions.checkNotNull(string));
    }

    private static boolean validateSyntax(List<String> list) {
        int n = list.size() - 1;
        if (!InternetDomainName.validatePart(list.get(n), true)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (InternetDomainName.validatePart(string, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean validatePart(String string, boolean bl) {
        if (string.length() < 1 || string.length() > 63) {
            return false;
        }
        String string2 = CharMatcher.ascii().retainFrom(string);
        if (!PART_CHAR_MATCHER.matchesAllOf(string2)) {
            return false;
        }
        if (DASH_MATCHER.matches(string.charAt(0)) || DASH_MATCHER.matches(string.charAt(string.length() - 1))) {
            return false;
        }
        return !bl || !DIGIT_MATCHER.matches(string.charAt(0));
    }

    public ImmutableList<String> parts() {
        return this.parts;
    }

    public boolean isPublicSuffix() {
        return this.publicSuffixIndex() == 0;
    }

    public boolean hasPublicSuffix() {
        return this.publicSuffixIndex() != -1;
    }

    @CheckForNull
    public InternetDomainName publicSuffix() {
        return this.hasPublicSuffix() ? this.ancestor(this.publicSuffixIndex()) : null;
    }

    public boolean isUnderPublicSuffix() {
        return this.publicSuffixIndex() > 0;
    }

    public boolean isTopPrivateDomain() {
        return this.publicSuffixIndex() == 1;
    }

    public InternetDomainName topPrivateDomain() {
        if (this.isTopPrivateDomain()) {
            return this;
        }
        Preconditions.checkState(this.isUnderPublicSuffix(), "Not under a public suffix: %s", (Object)this.name);
        return this.ancestor(this.publicSuffixIndex() - 1);
    }

    public boolean isRegistrySuffix() {
        return this.registrySuffixIndex() == 0;
    }

    public boolean hasRegistrySuffix() {
        return this.registrySuffixIndex() != -1;
    }

    @CheckForNull
    public InternetDomainName registrySuffix() {
        return this.hasRegistrySuffix() ? this.ancestor(this.registrySuffixIndex()) : null;
    }

    public boolean isUnderRegistrySuffix() {
        return this.registrySuffixIndex() > 0;
    }

    public boolean isTopDomainUnderRegistrySuffix() {
        return this.registrySuffixIndex() == 1;
    }

    public InternetDomainName topDomainUnderRegistrySuffix() {
        if (this.isTopDomainUnderRegistrySuffix()) {
            return this;
        }
        Preconditions.checkState(this.isUnderRegistrySuffix(), "Not under a registry suffix: %s", (Object)this.name);
        return this.ancestor(this.registrySuffixIndex() - 1);
    }

    public boolean hasParent() {
        return this.parts.size() > 1;
    }

    public InternetDomainName parent() {
        Preconditions.checkState(this.hasParent(), "Domain '%s' has no parent", (Object)this.name);
        return this.ancestor(1);
    }

    private InternetDomainName ancestor(int n) {
        List list = this.parts.subList(n, this.parts.size());
        int n2 = n;
        for (int i = 0; i < n; ++i) {
            n2 += ((String)this.parts.get(i)).length();
        }
        String string = this.name.substring(n2);
        return new InternetDomainName(string, (ImmutableList<String>)list);
    }

    public InternetDomainName child(String string) {
        return InternetDomainName.from(Preconditions.checkNotNull(string) + "." + this.name);
    }

    public static boolean isValid(String string) {
        try {
            InternetDomainName internetDomainName = InternetDomainName.from(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static boolean matchesType(Optional<PublicSuffixType> optional, Optional<PublicSuffixType> optional2) {
        return optional.isPresent() ? optional.equals(optional2) : optional2.isPresent();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternetDomainName) {
            InternetDomainName internetDomainName = (InternetDomainName)object;
            return this.name.equals(internetDomainName.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

