/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.Java8Compatibility;
import com.google.common.io.ParametricNullness;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class ByteStreams {
    private static final int BUFFER_SIZE = 8192;
    private static final int ZERO_COPY_CHUNK_SIZE = 524288;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n) {
        }

        @Override
        public void write(byte[] byArray) {
            Preconditions.checkNotNull(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            Preconditions.checkNotNull(byArray);
            Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        }

        public String toString() {
            return "ByteStreams.nullOutputStream()";
        }
    };

    static byte[] createBuffer() {
        return new byte[8192];
    }

    private ByteStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(InputStream inputStream2, OutputStream outputStream2) throws IOException {
        int n;
        Preconditions.checkNotNull(inputStream2);
        Preconditions.checkNotNull(outputStream2);
        byte[] byArray = ByteStreams.createBuffer();
        long l = 0L;
        while ((n = inputStream2.read(byArray)) != -1) {
            outputStream2.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    @CanIgnoreReturnValue
    public static long copy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) throws IOException {
        Preconditions.checkNotNull(readableByteChannel);
        Preconditions.checkNotNull(writableByteChannel);
        if (readableByteChannel instanceof FileChannel) {
            long l;
            long l2;
            FileChannel fileChannel = (FileChannel)readableByteChannel;
            long l3 = l2 = fileChannel.position();
            do {
                l = fileChannel.transferTo(l3, 524288L, writableByteChannel);
                fileChannel.position(l3 += l);
            } while (l > 0L || l3 < fileChannel.size());
            return l3 - l2;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(ByteStreams.createBuffer());
        long l = 0L;
        while (readableByteChannel.read(byteBuffer) != -1) {
            Java8Compatibility.flip(byteBuffer);
            while (byteBuffer.hasRemaining()) {
                l += (long)writableByteChannel.write(byteBuffer);
            }
            Java8Compatibility.clear(byteBuffer);
        }
        return l;
    }

    private static byte[] toByteArrayInternal(InputStream inputStream2, Queue<byte[]> queue, int n) throws IOException {
        int n2;
        int n3 = n2 = Math.min(8192, Math.max(128, Integer.highestOneBit(n) * 2));
        while (n < 0x7FFFFFF7) {
            byte[] byArray = new byte[Math.min(n3, 0x7FFFFFF7 - n)];
            queue.add(byArray);
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = inputStream2.read(byArray, n4, byArray.length - n4);
                if (n5 == -1) {
                    return ByteStreams.combineBuffers(queue, n);
                }
                n4 += n5;
                n += n5;
            }
            n3 = IntMath.saturatedMultiply(n3, n3 < 4096 ? 4 : 2);
        }
        if (inputStream2.read() == -1) {
            return ByteStreams.combineBuffers(queue, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Queue<byte[]> queue, int n) {
        if (queue.isEmpty()) {
            return new byte[0];
        }
        byte[] byArray = queue.remove();
        if (byArray.length == n) {
            return byArray;
        }
        int n2 = n - byArray.length;
        byArray = Arrays.copyOf(byArray, n);
        while (n2 > 0) {
            byte[] byArray2 = queue.remove();
            int n3 = Math.min(n2, byArray2.length);
            int n4 = n - n2;
            System.arraycopy(byArray2, 0, byArray, n4, n3);
            n2 -= n3;
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream2) throws IOException {
        Preconditions.checkNotNull(inputStream2);
        return ByteStreams.toByteArrayInternal(inputStream2, new ArrayDeque<byte[]>(20), 0);
    }

    static byte[] toByteArray(InputStream inputStream2, long l) throws IOException {
        int n;
        int n2;
        Preconditions.checkArgument(l >= 0L, "expectedSize (%s) must be non-negative", l);
        if (l > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(l + " bytes is too large to fit in a byte array");
        }
        byte[] byArray = new byte[(int)l];
        for (int i = (int)l; i > 0; i -= n2) {
            n = (int)l - i;
            n2 = inputStream2.read(byArray, n, i);
            if (n2 != -1) continue;
            return Arrays.copyOf(byArray, n);
        }
        n = inputStream2.read();
        if (n == -1) {
            return byArray;
        }
        ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>(22);
        arrayDeque.add(byArray);
        arrayDeque.add(new byte[]{(byte)n});
        return ByteStreams.toByteArrayInternal(inputStream2, arrayDeque, byArray.length + 1);
    }

    @CanIgnoreReturnValue
    public static long exhaust(InputStream inputStream2) throws IOException {
        long l;
        long l2 = 0L;
        byte[] byArray = ByteStreams.createBuffer();
        while ((l = (long)inputStream2.read(byArray)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    public static ByteArrayDataInput newDataInput(byte[] byArray) {
        return ByteStreams.newDataInput(new ByteArrayInputStream(byArray));
    }

    public static ByteArrayDataInput newDataInput(byte[] byArray, int n) {
        Preconditions.checkPositionIndex(n, byArray.length);
        return ByteStreams.newDataInput(new ByteArrayInputStream(byArray, n, byArray.length - n));
    }

    public static ByteArrayDataInput newDataInput(ByteArrayInputStream byteArrayInputStream) {
        return new ByteArrayDataInputStream(Preconditions.checkNotNull(byteArrayInputStream));
    }

    public static ByteArrayDataOutput newDataOutput() {
        return ByteStreams.newDataOutput(new ByteArrayOutputStream());
    }

    public static ByteArrayDataOutput newDataOutput(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("Invalid size: %s", n));
        }
        return ByteStreams.newDataOutput(new ByteArrayOutputStream(n));
    }

    public static ByteArrayDataOutput newDataOutput(ByteArrayOutputStream byteArrayOutputStream) {
        return new ByteArrayDataOutputStream(Preconditions.checkNotNull(byteArrayOutputStream));
    }

    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public static InputStream limit(InputStream inputStream2, long l) {
        return new LimitedInputStream(inputStream2, l);
    }

    public static void readFully(InputStream inputStream2, byte[] byArray) throws IOException {
        ByteStreams.readFully(inputStream2, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream2, byte[] byArray, int n, int n2) throws IOException {
        int n3 = ByteStreams.read(inputStream2, byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException("reached end of stream after reading " + n3 + " bytes; " + n2 + " bytes expected");
        }
    }

    public static void skipFully(InputStream inputStream2, long l) throws IOException {
        long l2 = ByteStreams.skipUpTo(inputStream2, l);
        if (l2 < l) {
            throw new EOFException("reached end of stream after skipping " + l2 + " bytes; " + l + " bytes expected");
        }
    }

    static long skipUpTo(InputStream inputStream2, long l) throws IOException {
        long l2;
        long l3;
        byte[] byArray = null;
        for (l2 = 0L; l2 < l; l2 += l3) {
            long l4 = l - l2;
            l3 = ByteStreams.skipSafely(inputStream2, l4);
            if (l3 != 0L) continue;
            int n = (int)Math.min(l4, 8192L);
            if (byArray == null) {
                byArray = new byte[n];
            }
            if ((l3 = (long)inputStream2.read(byArray, 0, n)) == -1L) break;
        }
        return l2;
    }

    private static long skipSafely(InputStream inputStream2, long l) throws IOException {
        int n = inputStream2.available();
        return n == 0 ? 0L : inputStream2.skip(Math.min((long)n, l));
    }

    @ParametricNullness
    @CanIgnoreReturnValue
    public static <T> T readBytes(InputStream inputStream2, ByteProcessor<T> byteProcessor) throws IOException {
        int n;
        Preconditions.checkNotNull(inputStream2);
        Preconditions.checkNotNull(byteProcessor);
        byte[] byArray = ByteStreams.createBuffer();
        while ((n = inputStream2.read(byArray)) != -1 && byteProcessor.processBytes(byArray, 0, n)) {
        }
        return byteProcessor.getResult();
    }

    @CanIgnoreReturnValue
    public static int read(InputStream inputStream2, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        Preconditions.checkNotNull(inputStream2);
        Preconditions.checkNotNull(byArray);
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("len (%s) cannot be negative", n2));
        }
        Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        for (n3 = 0; n3 < n2 && (n4 = inputStream2.read(byArray, n + n3, n2 - n3)) != -1; n3 += n4) {
        }
        return n3;
    }

    private static final class LimitedInputStream
    extends FilterInputStream {
        private long left;
        private long mark = -1L;

        LimitedInputStream(InputStream inputStream2, long l) {
            super(inputStream2);
            Preconditions.checkNotNull(inputStream2);
            Preconditions.checkArgument(l >= 0L, "limit must be non-negative");
            this.left = l;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }

        @Override
        public synchronized void mark(int n) {
            this.in.mark(n);
            this.mark = this.left;
        }

        @Override
        public int read() throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int n = this.in.read();
            if (n != -1) {
                --this.left;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.left == 0L) {
                return -1;
            }
            int n3 = this.in.read(byArray, n, n2 = (int)Math.min((long)n2, this.left));
            if (n3 != -1) {
                this.left -= (long)n3;
            }
            return n3;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.left = this.mark;
        }

        @Override
        public long skip(long l) throws IOException {
            l = Math.min(l, this.left);
            long l2 = this.in.skip(l);
            this.left -= l2;
            return l2;
        }
    }

    private static class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputStream;

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.byteArrayOutputStream = byteArrayOutputStream;
            this.output = new DataOutputStream(byteArrayOutputStream);
        }

        @Override
        public void write(int n) {
            try {
                this.output.write(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void write(byte[] byArray) {
            try {
                this.output.write(byArray);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            try {
                this.output.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeBoolean(boolean bl) {
            try {
                this.output.writeBoolean(bl);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeByte(int n) {
            try {
                this.output.writeByte(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeBytes(String string) {
            try {
                this.output.writeBytes(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeChar(int n) {
            try {
                this.output.writeChar(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeChars(String string) {
            try {
                this.output.writeChars(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeDouble(double d) {
            try {
                this.output.writeDouble(d);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeFloat(float f) {
            try {
                this.output.writeFloat(f);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeInt(int n) {
            try {
                this.output.writeInt(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeLong(long l) {
            try {
                this.output.writeLong(l);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeShort(int n) {
            try {
                this.output.writeShort(n);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeUTF(String string) {
            try {
                this.output.writeUTF(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputStream.toByteArray();
        }
    }

    private static class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(ByteArrayInputStream byteArrayInputStream) {
            this.input = new DataInputStream(byteArrayInputStream);
        }

        @Override
        public void readFully(byte[] byArray) {
            try {
                this.input.readFully(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) {
            try {
                this.input.readFully(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int skipBytes(int n) {
            try {
                return this.input.skipBytes(n);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException eOFException) {
                throw new IllegalStateException(eOFException);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        @CheckForNull
        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }
}

