/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hashing;
import com.google.common.hash.LongAddable;
import com.google.common.hash.LongAddables;
import com.google.common.hash.ParametricNullness;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
enum BloomFilterStrategies implements BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> boolean put(@ParametricNullness T t2, Funnel<? super T> funnel, int n, LockFreeBitArray lockFreeBitArray) {
            long l = lockFreeBitArray.bitSize();
            long l2 = Hashing.murmur3_128().hashObject(t2, funnel).asLong();
            int n2 = (int)l2;
            int n3 = (int)(l2 >>> 32);
            boolean bl = false;
            for (int i = 1; i <= n; ++i) {
                int n4 = n2 + i * n3;
                if (n4 < 0) {
                    n4 ^= 0xFFFFFFFF;
                }
                bl |= lockFreeBitArray.set((long)n4 % l);
            }
            return bl;
        }

        @Override
        public <T> boolean mightContain(@ParametricNullness T t2, Funnel<? super T> funnel, int n, LockFreeBitArray lockFreeBitArray) {
            long l = lockFreeBitArray.bitSize();
            long l2 = Hashing.murmur3_128().hashObject(t2, funnel).asLong();
            int n2 = (int)l2;
            int n3 = (int)(l2 >>> 32);
            for (int i = 1; i <= n; ++i) {
                int n4 = n2 + i * n3;
                if (n4 < 0) {
                    n4 ^= 0xFFFFFFFF;
                }
                if (lockFreeBitArray.get((long)n4 % l)) continue;
                return false;
            }
            return true;
        }
    }
    ,
    MURMUR128_MITZ_64{

        @Override
        public <T> boolean put(@ParametricNullness T t2, Funnel<? super T> funnel, int n, LockFreeBitArray lockFreeBitArray) {
            long l = lockFreeBitArray.bitSize();
            byte[] byArray = Hashing.murmur3_128().hashObject(t2, funnel).getBytesInternal();
            long l2 = this.lowerEight(byArray);
            long l3 = this.upperEight(byArray);
            boolean bl = false;
            long l4 = l2;
            for (int i = 0; i < n; ++i) {
                bl |= lockFreeBitArray.set((l4 & Long.MAX_VALUE) % l);
                l4 += l3;
            }
            return bl;
        }

        @Override
        public <T> boolean mightContain(@ParametricNullness T t2, Funnel<? super T> funnel, int n, LockFreeBitArray lockFreeBitArray) {
            long l = lockFreeBitArray.bitSize();
            byte[] byArray = Hashing.murmur3_128().hashObject(t2, funnel).getBytesInternal();
            long l2 = this.lowerEight(byArray);
            long l3 = this.upperEight(byArray);
            long l4 = l2;
            for (int i = 0; i < n; ++i) {
                if (!lockFreeBitArray.get((l4 & Long.MAX_VALUE) % l)) {
                    return false;
                }
                l4 += l3;
            }
            return true;
        }

        private long lowerEight(byte[] byArray) {
            return Longs.fromBytes(byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]);
        }

        private long upperEight(byte[] byArray) {
            return Longs.fromBytes(byArray[15], byArray[14], byArray[13], byArray[12], byArray[11], byArray[10], byArray[9], byArray[8]);
        }
    };


    static final class LockFreeBitArray {
        private static final int LONG_ADDRESSABLE_BITS = 6;
        final AtomicLongArray data;
        private final LongAddable bitCount;

        LockFreeBitArray(long l) {
            Preconditions.checkArgument(l > 0L, "data length is zero!");
            this.data = new AtomicLongArray(Ints.checkedCast(LongMath.divide(l, 64L, RoundingMode.CEILING)));
            this.bitCount = LongAddables.create();
        }

        LockFreeBitArray(long[] lArray) {
            Preconditions.checkArgument(lArray.length > 0, "data length is zero!");
            this.data = new AtomicLongArray(lArray);
            this.bitCount = LongAddables.create();
            long l = 0L;
            for (long l2 : lArray) {
                l += (long)Long.bitCount(l2);
            }
            this.bitCount.add(l);
        }

        boolean set(long l) {
            long l2;
            long l3;
            if (this.get(l)) {
                return false;
            }
            int n = (int)(l >>> 6);
            long l4 = 1L << (int)l;
            do {
                if ((l3 = this.data.get(n)) != (l2 = l3 | l4)) continue;
                return false;
            } while (!this.data.compareAndSet(n, l3, l2));
            this.bitCount.increment();
            return true;
        }

        boolean get(long l) {
            return (this.data.get((int)(l >>> 6)) & 1L << (int)l) != 0L;
        }

        public static long[] toPlainArray(AtomicLongArray atomicLongArray) {
            long[] lArray = new long[atomicLongArray.length()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = atomicLongArray.get(i);
            }
            return lArray;
        }

        long bitSize() {
            return (long)this.data.length() * 64L;
        }

        long bitCount() {
            return this.bitCount.sum();
        }

        LockFreeBitArray copy() {
            return new LockFreeBitArray(LockFreeBitArray.toPlainArray(this.data));
        }

        void putAll(LockFreeBitArray lockFreeBitArray) {
            Preconditions.checkArgument(this.data.length() == lockFreeBitArray.data.length(), "BitArrays must be of equal length (%s != %s)", this.data.length(), lockFreeBitArray.data.length());
            for (int i = 0; i < this.data.length(); ++i) {
                this.putData(i, lockFreeBitArray.data.get(i));
            }
        }

        void putData(int n, long l) {
            long l2;
            long l3;
            boolean bl = true;
            do {
                if ((l3 = this.data.get(n)) != (l2 = l3 | l)) continue;
                bl = false;
                break;
            } while (!this.data.compareAndSet(n, l3, l2));
            if (bl) {
                int n2 = Long.bitCount(l2) - Long.bitCount(l3);
                this.bitCount.add(n2);
            }
        }

        int dataLength() {
            return this.data.length();
        }

        public boolean equals(@CheckForNull Object object) {
            if (object instanceof LockFreeBitArray) {
                LockFreeBitArray lockFreeBitArray = (LockFreeBitArray)object;
                return Arrays.equals(LockFreeBitArray.toPlainArray(this.data), LockFreeBitArray.toPlainArray(lockFreeBitArray.data));
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(LockFreeBitArray.toPlainArray(this.data));
        }
    }
}

