/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import com.google.common.eventbus.Subscriber;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@ElementTypesAreNonnullByDefault
abstract class Dispatcher {
    Dispatcher() {
    }

    static Dispatcher perThreadDispatchQueue() {
        return new PerThreadQueuedDispatcher();
    }

    static Dispatcher legacyAsync() {
        return new LegacyAsyncDispatcher();
    }

    static Dispatcher immediate() {
        return ImmediateDispatcher.INSTANCE;
    }

    abstract void dispatch(Object var1, Iterator<Subscriber> var2);

    private static final class ImmediateDispatcher
    extends Dispatcher {
        private static final ImmediateDispatcher INSTANCE = new ImmediateDispatcher();

        private ImmediateDispatcher() {
        }

        @Override
        void dispatch(Object object, Iterator<Subscriber> iterator2) {
            Preconditions.checkNotNull(object);
            while (iterator2.hasNext()) {
                iterator2.next().dispatchEvent(object);
            }
        }
    }

    private static final class LegacyAsyncDispatcher
    extends Dispatcher {
        private final ConcurrentLinkedQueue<EventWithSubscriber> queue = Queues.newConcurrentLinkedQueue();

        private LegacyAsyncDispatcher() {
        }

        @Override
        void dispatch(Object object, Iterator<Subscriber> iterator2) {
            EventWithSubscriber eventWithSubscriber;
            Preconditions.checkNotNull(object);
            while (iterator2.hasNext()) {
                this.queue.add(new EventWithSubscriber(object, iterator2.next()));
            }
            while ((eventWithSubscriber = this.queue.poll()) != null) {
                eventWithSubscriber.subscriber.dispatchEvent(eventWithSubscriber.event);
            }
        }

        private static final class EventWithSubscriber {
            private final Object event;
            private final Subscriber subscriber;

            private EventWithSubscriber(Object object, Subscriber subscriber) {
                this.event = object;
                this.subscriber = subscriber;
            }
        }
    }

    private static final class PerThreadQueuedDispatcher
    extends Dispatcher {
        private final ThreadLocal<Queue<Event>> queue = new ThreadLocal<Queue<Event>>(this){

            @Override
            protected Queue<Event> initialValue() {
                return Queues.newArrayDeque();
            }
        };
        private final ThreadLocal<Boolean> dispatching = new ThreadLocal<Boolean>(this){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };

        private PerThreadQueuedDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dispatch(Object object, Iterator<Subscriber> iterator2) {
            Preconditions.checkNotNull(object);
            Preconditions.checkNotNull(iterator2);
            Queue<Event> queue = Objects.requireNonNull(this.queue.get());
            queue.offer(new Event(object, iterator2));
            if (!this.dispatching.get().booleanValue()) {
                this.dispatching.set(true);
                try {
                    Event event;
                    while ((event = queue.poll()) != null) {
                        while (event.subscribers.hasNext()) {
                            ((Subscriber)event.subscribers.next()).dispatchEvent(event.event);
                        }
                    }
                }
                finally {
                    this.dispatching.remove();
                    this.queue.remove();
                }
            }
        }

        private static final class Event {
            private final Object event;
            private final Iterator<Subscriber> subscribers;

            private Event(Object object, Iterator<Subscriber> iterator2) {
                this.event = object;
                this.subscribers = iterator2;
            }
        }
    }
}

