/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet.CachingAsList<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(EMPTY_ARRAY, 0, EMPTY_ARRAY, 0);
    private final transient Object[] elements;
    private final transient int hashCode;
    @VisibleForTesting
    final transient @Nullable Object[] table;
    private final transient int mask;

    RegularImmutableSet(Object[] objectArray, int n, @Nullable Object[] objectArray2, int n2) {
        this.elements = objectArray;
        this.hashCode = n;
        this.table = objectArray2;
        this.mask = n2;
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        @Nullable Object[] objectArray = this.table;
        if (object == null || objectArray.length == 0) {
            return false;
        }
        int n = Hashing.smearedHash(object);
        Object object2;
        while ((object2 = objectArray[n &= this.mask]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1297);
    }

    @Override
    Object[] internalArray() {
        return this.elements;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    int internalArrayEnd() {
        return this.elements.length;
    }

    @Override
    int copyIntoArray(@Nullable Object[] objectArray, int n) {
        System.arraycopy(this.elements, 0, objectArray, n, this.elements.length);
        return n + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table.length == 0 ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

