/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.TransformedIterator;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.NonNull;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class MutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private final Map<Class<? extends @NonNull B>, B> delegate;

    public static <B> MutableClassToInstanceMap<B> create() {
        return new MutableClassToInstanceMap(new HashMap());
    }

    public static <B> MutableClassToInstanceMap<B> create(Map<Class<? extends @NonNull B>, B> map) {
        return new MutableClassToInstanceMap<B>(map);
    }

    private MutableClassToInstanceMap(Map<Class<? extends @NonNull B>, B> map) {
        this.delegate = Preconditions.checkNotNull(map);
    }

    @Override
    protected Map<Class<? extends @NonNull B>, B> delegate() {
        return this.delegate;
    }

    private static <B> Map.Entry<Class<? extends @NonNull B>, B> checkedEntry(final Map.Entry<Class<? extends @NonNull B>, B> entry) {
        return new ForwardingMapEntry<Class<? extends B>, B>(){

            @Override
            protected Map.Entry<Class<? extends @NonNull B>, B> delegate() {
                return entry;
            }

            @Override
            @ParametricNullness
            public B setValue(@ParametricNullness B b) {
                MutableClassToInstanceMap.cast((Class)this.getKey(), b);
                return super.setValue(b);
            }
        };
    }

    @Override
    public Set<Map.Entry<Class<? extends @NonNull B>, B>> entrySet() {
        return new ForwardingSet<Map.Entry<Class<? extends B>, B>>(){

            @Override
            protected Set<Map.Entry<Class<? extends @NonNull B>, B>> delegate() {
                return MutableClassToInstanceMap.this.delegate().entrySet();
            }

            @Override
            public Spliterator<Map.Entry<Class<? extends @NonNull B>, B>> spliterator() {
                return CollectSpliterators.map(this.delegate().spliterator(), entry -> MutableClassToInstanceMap.checkedEntry(entry));
            }

            @Override
            public Iterator<Map.Entry<Class<? extends @NonNull B>, B>> iterator() {
                return new TransformedIterator<Map.Entry<Class<? extends B>, B>, Map.Entry<Class<? extends B>, B>>(this, this.delegate().iterator()){

                    @Override
                    Map.Entry<Class<? extends @NonNull B>, B> transform(Map.Entry<Class<? extends @NonNull B>, B> entry) {
                        return MutableClassToInstanceMap.checkedEntry(entry);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.standardToArray();
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return this.standardToArray(TArray);
            }
        };
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public B put(Class<? extends @NonNull B> clazz, @ParametricNullness B b) {
        MutableClassToInstanceMap.cast(clazz, b);
        return super.put(clazz, b);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void putAll(Map<? extends Class<? extends @NonNull B>, ? extends B> map) {
        LinkedHashMap<Class<@NonNull B>, B> linkedHashMap = new LinkedHashMap<Class<B>, B>(map);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            MutableClassToInstanceMap.cast((Class)entry.getKey(), entry.getValue());
        }
        super.putAll(linkedHashMap);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public <T extends B> T putInstance(Class<@NonNull T> clazz, @ParametricNullness T t2) {
        return MutableClassToInstanceMap.cast(clazz, this.put(clazz, t2));
    }

    @Override
    @CheckForNull
    public <T extends B> T getInstance(Class<T> clazz) {
        return MutableClassToInstanceMap.cast(clazz, this.get(clazz));
    }

    @CheckForNull
    @CanIgnoreReturnValue
    private static <T> T cast(Class<T> clazz, @CheckForNull Object object) {
        return Primitives.wrap(clazz).cast(object);
    }

    private Object writeReplace() {
        return new SerializedForm(this.delegate());
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    private static final class SerializedForm<B>
    implements Serializable {
        private final Map<Class<? extends @NonNull B>, B> backingMap;
        private static final long serialVersionUID = 0L;

        SerializedForm(Map<Class<? extends @NonNull B>, B> map) {
            this.backingMap = map;
        }

        Object readResolve() {
            return MutableClassToInstanceMap.create(this.backingMap);
        }
    }
}

