/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.common.collect.Sets;
import com.google.common.collect.TransformedListIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class LinkedListMultimap<K, V>
extends AbstractMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    @CheckForNull
    private transient Node<K, V> head;
    @CheckForNull
    private transient Node<K, V> tail;
    private transient Map<K, KeyList<K, V>> keyToKeyList;
    private transient int size;
    private transient int modCount;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> LinkedListMultimap<K, V> create() {
        return new LinkedListMultimap<K, V>();
    }

    public static <K, V> LinkedListMultimap<K, V> create(int n) {
        return new LinkedListMultimap<K, V>(n);
    }

    public static <K, V> LinkedListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new LinkedListMultimap<K, V>(multimap);
    }

    LinkedListMultimap() {
        this(12);
    }

    private LinkedListMultimap(int n) {
        this.keyToKeyList = Platform.newHashMapWithExpectedSize(n);
    }

    private LinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size());
        this.putAll((Multimap)multimap);
    }

    @CanIgnoreReturnValue
    private Node<K, V> addNode(@ParametricNullness K k, @ParametricNullness V v, @CheckForNull Node<K, V> node) {
        Node<K, V> node2 = new Node<K, V>(k, v);
        if (this.head == null) {
            this.tail = node2;
            this.head = this.tail;
            this.keyToKeyList.put(k, new KeyList<K, V>(node2));
            ++this.modCount;
        } else if (node == null) {
            Objects.requireNonNull(this.tail).next = node2;
            node2.previous = this.tail;
            this.tail = node2;
            KeyList<K, V> keyList = this.keyToKeyList.get(k);
            if (keyList == null) {
                keyList = new KeyList<K, V>(node2);
                this.keyToKeyList.put(k, keyList);
                ++this.modCount;
            } else {
                ++keyList.count;
                Node node3 = keyList.tail;
                node3.nextSibling = node2;
                node2.previousSibling = node3;
                keyList.tail = node2;
            }
        } else {
            KeyList<K, V> keyList = Objects.requireNonNull(this.keyToKeyList.get(k));
            ++keyList.count;
            node2.previous = node.previous;
            node2.previousSibling = node.previousSibling;
            node2.next = node;
            node2.nextSibling = node;
            if (node.previousSibling == null) {
                keyList.head = node2;
            } else {
                node.previousSibling.nextSibling = node2;
            }
            if (node.previous == null) {
                this.head = node2;
            } else {
                node.previous.next = node2;
            }
            node.previous = node2;
            node.previousSibling = node2;
        }
        ++this.size;
        return node2;
    }

    private void removeNode(Node<K, V> node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
        if (node.previousSibling == null && node.nextSibling == null) {
            KeyList<K, V> keyList = Objects.requireNonNull(this.keyToKeyList.remove(node.key));
            keyList.count = 0;
            ++this.modCount;
        } else {
            KeyList<K, V> keyList = Objects.requireNonNull(this.keyToKeyList.get(node.key));
            --keyList.count;
            if (node.previousSibling == null) {
                keyList.head = Objects.requireNonNull(node.nextSibling);
            } else {
                node.previousSibling.nextSibling = node.nextSibling;
            }
            if (node.nextSibling == null) {
                keyList.tail = Objects.requireNonNull(node.previousSibling);
            } else {
                node.nextSibling.previousSibling = node.previousSibling;
            }
        }
        --this.size;
    }

    private void removeAllNodes(@ParametricNullness K k) {
        Iterators.clear(new ValueForKeyIterator(k));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean containsKey(@CheckForNull Object object) {
        return this.keyToKeyList.containsKey(object);
    }

    @Override
    public boolean containsValue(@CheckForNull Object object) {
        return this.values().contains(object);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@ParametricNullness K k, @ParametricNullness V v) {
        this.addNode(k, v, null);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public List<V> replaceValues(@ParametricNullness K k, Iterable<? extends V> iterable) {
        List<V> list = this.getCopy(k);
        ValueForKeyIterator valueForKeyIterator = new ValueForKeyIterator(k);
        Iterator<V> iterator2 = iterable.iterator();
        while (valueForKeyIterator.hasNext() && iterator2.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.set(iterator2.next());
        }
        while (valueForKeyIterator.hasNext()) {
            valueForKeyIterator.next();
            valueForKeyIterator.remove();
        }
        while (iterator2.hasNext()) {
            valueForKeyIterator.add(iterator2.next());
        }
        return list;
    }

    private List<V> getCopy(@ParametricNullness K k) {
        return Collections.unmodifiableList(Lists.newArrayList(new ValueForKeyIterator(k)));
    }

    @Override
    @CanIgnoreReturnValue
    public List<V> removeAll(@CheckForNull Object object) {
        Object object2 = object;
        List<V> list = this.getCopy(object2);
        this.removeAllNodes(object2);
        return list;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.keyToKeyList.clear();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public List<V> get(final @ParametricNullness K k) {
        return new AbstractSequentialList<V>(){

            @Override
            public int size() {
                KeyList keyList = (KeyList)LinkedListMultimap.this.keyToKeyList.get(k);
                return keyList == null ? 0 : keyList.count;
            }

            @Override
            public ListIterator<V> listIterator(int n) {
                return new ValueForKeyIterator(k, n);
            }
        };
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends Sets.ImprovedAbstractSet<K> {
            KeySetImpl() {
            }

            @Override
            public int size() {
                return LinkedListMultimap.this.keyToKeyList.size();
            }

            @Override
            public Iterator<K> iterator() {
                return new DistinctKeyIterator();
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return LinkedListMultimap.this.containsKey(object);
            }

            @Override
            public boolean remove(@CheckForNull Object object) {
                return !LinkedListMultimap.this.removeAll(object).isEmpty();
            }
        }
        return new KeySetImpl();
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public List<V> values() {
        return (List)super.values();
    }

    @Override
    List<V> createValues() {
        class ValuesImpl
        extends AbstractSequentialList<V> {
            ValuesImpl() {
            }

            @Override
            public int size() {
                return LinkedListMultimap.this.size;
            }

            @Override
            public ListIterator<V> listIterator(int n) {
                final NodeIterator nodeIterator = new NodeIterator(n);
                return new TransformedListIterator<Map.Entry<K, V>, V>(this, nodeIterator){

                    @Override
                    @ParametricNullness
                    V transform(Map.Entry<K, V> entry) {
                        return entry.getValue();
                    }

                    @Override
                    public void set(@ParametricNullness V v) {
                        nodeIterator.setValue(v);
                    }
                };
            }
        }
        return new ValuesImpl();
    }

    @Override
    public List<Map.Entry<K, V>> entries() {
        return (List)super.entries();
    }

    @Override
    List<Map.Entry<K, V>> createEntries() {
        class EntriesImpl
        extends AbstractSequentialList<Map.Entry<K, V>> {
            EntriesImpl() {
            }

            @Override
            public int size() {
                return LinkedListMultimap.this.size;
            }

            @Override
            public ListIterator<Map.Entry<K, V>> listIterator(int n) {
                return new NodeIterator(n);
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
                Preconditions.checkNotNull(consumer);
                Node node = LinkedListMultimap.this.head;
                while (node != null) {
                    consumer.accept(node);
                    node = node.next;
                }
            }
        }
        return new EntriesImpl();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new Multimaps.AsMap(this);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Map.Entry entry : this.entries()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyToKeyList = Maps.newLinkedHashMap();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private class ValueForKeyIterator
    implements ListIterator<V> {
        @ParametricNullness
        final K key;
        int nextIndex;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> current;
        @CheckForNull
        Node<K, V> previous;

        ValueForKeyIterator(@ParametricNullness K k) {
            this.key = k;
            KeyList keyList = (KeyList)LinkedListMultimap.this.keyToKeyList.get(k);
            this.next = keyList == null ? null : keyList.head;
        }

        public ValueForKeyIterator(@ParametricNullness K k, int n) {
            KeyList keyList = (KeyList)LinkedListMultimap.this.keyToKeyList.get(k);
            int n2 = keyList == null ? 0 : keyList.count;
            Preconditions.checkPositionIndex(n, n2);
            if (n >= n2 / 2) {
                this.previous = keyList == null ? null : keyList.tail;
                this.nextIndex = n2;
                while (n++ < n2) {
                    this.previous();
                }
            } else {
                Node node = this.next = keyList == null ? null : keyList.head;
                while (n-- > 0) {
                    this.next();
                }
            }
            this.key = k;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        @ParametricNullness
        @CanIgnoreReturnValue
        public V next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.nextSibling;
            ++this.nextIndex;
            return this.current.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        @ParametricNullness
        @CanIgnoreReturnValue
        public V previous() {
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previousSibling;
            --this.nextIndex;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null, "no calls to next() since the last call to remove()");
            if (this.current != this.next) {
                this.previous = this.current.previousSibling;
                --this.nextIndex;
            } else {
                this.next = this.current.nextSibling;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
        }

        @Override
        public void set(@ParametricNullness V v) {
            Preconditions.checkState(this.current != null);
            this.current.value = v;
        }

        @Override
        public void add(@ParametricNullness V v) {
            this.previous = LinkedListMultimap.this.addNode(this.key, v, this.next);
            ++this.nextIndex;
            this.current = null;
        }
    }

    private class DistinctKeyIterator
    implements Iterator<K> {
        final Set<K> seenKeys;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> current;
        int expectedModCount;

        private DistinctKeyIterator() {
            this.seenKeys = Sets.newHashSetWithExpectedSize(LinkedListMultimap.this.keySet().size());
            this.next = LinkedListMultimap.this.head;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }

        private void checkForConcurrentModification() {
            if (LinkedListMultimap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @Override
        @ParametricNullness
        public K next() {
            this.checkForConcurrentModification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.seenKeys.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seenKeys.add(this.next.key));
            return this.current.key;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            Preconditions.checkState(this.current != null, "no calls to next() since the last call to remove()");
            LinkedListMultimap.this.removeAllNodes(this.current.key);
            this.current = null;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }
    }

    private class NodeIterator
    implements ListIterator<Map.Entry<K, V>> {
        int nextIndex;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> current;
        @CheckForNull
        Node<K, V> previous;
        int expectedModCount;

        NodeIterator(int n) {
            this.expectedModCount = LinkedListMultimap.this.modCount;
            int n2 = LinkedListMultimap.this.size();
            Preconditions.checkPositionIndex(n, n2);
            if (n >= n2 / 2) {
                this.previous = LinkedListMultimap.this.tail;
                this.nextIndex = n2;
                while (n++ < n2) {
                    this.previous();
                }
            } else {
                this.next = LinkedListMultimap.this.head;
                while (n-- > 0) {
                    this.next();
                }
            }
            this.current = null;
        }

        private void checkForConcurrentModification() {
            if (LinkedListMultimap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @Override
        @CanIgnoreReturnValue
        public Node<K, V> next() {
            this.checkForConcurrentModification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.current;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            Preconditions.checkState(this.current != null, "no calls to next() since the last call to remove()");
            if (this.current != this.next) {
                this.previous = this.current.previous;
                --this.nextIndex;
            } else {
                this.next = this.current.next;
            }
            LinkedListMultimap.this.removeNode(this.current);
            this.current = null;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }

        @Override
        public boolean hasPrevious() {
            this.checkForConcurrentModification();
            return this.previous != null;
        }

        @Override
        @CanIgnoreReturnValue
        public Node<K, V> previous() {
            this.checkForConcurrentModification();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previous;
            --this.nextIndex;
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void set(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        void setValue(@ParametricNullness V v) {
            Preconditions.checkState(this.current != null);
            this.current.value = v;
        }
    }

    private static class KeyList<K, V> {
        Node<K, V> head;
        Node<K, V> tail;
        int count;

        KeyList(Node<K, V> node) {
            this.head = node;
            this.tail = node;
            node.previousSibling = null;
            node.nextSibling = null;
            this.count = 1;
        }
    }

    static final class Node<K, V>
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        final K key;
        @ParametricNullness
        V value;
        @CheckForNull
        Node<K, V> next;
        @CheckForNull
        Node<K, V> previous;
        @CheckForNull
        Node<K, V> nextSibling;
        @CheckForNull
        Node<K, V> previousSibling;

        Node(@ParametricNullness K k, @ParametricNullness V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        @ParametricNullness
        public K getKey() {
            return this.key;
        }

        @Override
        @ParametricNullness
        public V getValue() {
            return this.value;
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }
    }
}

