/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableMapValues;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, @Nullable Map.Entry<K, V>[] entryArray, boolean bl) {
        Map.Entry<K, V> entry;
        HashMap<K, V> hashMap = Maps.newHashMapWithExpectedSize(n);
        HashMap<K, Object> hashMap2 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            V v;
            entryArray[i] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i]));
            K k = entryArray[i].getKey();
            entry = hashMap.put(k, v = entryArray[i].getValue());
            if (entry == null) continue;
            if (bl) {
                throw JdkBackedImmutableMap.conflictException("key", entryArray[i], entryArray[i].getKey() + "=" + entry);
            }
            if (hashMap2 == null) {
                hashMap2 = new HashMap<K, Object>();
            }
            hashMap2.put(k, v);
            ++n2;
        }
        if (hashMap2 != null) {
            Map.Entry[] entryArray2 = new Map.Entry[n - n2];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                entry = Objects.requireNonNull(entryArray[i]);
                K k = entry.getKey();
                if (hashMap2.containsKey(k)) {
                    Object v = hashMap2.get(k);
                    if (v == null) continue;
                    entry = new ImmutableMapEntry(k, v);
                    hashMap2.put(k, null);
                }
                entryArray2[n3++] = entry;
            }
            entryArray = entryArray2;
        }
        return new JdkBackedImmutableMap(hashMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> map, ImmutableList<Map.Entry<K, V>> immutableList) {
        this.delegateMap = map;
        this.entries = immutableList;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        return this.delegateMap.get(object);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)entry -> biConsumer.accept((Object)entry.getKey(), (Object)entry.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

