/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Iterators {
    private Iterators() {
    }

    static <T> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EmptyModifiableIterator.INSTANCE;
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(final Iterator<? extends T> iterator2) {
        Preconditions.checkNotNull(iterator2);
        if (iterator2 instanceof UnmodifiableIterator) {
            UnmodifiableIterator unmodifiableIterator = (UnmodifiableIterator)iterator2;
            return unmodifiableIterator;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                return iterator2.next();
            }
        };
    }

    @Deprecated
    public static <T> UnmodifiableIterator<T> unmodifiableIterator(UnmodifiableIterator<T> unmodifiableIterator) {
        return Preconditions.checkNotNull(unmodifiableIterator);
    }

    public static int size(Iterator<?> iterator2) {
        long l = 0L;
        while (iterator2.hasNext()) {
            iterator2.next();
            ++l;
        }
        return Ints.saturatedCast(l);
    }

    public static boolean contains(Iterator<?> iterator2, @CheckForNull Object object) {
        if (object == null) {
            while (iterator2.hasNext()) {
                if (iterator2.next() != null) continue;
                return true;
            }
        } else {
            while (iterator2.hasNext()) {
                if (!object.equals(iterator2.next())) continue;
                return true;
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    public static boolean removeAll(Iterator<?> iterator2, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (!collection.contains(iterator2.next())) continue;
            iterator2.remove();
            bl = true;
        }
        return bl;
    }

    @CanIgnoreReturnValue
    public static <T> boolean removeIf(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (!predicate.apply(iterator2.next())) continue;
            iterator2.remove();
            bl = true;
        }
        return bl;
    }

    @CanIgnoreReturnValue
    public static boolean retainAll(Iterator<?> iterator2, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator2.hasNext()) {
            if (collection.contains(iterator2.next())) continue;
            iterator2.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean elementsEqual(Iterator<?> iterator2, Iterator<?> iterator3) {
        while (iterator2.hasNext()) {
            Object obj;
            if (!iterator3.hasNext()) {
                return false;
            }
            Object obj2 = iterator2.next();
            if (com.google.common.base.Objects.equal(obj2, obj = iterator3.next())) continue;
            return false;
        }
        return !iterator3.hasNext();
    }

    public static String toString(Iterator<?> iterator2) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl = true;
        while (iterator2.hasNext()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(iterator2.next());
        }
        return stringBuilder.append(']').toString();
    }

    @ParametricNullness
    public static <T> T getOnlyElement(Iterator<T> iterator2) {
        T t2 = iterator2.next();
        if (!iterator2.hasNext()) {
            return t2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("expected one element but was: <").append(t2);
        for (int i = 0; i < 4 && iterator2.hasNext(); ++i) {
            stringBuilder.append(", ").append(iterator2.next());
        }
        if (iterator2.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    @ParametricNullness
    public static <T> T getOnlyElement(Iterator<? extends T> iterator2, @ParametricNullness T t2) {
        return iterator2.hasNext() ? Iterators.getOnlyElement(iterator2) : t2;
    }

    @GwtIncompatible
    public static <T> T[] toArray(Iterator<? extends T> iterator2, Class<@NonNull T> clazz) {
        ArrayList<? extends T> arrayList = Lists.newArrayList(iterator2);
        return Iterables.toArray(arrayList, clazz);
    }

    @CanIgnoreReturnValue
    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator2) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator2);
        boolean bl = false;
        while (iterator2.hasNext()) {
            bl |= collection.add(iterator2.next());
        }
        return bl;
    }

    public static int frequency(Iterator<?> iterator2, @CheckForNull Object object) {
        int n = 0;
        while (Iterators.contains(iterator2, object)) {
            ++n;
        }
        return n;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterator<T>(){
            Iterator<T> iterator = Iterators.emptyModifiableIterator();

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || iterable.iterator().hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> cycle(T ... TArray) {
        return Iterators.cycle(Lists.newArrayList(TArray));
    }

    private static <I extends Iterator<?>> Iterator<I> consumingForArray(I ... IArray) {
        return new UnmodifiableIterator<I>((Iterator[])IArray){
            int index = 0;
            final /* synthetic */ Iterator[] val$elements;
            {
                this.val$elements = iteratorArray;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.val$elements.length;
            }

            @Override
            public I next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator iterator2 = Objects.requireNonNull(this.val$elements[this.index]);
                this.val$elements[this.index] = null;
                ++this.index;
                return iterator2;
            }
        };
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator2, Iterator<? extends T> iterator3) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{iterator2, iterator3}));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        Preconditions.checkNotNull(iterator4);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{iterator2, iterator3, iterator4}));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4, Iterator<? extends T> iterator5) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        Preconditions.checkNotNull(iterator4);
        Preconditions.checkNotNull(iterator5);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{iterator2, iterator3, iterator4, iterator5}));
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iteratorArray) {
        return Iterators.concatNoDefensiveCopy(Arrays.copyOf(iteratorArray, iteratorArray.length));
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> iterator2) {
        return new ConcatenatedIterator(iterator2);
    }

    static <T> Iterator<T> concatNoDefensiveCopy(Iterator<? extends T> ... iteratorArray) {
        for (Iterator<? extends T> iterator2 : Preconditions.checkNotNull(iteratorArray)) {
            Preconditions.checkNotNull(iterator2);
        }
        return Iterators.concat(Iterators.consumingForArray((Iterator[])iteratorArray));
    }

    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator2, int n) {
        return Iterators.partitionImpl(iterator2, n, false);
    }

    public static <T> UnmodifiableIterator<List<@Nullable T>> paddedPartition(Iterator<T> iterator2, int n) {
        return Iterators.partitionImpl(iterator2, n, true);
    }

    private static <T> UnmodifiableIterator<List<@Nullable T>> partitionImpl(final Iterator<T> iterator2, final int n, final boolean bl) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkArgument(n > 0);
        return new UnmodifiableIterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public List<@Nullable T> next() {
                int n2;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                @Nullable Object[] objectArray = new Object[n];
                for (n2 = 0; n2 < n && iterator2.hasNext(); ++n2) {
                    objectArray[n2] = iterator2.next();
                }
                for (int i = n2; i < n; ++i) {
                    objectArray[i] = null;
                }
                List<@Nullable Object> list = Collections.unmodifiableList(Arrays.asList(objectArray));
                if (bl || n2 == n) {
                    return list;
                }
                return list.subList(0, n2);
            }
        };
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator2, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            @CheckForNull
            protected T computeNext() {
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!predicate.apply(e)) continue;
                    return e;
                }
                return this.endOfData();
            }
        };
    }

    @GwtIncompatible
    public static <T> UnmodifiableIterator<T> filter(Iterator<?> iterator2, Class<T> clazz) {
        return Iterators.filter(iterator2, Predicates.instanceOf(clazz));
    }

    public static <T> boolean any(Iterator<T> iterator2, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterator2, predicate) != -1;
    }

    public static <T> boolean all(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            T t2 = iterator2.next();
            if (predicate.apply(t2)) continue;
            return false;
        }
        return true;
    }

    @ParametricNullness
    public static <T> T find(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            T t2 = iterator2.next();
            if (!predicate.apply(t2)) continue;
            return t2;
        }
        throw new NoSuchElementException();
    }

    @CheckForNull
    public static <T> T find(Iterator<? extends T> iterator2, Predicate<? super T> predicate, @CheckForNull T t2) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            T t3 = iterator2.next();
            if (!predicate.apply(t3)) continue;
            return t3;
        }
        return t2;
    }

    public static <T> Optional<T> tryFind(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(predicate);
        while (iterator2.hasNext()) {
            T t2 = iterator2.next();
            if (!predicate.apply(t2)) continue;
            return Optional.of(t2);
        }
        return Optional.absent();
    }

    public static <T> int indexOf(Iterator<T> iterator2, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int n = 0;
        while (iterator2.hasNext()) {
            T t2 = iterator2.next();
            if (predicate.apply(t2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator2, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator2){

            @Override
            @ParametricNullness
            T transform(@ParametricNullness F f) {
                return function.apply(f);
            }
        };
    }

    @ParametricNullness
    public static <T> T get(Iterator<T> iterator2, int n) {
        Iterators.checkNonnegative(n);
        int n2 = Iterators.advance(iterator2, n);
        if (!iterator2.hasNext()) {
            throw new IndexOutOfBoundsException("position (" + n + ") must be less than the number of elements that remained (" + n2 + ")");
        }
        return iterator2.next();
    }

    @ParametricNullness
    public static <T> T get(Iterator<? extends T> iterator2, int n, @ParametricNullness T t2) {
        Iterators.checkNonnegative(n);
        Iterators.advance(iterator2, n);
        return Iterators.getNext(iterator2, t2);
    }

    static void checkNonnegative(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("position (" + n + ") must not be negative");
        }
    }

    @ParametricNullness
    public static <T> T getNext(Iterator<? extends T> iterator2, @ParametricNullness T t2) {
        return iterator2.hasNext() ? iterator2.next() : t2;
    }

    @ParametricNullness
    public static <T> T getLast(Iterator<T> iterator2) {
        T t2;
        do {
            t2 = iterator2.next();
        } while (iterator2.hasNext());
        return t2;
    }

    @ParametricNullness
    public static <T> T getLast(Iterator<? extends T> iterator2, @ParametricNullness T t2) {
        return iterator2.hasNext() ? Iterators.getLast(iterator2) : t2;
    }

    @CanIgnoreReturnValue
    public static int advance(Iterator<?> iterator2, int n) {
        int n2;
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkArgument(n >= 0, "numberToAdvance must be nonnegative");
        for (n2 = 0; n2 < n && iterator2.hasNext(); ++n2) {
            iterator2.next();
        }
        return n2;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator2, final int n) {
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkArgument(n >= 0, "limit is negative");
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < n && iterator2.hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator2.next();
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
    }

    public static <T> Iterator<T> consumingIterator(final Iterator<T> iterator2) {
        Preconditions.checkNotNull(iterator2);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                Object e = iterator2.next();
                iterator2.remove();
                return e;
            }

            public String toString() {
                return "Iterators.consumingIterator(...)";
            }
        };
    }

    @CheckForNull
    static <T> T pollNext(Iterator<T> iterator2) {
        if (iterator2.hasNext()) {
            T t2 = iterator2.next();
            iterator2.remove();
            return t2;
        }
        return null;
    }

    static void clear(Iterator<?> iterator2) {
        Preconditions.checkNotNull(iterator2);
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
    }

    @SafeVarargs
    public static <T> UnmodifiableIterator<T> forArray(T ... TArray) {
        return Iterators.forArrayWithPosition(TArray, 0);
    }

    static <T> UnmodifiableListIterator<T> forArrayWithPosition(T[] TArray, int n) {
        if (TArray.length == 0) {
            Preconditions.checkPositionIndex(n, TArray.length);
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, n);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(@ParametricNullness T t2) {
        if (t2 != null) {
            return new SingletonIterator<T>(t2);
        }
        SingletonNullIterator singletonNullIterator = new SingletonNullIterator();
        return singletonNullIterator;
    }

    public static <T> UnmodifiableIterator<T> forEnumeration(final Enumeration<T> enumeration) {
        Preconditions.checkNotNull(enumeration);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            @ParametricNullness
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator2) {
        Preconditions.checkNotNull(iterator2);
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator2.hasNext();
            }

            @Override
            @ParametricNullness
            public T nextElement() {
                return iterator2.next();
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator2) {
        if (iterator2 instanceof PeekingImpl) {
            PeekingImpl peekingImpl = (PeekingImpl)iterator2;
            return peekingImpl;
        }
        return new PeekingImpl<T>(iterator2);
    }

    @Deprecated
    public static <T> PeekingIterator<T> peekingIterator(PeekingIterator<T> peekingIterator) {
        return Preconditions.checkNotNull(peekingIterator);
    }

    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable, "iterators");
        Preconditions.checkNotNull(comparator, "comparator");
        return new MergingIterator<T>(iterable, comparator);
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        @CheckForNull
        private Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = Iterators.emptyIterator();
        @CheckForNull
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        @CheckForNull
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> iterator2) {
            this.topMetaIterator = Preconditions.checkNotNull(iterator2);
        }

        @CheckForNull
        private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
                if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                    this.topMetaIterator = this.metaIterators.removeFirst();
                    continue;
                }
                return null;
            }
            return this.topMetaIterator;
        }

        @Override
        public boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                this.topMetaIterator = this.getTopMetaIterator();
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator concatenatedIterator = (ConcatenatedIterator)this.iterator;
                this.iterator = concatenatedIterator.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (concatenatedIterator.metaIterators != null) {
                    while (!concatenatedIterator.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(concatenatedIterator.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = concatenatedIterator.topMetaIterator;
            }
            return true;
        }

        @Override
        @ParametricNullness
        public T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static class MergingIterator<T>
    extends UnmodifiableIterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
            Comparator comparator2 = (peekingIterator, peekingIterator2) -> comparator.compare((Object)peekingIterator.peek(), (Object)peekingIterator2.peek());
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, comparator2);
            for (Iterator<T> iterator2 : iterable) {
                if (!iterator2.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(iterator2));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        @ParametricNullness
        public T next() {
            PeekingIterator<T> peekingIterator = this.queue.remove();
            T t2 = peekingIterator.next();
            if (peekingIterator.hasNext()) {
                this.queue.add(peekingIterator);
            }
            return t2;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        @CheckForNull
        private E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator2) {
            this.iterator = Preconditions.checkNotNull(iterator2);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        @ParametricNullness
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E e = NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
            this.hasPeeked = false;
            this.peekedElement = null;
            return e;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        @ParametricNullness
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
        }
    }

    private static final class SingletonNullIterator<T>
    extends UnmodifiableIterator<T> {
        private boolean returned;

        private SingletonNullIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.returned;
        }

        @Override
        public @Nullable T next() {
            if (!this.returned) {
                this.returned = true;
                return null;
            }
            throw new NoSuchElementException();
        }
    }

    private static final class SingletonIterator<T>
    extends UnmodifiableIterator<T> {
        private @Nullable T valueOrNull;

        SingletonIterator(@NonNull T t2) {
            this.valueOrNull = t2;
        }

        @Override
        public boolean hasNext() {
            return this.valueOrNull != null;
        }

        @Override
        public @NonNull T next() {
            T t2 = this.valueOrNull;
            this.valueOrNull = null;
            if (t2 != null) {
                return t2;
            }
            throw new NoSuchElementException();
        }
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0);
        private final T[] array;

        ArrayItr(T[] TArray, int n) {
            super(TArray.length, n);
            this.array = TArray;
        }

        @Override
        @ParametricNullness
        protected T get(int n) {
            return this.array[n];
        }
    }

    private static enum EmptyModifiableIterator implements Iterator<Object>
    {
        INSTANCE;


        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(false);
        }
    }
}

