/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class Hashing {
    private static final long C1 = -862048943L;
    private static final long C2 = 461845907L;
    private static final int MAX_TABLE_SIZE = 0x40000000;

    private Hashing() {
    }

    static int smear(int n) {
        return (int)(461845907L * (long)Integer.rotateLeft((int)((long)n * -862048943L), 15));
    }

    static int smearedHash(@CheckForNull Object object) {
        return Hashing.smear(object == null ? 0 : object.hashCode());
    }

    static int closedTableSize(int n, double d) {
        int n2;
        if ((n = Math.max(n, 2)) > (int)(d * (double)(n2 = Integer.highestOneBit(n)))) {
            return (n2 <<= 1) > 0 ? n2 : 0x40000000;
        }
        return n2;
    }

    static boolean needsResizing(int n, int n2, double d) {
        return (double)n > d * (double)n2 && n2 < 0x40000000;
    }
}

