/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Serialization;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import com.google.j2objc.annotations.Weak;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final double LOAD_FACTOR = 1.0;
    private transient @Nullable BiEntry<K, V>[] hashTableKToV;
    private transient @Nullable BiEntry<K, V>[] hashTableVToK;
    @CheckForNull
    @Weak
    private transient BiEntry<K, V> firstInKeyInsertionOrder;
    @CheckForNull
    @Weak
    private transient BiEntry<K, V> lastInKeyInsertionOrder;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient BiMap<V, K> inverse;
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int n) {
        return new HashBiMap<K, V>(n);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        HashBiMap<K, V> hashBiMap = HashBiMap.create(map.size());
        hashBiMap.putAll(map);
        return hashBiMap;
    }

    private HashBiMap(int n) {
        this.init(n);
    }

    private void init(int n) {
        CollectPreconditions.checkNonnegative(n, "expectedSize");
        int n2 = Hashing.closedTableSize(n, 1.0);
        this.hashTableKToV = this.createTable(n2);
        this.hashTableVToK = this.createTable(n2);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        this.size = 0;
        this.mask = n2 - 1;
        this.modCount = 0;
    }

    private void delete(BiEntry<K, V> biEntry) {
        int n = biEntry.keyHash & this.mask;
        BiEntry<K, V> biEntry2 = null;
        BiEntry<K, V> biEntry3 = this.hashTableKToV[n];
        while (true) {
            if (biEntry3 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableKToV[n] = biEntry.nextInKToVBucket;
                    break;
                }
                biEntry2.nextInKToVBucket = biEntry.nextInKToVBucket;
                break;
            }
            biEntry2 = biEntry3;
            biEntry3 = biEntry3.nextInKToVBucket;
        }
        int n2 = biEntry.valueHash & this.mask;
        biEntry2 = null;
        BiEntry<K, V> biEntry4 = this.hashTableVToK[n2];
        while (true) {
            if (biEntry4 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableVToK[n2] = biEntry.nextInVToKBucket;
                    break;
                }
                biEntry2.nextInVToKBucket = biEntry.nextInVToKBucket;
                break;
            }
            biEntry2 = biEntry4;
            biEntry4 = biEntry4.nextInVToKBucket;
        }
        if (biEntry.prevInKeyInsertionOrder == null) {
            this.firstInKeyInsertionOrder = biEntry.nextInKeyInsertionOrder;
        } else {
            biEntry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = biEntry.nextInKeyInsertionOrder;
        }
        if (biEntry.nextInKeyInsertionOrder == null) {
            this.lastInKeyInsertionOrder = biEntry.prevInKeyInsertionOrder;
        } else {
            biEntry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = biEntry.prevInKeyInsertionOrder;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<K, V> biEntry, @CheckForNull BiEntry<K, V> biEntry2) {
        int n = biEntry.keyHash & this.mask;
        biEntry.nextInKToVBucket = this.hashTableKToV[n];
        this.hashTableKToV[n] = biEntry;
        int n2 = biEntry.valueHash & this.mask;
        biEntry.nextInVToKBucket = this.hashTableVToK[n2];
        this.hashTableVToK[n2] = biEntry;
        if (biEntry2 == null) {
            biEntry.prevInKeyInsertionOrder = this.lastInKeyInsertionOrder;
            biEntry.nextInKeyInsertionOrder = null;
            if (this.lastInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = biEntry;
            } else {
                this.lastInKeyInsertionOrder.nextInKeyInsertionOrder = biEntry;
            }
            this.lastInKeyInsertionOrder = biEntry;
        } else {
            biEntry.prevInKeyInsertionOrder = biEntry2.prevInKeyInsertionOrder;
            if (biEntry.prevInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = biEntry;
            } else {
                biEntry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = biEntry;
            }
            biEntry.nextInKeyInsertionOrder = biEntry2.nextInKeyInsertionOrder;
            if (biEntry.nextInKeyInsertionOrder == null) {
                this.lastInKeyInsertionOrder = biEntry;
            } else {
                biEntry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = biEntry;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    @CheckForNull
    private BiEntry<K, V> seekByKey(@CheckForNull Object object, int n) {
        BiEntry<K, V> biEntry = this.hashTableKToV[n & this.mask];
        while (biEntry != null) {
            if (n == biEntry.keyHash && com.google.common.base.Objects.equal(object, biEntry.key)) {
                return biEntry;
            }
            biEntry = biEntry.nextInKToVBucket;
        }
        return null;
    }

    @CheckForNull
    private BiEntry<K, V> seekByValue(@CheckForNull Object object, int n) {
        BiEntry<K, V> biEntry = this.hashTableVToK[n & this.mask];
        while (biEntry != null) {
            if (n == biEntry.valueHash && com.google.common.base.Objects.equal(object, biEntry.value)) {
                return biEntry;
            }
            biEntry = biEntry.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@CheckForNull Object object) {
        return this.seekByKey(object, Hashing.smearedHash(object)) != null;
    }

    @Override
    public boolean containsValue(@CheckForNull Object object) {
        return this.seekByValue(object, Hashing.smearedHash(object)) != null;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        return Maps.valueOrNull(this.seekByKey(object, Hashing.smearedHash(object)));
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K k, @ParametricNullness V v) {
        return this.put(k, v, false);
    }

    @CheckForNull
    private V put(@ParametricNullness K k, @ParametricNullness V v, boolean bl) {
        int n = Hashing.smearedHash(k);
        int n2 = Hashing.smearedHash(v);
        BiEntry<K, V> biEntry = this.seekByKey(k, n);
        if (biEntry != null && n2 == biEntry.valueHash && com.google.common.base.Objects.equal(v, biEntry.value)) {
            return v;
        }
        BiEntry<K, V> biEntry2 = this.seekByValue(v, n2);
        if (biEntry2 != null) {
            if (bl) {
                this.delete(biEntry2);
            } else {
                throw new IllegalArgumentException("value already present: " + v);
            }
        }
        BiEntry<K, V> biEntry3 = new BiEntry<K, V>(k, n, v, n2);
        if (biEntry != null) {
            this.delete(biEntry);
            this.insert(biEntry3, biEntry);
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
            return (V)biEntry.value;
        }
        this.insert(biEntry3, null);
        this.rehashIfNecessary();
        return null;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V forcePut(@ParametricNullness K k, @ParametricNullness V v) {
        return this.put(k, v, true);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    private K putInverse(@ParametricNullness V v, @ParametricNullness K k, boolean bl) {
        int n = Hashing.smearedHash(v);
        int n2 = Hashing.smearedHash(k);
        BiEntry<K, V> biEntry = this.seekByValue(v, n);
        BiEntry<K, V> biEntry2 = this.seekByKey(k, n2);
        if (biEntry != null && n2 == biEntry.keyHash && com.google.common.base.Objects.equal(k, biEntry.key)) {
            return k;
        }
        if (biEntry2 != null && !bl) {
            throw new IllegalArgumentException("key already present: " + k);
        }
        if (biEntry != null) {
            this.delete(biEntry);
        }
        if (biEntry2 != null) {
            this.delete(biEntry2);
        }
        BiEntry<K, V> biEntry3 = new BiEntry<K, V>(k, n2, v, n);
        this.insert(biEntry3, biEntry2);
        if (biEntry2 != null) {
            biEntry2.prevInKeyInsertionOrder = null;
            biEntry2.nextInKeyInsertionOrder = null;
        }
        if (biEntry != null) {
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
        }
        this.rehashIfNecessary();
        return Maps.keyOrNull(biEntry);
    }

    private void rehashIfNecessary() {
        @Nullable BiEntry<K, V>[] biEntryArray = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, biEntryArray.length, 1.0)) {
            int n = biEntryArray.length * 2;
            this.hashTableKToV = this.createTable(n);
            this.hashTableVToK = this.createTable(n);
            this.mask = n - 1;
            this.size = 0;
            BiEntry<K, V> biEntry = this.firstInKeyInsertionOrder;
            while (biEntry != null) {
                this.insert(biEntry, biEntry);
                biEntry = biEntry.nextInKeyInsertionOrder;
            }
            ++this.modCount;
        }
    }

    private @Nullable BiEntry<K, V>[] createTable(int n) {
        return new BiEntry[n];
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object object) {
        BiEntry<K, V> biEntry = this.seekByKey(object, Hashing.smearedHash(object));
        if (biEntry == null) {
            return null;
        }
        this.delete(biEntry);
        biEntry.prevInKeyInsertionOrder = null;
        biEntry.nextInKeyInsertionOrder = null;
        return (V)biEntry.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Set<V> values() {
        return this.inverse().keySet();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> output(BiEntry<K, V> biEntry) {
                return new MapEntry(biEntry);
            }

            class MapEntry
            extends AbstractMapEntry<K, V> {
                private BiEntry<K, V> delegate;

                MapEntry(BiEntry<K, V> biEntry) {
                    this.delegate = biEntry;
                }

                @Override
                @ParametricNullness
                public K getKey() {
                    return this.delegate.key;
                }

                @Override
                @ParametricNullness
                public V getValue() {
                    return this.delegate.value;
                }

                @Override
                @ParametricNullness
                public V setValue(@ParametricNullness V v) {
                    Object object = this.delegate.value;
                    int n = Hashing.smearedHash(v);
                    if (n == this.delegate.valueHash && com.google.common.base.Objects.equal(v, object)) {
                        return v;
                    }
                    Preconditions.checkArgument(HashBiMap.this.seekByValue(v, n) == null, "value already present: %s", v);
                    HashBiMap.this.delete(this.delegate);
                    BiEntry biEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, v, n);
                    HashBiMap.this.insert(biEntry, this.delegate);
                    this.delegate.prevInKeyInsertionOrder = null;
                    this.delegate.nextInKeyInsertionOrder = null;
                    expectedModCount = HashBiMap.this.modCount;
                    if (toRemove == this.delegate) {
                        toRemove = biEntry;
                    }
                    this.delegate = biEntry;
                    return object;
                }
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        BiEntry<K, V> biEntry = this.firstInKeyInsertionOrder;
        while (biEntry != null) {
            biConsumer.accept(biEntry.key, biEntry.value);
            biEntry = biEntry.nextInKeyInsertionOrder;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Preconditions.checkNotNull(biFunction);
        BiEntry<K, V> biEntry = this.firstInKeyInsertionOrder;
        this.clear();
        BiEntry<K, V> biEntry2 = biEntry;
        while (biEntry2 != null) {
            this.put(biEntry2.key, biFunction.apply(biEntry2.key, biEntry2.value));
            biEntry2 = biEntry2.nextInKeyInsertionOrder;
        }
    }

    @Override
    public BiMap<V, K> inverse() {
        Inverse inverse = this.inverse;
        return inverse == null ? (this.inverse = new Inverse()) : inverse;
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMap(this, objectOutputStream);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = Serialization.readCount(objectInputStream);
        this.init(16);
        Serialization.populateMap(this, objectInputStream, n);
    }

    private static final class InverseSerializedForm<K, V>
    implements Serializable {
        private final HashBiMap<K, V> bimap;

        InverseSerializedForm(HashBiMap<K, V> hashBiMap) {
            this.bimap = hashBiMap;
        }

        Object readResolve() {
            return this.bimap.inverse();
        }
    }

    private final class Inverse
    extends Maps.IteratorBasedAbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private Inverse() {
        }

        BiMap<K, V> forward() {
            return HashBiMap.this;
        }

        @Override
        public int size() {
            return HashBiMap.this.size;
        }

        @Override
        public void clear() {
            this.forward().clear();
        }

        @Override
        public boolean containsKey(@CheckForNull Object object) {
            return this.forward().containsValue(object);
        }

        @Override
        @CheckForNull
        public K get(@CheckForNull Object object) {
            return Maps.keyOrNull(HashBiMap.this.seekByValue(object, Hashing.smearedHash(object)));
        }

        @Override
        @CheckForNull
        @CanIgnoreReturnValue
        public K put(@ParametricNullness V v, @ParametricNullness K k) {
            return HashBiMap.this.putInverse(v, k, false);
        }

        @Override
        @CheckForNull
        public K forcePut(@ParametricNullness V v, @ParametricNullness K k) {
            return HashBiMap.this.putInverse(v, k, true);
        }

        @Override
        @CheckForNull
        public K remove(@CheckForNull Object object) {
            BiEntry biEntry = HashBiMap.this.seekByValue(object, Hashing.smearedHash(object));
            if (biEntry == null) {
                return null;
            }
            HashBiMap.this.delete(biEntry);
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
            return biEntry.key;
        }

        @Override
        public BiMap<K, V> inverse() {
            return this.forward();
        }

        @Override
        public Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public Set<K> values() {
            return this.forward().keySet();
        }

        @Override
        Iterator<Map.Entry<V, K>> entryIterator() {
            return new Itr<Map.Entry<V, K>>(){

                @Override
                Map.Entry<V, K> output(BiEntry<K, V> biEntry) {
                    return new InverseEntry(biEntry);
                }

                class InverseEntry
                extends AbstractMapEntry<V, K> {
                    private BiEntry<K, V> delegate;

                    InverseEntry(BiEntry<K, V> biEntry) {
                        this.delegate = biEntry;
                    }

                    @Override
                    @ParametricNullness
                    public V getKey() {
                        return this.delegate.value;
                    }

                    @Override
                    @ParametricNullness
                    public K getValue() {
                        return this.delegate.key;
                    }

                    @Override
                    @ParametricNullness
                    public K setValue(@ParametricNullness K k) {
                        Object object = this.delegate.key;
                        int n = Hashing.smearedHash(k);
                        if (n == this.delegate.keyHash && com.google.common.base.Objects.equal(k, object)) {
                            return k;
                        }
                        Preconditions.checkArgument(HashBiMap.this.seekByKey(k, n) == null, "value already present: %s", k);
                        HashBiMap.this.delete(this.delegate);
                        BiEntry biEntry = new BiEntry(k, n, this.delegate.value, this.delegate.valueHash);
                        this.delegate = biEntry;
                        HashBiMap.this.insert(biEntry, null);
                        expectedModCount = HashBiMap.this.modCount;
                        return object;
                    }
                }
            };
        }

        @Override
        public void forEach(BiConsumer<? super V, ? super K> biConsumer) {
            Preconditions.checkNotNull(biConsumer);
            HashBiMap.this.forEach((? super K object, ? super V object2) -> biConsumer.accept((Object)object2, (Object)object));
        }

        @Override
        public void replaceAll(BiFunction<? super V, ? super K, ? extends K> biFunction) {
            Preconditions.checkNotNull(biFunction);
            BiEntry biEntry = HashBiMap.this.firstInKeyInsertionOrder;
            this.clear();
            BiEntry biEntry2 = biEntry;
            while (biEntry2 != null) {
                this.put((V)biEntry2.value, (K)biFunction.apply(biEntry2.value, biEntry2.key));
                biEntry2 = biEntry2.nextInKeyInsertionOrder;
            }
        }

        Object writeReplace() {
            return new InverseSerializedForm(HashBiMap.this);
        }

        @GwtIncompatible
        @J2ktIncompatible
        private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
            throw new InvalidObjectException("Use InverseSerializedForm");
        }

        private final class InverseKeySet
        extends Maps.KeySet<V, K> {
            InverseKeySet() {
                super(Inverse.this);
            }

            @Override
            public boolean remove(@CheckForNull Object object) {
                BiEntry biEntry = HashBiMap.this.seekByValue(object, Hashing.smearedHash(object));
                if (biEntry == null) {
                    return false;
                }
                HashBiMap.this.delete(biEntry);
                return true;
            }

            @Override
            public Iterator<V> iterator() {
                return new Itr<V>(this){

                    @Override
                    @ParametricNullness
                    V output(BiEntry<K, V> biEntry) {
                        return biEntry.value;
                    }
                };
            }
        }
    }

    private final class KeySet
    extends Maps.KeySet<K, V> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public Iterator<K> iterator() {
            return new Itr<K>(this){

                @Override
                @ParametricNullness
                K output(BiEntry<K, V> biEntry) {
                    return biEntry.key;
                }
            };
        }

        @Override
        public boolean remove(@CheckForNull Object object) {
            BiEntry biEntry = HashBiMap.this.seekByKey(object, Hashing.smearedHash(object));
            if (biEntry == null) {
                return false;
            }
            HashBiMap.this.delete(biEntry);
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
            return true;
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        @CheckForNull
        BiEntry<K, V> next;
        @CheckForNull
        BiEntry<K, V> toRemove;
        int expectedModCount;
        int remaining;

        private Itr() {
            this.next = HashBiMap.this.firstInKeyInsertionOrder;
            this.toRemove = null;
            this.expectedModCount = HashBiMap.this.modCount;
            this.remaining = HashBiMap.this.size();
        }

        @Override
        public boolean hasNext() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null && this.remaining > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry biEntry = Objects.requireNonNull(this.next);
            this.next = biEntry.nextInKeyInsertionOrder;
            this.toRemove = biEntry;
            --this.remaining;
            return this.output(biEntry);
        }

        @Override
        public void remove() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            HashBiMap.this.delete(this.toRemove);
            this.expectedModCount = HashBiMap.this.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K, V> var1);
    }

    static final class BiEntry<K, V>
    extends ImmutableEntry<K, V> {
        final int keyHash;
        final int valueHash;
        @CheckForNull
        BiEntry<K, V> nextInKToVBucket;
        @CheckForNull
        @Weak
        BiEntry<K, V> nextInVToKBucket;
        @CheckForNull
        @Weak
        BiEntry<K, V> nextInKeyInsertionOrder;
        @CheckForNull
        @Weak
        BiEntry<K, V> prevInKeyInsertionOrder;

        BiEntry(@ParametricNullness K k, int n, @ParametricNullness V v, int n2) {
            super(k, v);
            this.keyHash = n;
            this.valueHash = n2;
        }
    }
}

