/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ForwardingNavigableSet<E>
extends ForwardingSortedSet<E>
implements NavigableSet<E> {
    protected ForwardingNavigableSet() {
    }

    @Override
    protected abstract NavigableSet<E> delegate();

    @Override
    @CheckForNull
    public E lower(@ParametricNullness E e) {
        return this.delegate().lower(e);
    }

    @CheckForNull
    protected E standardLower(@ParametricNullness E e) {
        return Iterators.getNext(this.headSet(e, false).descendingIterator(), null);
    }

    @Override
    @CheckForNull
    public E floor(@ParametricNullness E e) {
        return this.delegate().floor(e);
    }

    @CheckForNull
    protected E standardFloor(@ParametricNullness E e) {
        return Iterators.getNext(this.headSet(e, true).descendingIterator(), null);
    }

    @Override
    @CheckForNull
    public E ceiling(@ParametricNullness E e) {
        return this.delegate().ceiling(e);
    }

    @CheckForNull
    protected E standardCeiling(@ParametricNullness E e) {
        return Iterators.getNext(this.tailSet(e, true).iterator(), null);
    }

    @Override
    @CheckForNull
    public E higher(@ParametricNullness E e) {
        return this.delegate().higher(e);
    }

    @CheckForNull
    protected E standardHigher(@ParametricNullness E e) {
        return Iterators.getNext(this.tailSet(e, false).iterator(), null);
    }

    @Override
    @CheckForNull
    public E pollFirst() {
        return this.delegate().pollFirst();
    }

    @CheckForNull
    protected E standardPollFirst() {
        return Iterators.pollNext(this.iterator());
    }

    @Override
    @CheckForNull
    public E pollLast() {
        return this.delegate().pollLast();
    }

    @CheckForNull
    protected E standardPollLast() {
        return Iterators.pollNext(this.descendingIterator());
    }

    @ParametricNullness
    protected E standardFirst() {
        return this.iterator().next();
    }

    @ParametricNullness
    protected E standardLast() {
        return this.descendingIterator().next();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.delegate().descendingSet();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.delegate().descendingIterator();
    }

    @Override
    public NavigableSet<E> subSet(@ParametricNullness E e, boolean bl, @ParametricNullness E e2, boolean bl2) {
        return this.delegate().subSet(e, bl, e2, bl2);
    }

    protected NavigableSet<E> standardSubSet(@ParametricNullness E e, boolean bl, @ParametricNullness E e2, boolean bl2) {
        return this.tailSet(e, bl).headSet(e2, bl2);
    }

    @Override
    protected SortedSet<E> standardSubSet(@ParametricNullness E e, @ParametricNullness E e2) {
        return this.subSet(e, true, e2, false);
    }

    @Override
    public NavigableSet<E> headSet(@ParametricNullness E e, boolean bl) {
        return this.delegate().headSet(e, bl);
    }

    protected SortedSet<E> standardHeadSet(@ParametricNullness E e) {
        return this.headSet(e, false);
    }

    @Override
    public NavigableSet<E> tailSet(@ParametricNullness E e, boolean bl) {
        return this.delegate().tailSet(e, bl);
    }

    protected SortedSet<E> standardTailSet(@ParametricNullness E e) {
        return this.tailSet(e, true);
    }

    protected class StandardDescendingSet
    extends Sets.DescendingSet<E> {
        public StandardDescendingSet(ForwardingNavigableSet forwardingNavigableSet) {
            super(forwardingNavigableSet);
        }
    }
}

