/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.CompactHashMap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
class CompactLinkedHashMap<K, V>
extends CompactHashMap<K, V> {
    private static final int ENDPOINT = -2;
    @CheckForNull
    @VisibleForTesting
    transient long[] links;
    private transient int firstEntry;
    private transient int lastEntry;
    private final boolean accessOrder;

    public static <K, V> CompactLinkedHashMap<K, V> create() {
        return new CompactLinkedHashMap<K, V>();
    }

    public static <K, V> CompactLinkedHashMap<K, V> createWithExpectedSize(int n) {
        return new CompactLinkedHashMap<K, V>(n);
    }

    CompactLinkedHashMap() {
        this(3);
    }

    CompactLinkedHashMap(int n) {
        this(n, false);
    }

    CompactLinkedHashMap(int n, boolean bl) {
        super(n);
        this.accessOrder = bl;
    }

    @Override
    void init(int n) {
        super.init(n);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    int allocArrays() {
        int n = super.allocArrays();
        this.links = new long[n];
        return n;
    }

    @Override
    Map<K, V> createHashFloodingResistantDelegate(int n) {
        return new LinkedHashMap(n, 1.0f, this.accessOrder);
    }

    @Override
    @CanIgnoreReturnValue
    Map<K, V> convertToHashFloodingResistantImplementation() {
        Map map = super.convertToHashFloodingResistantImplementation();
        this.links = null;
        return map;
    }

    private int getPredecessor(int n) {
        return (int)(this.link(n) >>> 32) - 1;
    }

    @Override
    int getSuccessor(int n) {
        return (int)this.link(n) - 1;
    }

    private void setSuccessor(int n, int n2) {
        long l = 0xFFFFFFFFL;
        this.setLink(n, this.link(n) & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(n2 + 1) & l);
    }

    private void setPredecessor(int n, int n2) {
        long l = -4294967296L;
        this.setLink(n, this.link(n) & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(n2 + 1) << 32);
    }

    private void setSucceeds(int n, int n2) {
        if (n == -2) {
            this.firstEntry = n2;
        } else {
            this.setSuccessor(n, n2);
        }
        if (n2 == -2) {
            this.lastEntry = n;
        } else {
            this.setPredecessor(n2, n);
        }
    }

    @Override
    void insertEntry(int n, @ParametricNullness K k, @ParametricNullness V v, int n2, int n3) {
        super.insertEntry(n, k, v, n2, n3);
        this.setSucceeds(this.lastEntry, n);
        this.setSucceeds(n, -2);
    }

    @Override
    void accessEntry(int n) {
        if (this.accessOrder) {
            this.setSucceeds(this.getPredecessor(n), this.getSuccessor(n));
            this.setSucceeds(this.lastEntry, n);
            this.setSucceeds(n, -2);
            this.incrementModCount();
        }
    }

    @Override
    void moveLastEntry(int n, int n2) {
        int n3 = this.size() - 1;
        super.moveLastEntry(n, n2);
        this.setSucceeds(this.getPredecessor(n), this.getSuccessor(n));
        if (n < n3) {
            this.setSucceeds(this.getPredecessor(n3), n);
            this.setSucceeds(n, this.getSuccessor(n3));
        }
        this.setLink(n3, 0L);
    }

    @Override
    void resizeEntries(int n) {
        super.resizeEntries(n);
        this.links = Arrays.copyOf(this.requireLinks(), n);
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int adjustAfterRemove(int n, int n2) {
        return n >= this.size() ? n2 : n;
    }

    @Override
    Set<Map.Entry<K, V>> createEntrySet() {
        class EntrySetImpl
        extends CompactHashMap.EntrySetView {
            EntrySetImpl(CompactLinkedHashMap compactLinkedHashMap) {
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return Spliterators.spliterator(this, 17);
            }
        }
        return new EntrySetImpl(this);
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends CompactHashMap.KeySetView {
            KeySetImpl(CompactLinkedHashMap compactLinkedHashMap) {
            }

            @Override
            public @Nullable Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return ObjectArrays.toArrayImpl(this, TArray);
            }

            @Override
            public Spliterator<K> spliterator() {
                return Spliterators.spliterator(this, 17);
            }
        }
        return new KeySetImpl(this);
    }

    @Override
    Collection<V> createValues() {
        class ValuesImpl
        extends CompactHashMap.ValuesView {
            ValuesImpl(CompactLinkedHashMap compactLinkedHashMap) {
            }

            @Override
            public @Nullable Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return ObjectArrays.toArrayImpl(this, TArray);
            }

            @Override
            public Spliterator<V> spliterator() {
                return Spliterators.spliterator(this, 16);
            }
        }
        return new ValuesImpl(this);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        if (this.links != null) {
            Arrays.fill(this.links, 0, this.size(), 0L);
        }
        super.clear();
    }

    private long[] requireLinks() {
        return Objects.requireNonNull(this.links);
    }

    private long link(int n) {
        return this.requireLinks()[n];
    }

    private void setLink(int n, long l) {
        this.requireLinks()[n] = l;
    }
}

