/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.CompactHashing;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.Maps;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Object NOT_FOUND = new Object();
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    private static final int MAX_HASH_BUCKET_LENGTH = 9;
    @CheckForNull
    private transient Object table;
    @CheckForNull
    @VisibleForTesting
    transient int[] entries;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] keys;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable Object[] values;
    private transient int metadata;
    private transient int size;
    @LazyInit
    @CheckForNull
    private transient Set<K> keySetView;
    @LazyInit
    @CheckForNull
    private transient Set<Map.Entry<K, V>> entrySetView;
    @LazyInit
    @CheckForNull
    private transient Collection<V> valuesView;

    public static <K, V> CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K, V> CompactHashMap<K, V> createWithExpectedSize(int n) {
        return new CompactHashMap<K, V>(n);
    }

    CompactHashMap() {
        this.init(3);
    }

    CompactHashMap(int n) {
        this.init(n);
    }

    void init(int n) {
        Preconditions.checkArgument(n >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange(n, 1, 0x3FFFFFFF);
    }

    @VisibleForTesting
    boolean needsAllocArrays() {
        return this.table == null;
    }

    @CanIgnoreReturnValue
    int allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int n = this.metadata;
        int n2 = CompactHashing.tableSize(n);
        this.table = CompactHashing.createTable(n2);
        this.setHashTableMask(n2 - 1);
        this.entries = new int[n];
        this.keys = new Object[n];
        this.values = new Object[n];
        return n;
    }

    @CheckForNull
    @VisibleForTesting
    Map<K, V> delegateOrNull() {
        if (this.table instanceof Map) {
            return (Map)this.table;
        }
        return null;
    }

    Map<K, V> createHashFloodingResistantDelegate(int n) {
        return new LinkedHashMap(n, 1.0f);
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    Map<K, V> convertToHashFloodingResistantImplementation() {
        Map<K, V> map = this.createHashFloodingResistantDelegate(this.hashTableMask() + 1);
        int n = this.firstEntryIndex();
        while (n >= 0) {
            map.put(this.key(n), this.value(n));
            n = this.getSuccessor(n);
        }
        this.table = map;
        this.entries = null;
        this.keys = null;
        this.values = null;
        this.incrementModCount();
        return map;
    }

    private void setHashTableMask(int n) {
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        this.metadata = CompactHashing.maskCombine(this.metadata, n2, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    void accessEntry(int n) {
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(@ParametricNullness K k, @ParametricNullness V v) {
        Map<K, V> map;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((map = this.delegateOrNull()) != null) {
            return map.put(k, v);
        }
        int[] nArray = this.requireEntries();
        @Nullable Object[] objectArray = this.requireKeys();
        @Nullable Object[] objectArray2 = this.requireValues();
        int n = this.size;
        int n2 = n + 1;
        int n3 = Hashing.smearedHash(k);
        int n4 = this.hashTableMask();
        int n5 = n3 & n4;
        int n6 = CompactHashing.tableGet(this.requireTable(), n5);
        if (n6 == 0) {
            if (n2 > n4) {
                n4 = this.resizeTable(n4, CompactHashing.newCapacity(n4), n3, n);
            } else {
                CompactHashing.tableSet(this.requireTable(), n5, n + 1);
            }
        } else {
            int n7;
            int n8 = CompactHashing.getHashPrefix(n3, n4);
            int n9 = 0;
            do {
                int n10;
                if (CompactHashing.getHashPrefix(n7 = nArray[n10 = n6 - 1], n4) == n8 && com.google.common.base.Objects.equal(k, objectArray[n10])) {
                    Object object = objectArray2[n10];
                    objectArray2[n10] = v;
                    this.accessEntry(n10);
                    return (V)object;
                }
                n6 = CompactHashing.getNext(n7, n4);
                ++n9;
            } while (n6 != 0);
            if (n9 >= 9) {
                return this.convertToHashFloodingResistantImplementation().put(k, v);
            }
            if (n2 > n4) {
                n4 = this.resizeTable(n4, CompactHashing.newCapacity(n4), n3, n);
            } else {
                nArray[n10] = CompactHashing.maskCombine(n7, n + 1, n4);
            }
        }
        this.resizeMeMaybe(n2);
        this.insertEntry(n, k, v, n3, n4);
        this.size = n2;
        this.incrementModCount();
        return null;
    }

    void insertEntry(int n, @ParametricNullness K k, @ParametricNullness V v, int n2, int n3) {
        this.setEntry(n, CompactHashing.maskCombine(n2, 0, n3));
        this.setKey(n, k);
        this.setValue(n, v);
    }

    private void resizeMeMaybe(int n) {
        int n2;
        int n3 = this.requireEntries().length;
        if (n > n3 && (n2 = Math.min(0x3FFFFFFF, n3 + Math.max(1, n3 >>> 1) | 1)) != n3) {
            this.resizeEntries(n2);
        }
    }

    void resizeEntries(int n) {
        this.entries = Arrays.copyOf(this.requireEntries(), n);
        this.keys = Arrays.copyOf(this.requireKeys(), n);
        this.values = Arrays.copyOf(this.requireValues(), n);
    }

    @CanIgnoreReturnValue
    private int resizeTable(int n, int n2, int n3, int n4) {
        Object object = CompactHashing.createTable(n2);
        int n5 = n2 - 1;
        if (n4 != 0) {
            CompactHashing.tableSet(object, n3 & n5, n4 + 1);
        }
        Object object2 = this.requireTable();
        int[] nArray = this.requireEntries();
        for (int i = 0; i <= n; ++i) {
            int n6 = CompactHashing.tableGet(object2, i);
            while (n6 != 0) {
                int n7 = n6 - 1;
                int n8 = nArray[n7];
                int n9 = CompactHashing.getHashPrefix(n8, n) | i;
                int n10 = n9 & n5;
                int n11 = CompactHashing.tableGet(object, n10);
                CompactHashing.tableSet(object, n10, n6);
                nArray[n7] = CompactHashing.maskCombine(n9, n11, n5);
                n6 = CompactHashing.getNext(n8, n);
            }
        }
        this.table = object;
        this.setHashTableMask(n5);
        return n5;
    }

    private int indexOf(@CheckForNull Object object) {
        int n;
        if (this.needsAllocArrays()) {
            return -1;
        }
        int n2 = Hashing.smearedHash(object);
        int n3 = this.hashTableMask();
        int n4 = CompactHashing.tableGet(this.requireTable(), n2 & n3);
        if (n4 == 0) {
            return -1;
        }
        int n5 = CompactHashing.getHashPrefix(n2, n3);
        do {
            int n6;
            if (CompactHashing.getHashPrefix(n = this.entry(n6 = n4 - 1), n3) != n5 || !com.google.common.base.Objects.equal(object, this.key(n6))) continue;
            return n6;
        } while ((n4 = CompactHashing.getNext(n, n3)) != 0);
        return -1;
    }

    @Override
    public boolean containsKey(@CheckForNull Object object) {
        Map<K, V> map = this.delegateOrNull();
        return map != null ? map.containsKey(object) : this.indexOf(object) != -1;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object object) {
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            return map.get(object);
        }
        int n = this.indexOf(object);
        if (n == -1) {
            return null;
        }
        this.accessEntry(n);
        return this.value(n);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object object) {
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            return map.remove(object);
        }
        Object object2 = this.removeHelper(object);
        return (V)(object2 == NOT_FOUND ? null : object2);
    }

    private @Nullable Object removeHelper(@CheckForNull Object object) {
        if (this.needsAllocArrays()) {
            return NOT_FOUND;
        }
        int n = this.hashTableMask();
        int n2 = CompactHashing.remove(object, null, n, this.requireTable(), this.requireEntries(), this.requireKeys(), null);
        if (n2 == -1) {
            return NOT_FOUND;
        }
        V v = this.value(n2);
        this.moveLastEntry(n2, n);
        --this.size;
        this.incrementModCount();
        return v;
    }

    void moveLastEntry(int n, int n2) {
        Object object = this.requireTable();
        int[] nArray = this.requireEntries();
        @Nullable Object[] objectArray = this.requireKeys();
        @Nullable Object[] objectArray2 = this.requireValues();
        int n3 = this.size() - 1;
        if (n < n3) {
            int n4;
            Object object2;
            objectArray[n] = object2 = objectArray[n3];
            objectArray2[n] = objectArray2[n3];
            objectArray[n3] = null;
            objectArray2[n3] = null;
            nArray[n] = nArray[n3];
            nArray[n3] = 0;
            int n5 = Hashing.smearedHash(object2) & n2;
            int n6 = CompactHashing.tableGet(object, n5);
            if (n6 == (n4 = n3 + 1)) {
                CompactHashing.tableSet(object, n5, n + 1);
            } else {
                int n7;
                int n8;
                while ((n6 = CompactHashing.getNext(n8 = nArray[n7 = n6 - 1], n2)) != n4) {
                }
                nArray[n7] = CompactHashing.maskCombine(n8, n + 1, n2);
            }
        } else {
            objectArray[n] = null;
            objectArray2[n] = null;
            nArray[n] = 0;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int n) {
        return n + 1 < this.size ? n + 1 : -1;
    }

    int adjustAfterRemove(int n, int n2) {
        return n - 1;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Preconditions.checkNotNull(biFunction);
        Map<? super K, ? extends V> map = this.delegateOrNull();
        if (map != null) {
            map.replaceAll(biFunction);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setValue(i, biFunction.apply(this.key(i), this.value(i)));
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    Set<K> createKeySet() {
        return new KeySetView();
    }

    Iterator<K> keySetIterator() {
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            return map.keySet().iterator();
        }
        return new Itr<K>(){

            @Override
            @ParametricNullness
            K getOutput(int n) {
                return CompactHashMap.this.key(n);
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        Map<? super K, ? super V> map = this.delegateOrNull();
        if (map != null) {
            map.forEach(biConsumer);
        } else {
            int n = this.firstEntryIndex();
            while (n >= 0) {
                biConsumer.accept(this.key(n), this.value(n));
                n = this.getSuccessor(n);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    Set<Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView();
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            return map.entrySet().iterator();
        }
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> getOutput(int n) {
                return new MapEntry(n);
            }
        };
    }

    @Override
    public int size() {
        Map<K, V> map = this.delegateOrNull();
        return map != null ? map.size() : this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(@CheckForNull Object object) {
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            return map.containsValue(object);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!com.google.common.base.Objects.equal(object, this.value(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        return this.valuesView == null ? (this.valuesView = this.createValues()) : this.valuesView;
    }

    Collection<V> createValues() {
        return new ValuesView();
    }

    Iterator<V> valuesIterator() {
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            return map.values().iterator();
        }
        return new Itr<V>(){

            @Override
            @ParametricNullness
            V getOutput(int n) {
                return CompactHashMap.this.value(n);
            }
        };
    }

    public void trimToSize() {
        int n;
        int n2;
        if (this.needsAllocArrays()) {
            return;
        }
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            Map<K, V> map2 = this.createHashFloodingResistantDelegate(this.size());
            map2.putAll(map);
            this.table = map2;
            return;
        }
        int n3 = this.size;
        if (n3 < this.requireEntries().length) {
            this.resizeEntries(n3);
        }
        if ((n2 = CompactHashing.tableSize(n3)) < (n = this.hashTableMask())) {
            this.resizeTable(n, n2, 0, 0);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Map<K, V> map = this.delegateOrNull();
        if (map != null) {
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            map.clear();
            this.table = null;
            this.size = 0;
        } else {
            Arrays.fill(this.requireKeys(), 0, this.size, null);
            Arrays.fill(this.requireValues(), 0, this.size, null);
            CompactHashing.tableClear(this.requireTable());
            Arrays.fill(this.requireEntries(), 0, this.size, 0);
            this.size = 0;
        }
    }

    @J2ktIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        Iterator<Map.Entry<K, V>> iterator2 = this.entrySetIterator();
        while (iterator2.hasNext()) {
            Map.Entry<K, V> entry = iterator2.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    @J2ktIncompatible
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new InvalidObjectException("Invalid size: " + n);
        }
        this.init(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private Object requireTable() {
        return Objects.requireNonNull(this.table);
    }

    private int[] requireEntries() {
        return Objects.requireNonNull(this.entries);
    }

    private @Nullable Object[] requireKeys() {
        return Objects.requireNonNull(this.keys);
    }

    private @Nullable Object[] requireValues() {
        return Objects.requireNonNull(this.values);
    }

    private K key(int n) {
        return (K)this.requireKeys()[n];
    }

    private V value(int n) {
        return (V)this.requireValues()[n];
    }

    private int entry(int n) {
        return this.requireEntries()[n];
    }

    private void setKey(int n, K k) {
        this.requireKeys()[n] = k;
    }

    private void setValue(int n, V v) {
        this.requireValues()[n] = v;
    }

    private void setEntry(int n, int n2) {
        this.requireEntries()[n] = n2;
    }

    class ValuesView
    extends Maps.Values<K, V> {
        ValuesView() {
            super(CompactHashMap.this);
        }

        @Override
        public Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            Preconditions.checkNotNull(consumer);
            Map map = CompactHashMap.this.delegateOrNull();
            if (map != null) {
                map.values().forEach(consumer);
            } else {
                int n = CompactHashMap.this.firstEntryIndex();
                while (n >= 0) {
                    consumer.accept(CompactHashMap.this.value(n));
                    n = CompactHashMap.this.getSuccessor(n);
                }
            }
        }

        @Override
        public Spliterator<V> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 16);
            }
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.values().spliterator() : Spliterators.spliterator(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, 16);
        }

        @Override
        public @Nullable Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.values().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (TArray.length > 0) {
                    @Nullable T[] TArray2 = TArray;
                    TArray2[0] = null;
                }
                return TArray;
            }
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.values().toArray(TArray) : ObjectArrays.toArrayImpl(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, TArray);
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        private final K key;
        private int lastKnownIndex;

        MapEntry(int n) {
            this.key = CompactHashMap.this.key(n);
            this.lastKnownIndex = n;
        }

        @Override
        @ParametricNullness
        public K getKey() {
            return this.key;
        }

        private void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= CompactHashMap.this.size() || !com.google.common.base.Objects.equal(this.key, CompactHashMap.this.key(this.lastKnownIndex))) {
                this.lastKnownIndex = CompactHashMap.this.indexOf(this.key);
            }
        }

        @Override
        @ParametricNullness
        public V getValue() {
            Map map = CompactHashMap.this.delegateOrNull();
            if (map != null) {
                return NullnessCasts.uncheckedCastNullableTToT(map.get(this.key));
            }
            this.updateLastKnownIndex();
            return this.lastKnownIndex == -1 ? NullnessCasts.unsafeNull() : CompactHashMap.this.value(this.lastKnownIndex);
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V v) {
            Map map = CompactHashMap.this.delegateOrNull();
            if (map != null) {
                return NullnessCasts.uncheckedCastNullableTToT(map.put(this.key, v));
            }
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, v);
                return NullnessCasts.unsafeNull();
            }
            Object object = CompactHashMap.this.value(this.lastKnownIndex);
            CompactHashMap.this.setValue(this.lastKnownIndex, v);
            return object;
        }
    }

    class EntrySetView
    extends Maps.EntrySet<K, V> {
        EntrySetView() {
        }

        @Override
        Map<K, V> map() {
            return CompactHashMap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return CompactHashMap.this.entrySetIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.entrySet().spliterator() : CollectSpliterators.indexed(CompactHashMap.this.size, 17, n -> new MapEntry(n));
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            Map map = CompactHashMap.this.delegateOrNull();
            if (map != null) {
                return map.entrySet().contains(object);
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                int n = CompactHashMap.this.indexOf(entry.getKey());
                return n != -1 && com.google.common.base.Objects.equal(CompactHashMap.this.value(n), entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(@CheckForNull Object object) {
            Map map = CompactHashMap.this.delegateOrNull();
            if (map != null) {
                return map.entrySet().remove(object);
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                if (CompactHashMap.this.needsAllocArrays()) {
                    return false;
                }
                int n = CompactHashMap.this.hashTableMask();
                int n2 = CompactHashing.remove(entry.getKey(), entry.getValue(), n, CompactHashMap.this.requireTable(), CompactHashMap.this.requireEntries(), CompactHashMap.this.requireKeys(), CompactHashMap.this.requireValues());
                if (n2 == -1) {
                    return false;
                }
                CompactHashMap.this.moveLastEntry(n2, n);
                CompactHashMap.this.size--;
                CompactHashMap.this.incrementModCount();
                return true;
            }
            return false;
        }
    }

    class KeySetView
    extends Maps.KeySet<K, V> {
        KeySetView() {
            super(CompactHashMap.this);
        }

        @Override
        public @Nullable Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.keySet().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (TArray.length > 0) {
                    @Nullable T[] TArray2 = TArray;
                    TArray2[0] = null;
                }
                return TArray;
            }
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.keySet().toArray(TArray) : ObjectArrays.toArrayImpl(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, TArray);
        }

        @Override
        public boolean remove(@CheckForNull Object object) {
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.keySet().remove(object) : CompactHashMap.this.removeHelper(object) != NOT_FOUND;
        }

        @Override
        public Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        @Override
        public Spliterator<K> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 17);
            }
            Map map = CompactHashMap.this.delegateOrNull();
            return map != null ? map.keySet().spliterator() : Spliterators.spliterator(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, 17);
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            Preconditions.checkNotNull(consumer);
            Map map = CompactHashMap.this.delegateOrNull();
            if (map != null) {
                map.keySet().forEach(consumer);
            } else {
                int n = CompactHashMap.this.firstEntryIndex();
                while (n >= 0) {
                    consumer.accept(CompactHashMap.this.key(n));
                    n = CompactHashMap.this.getSuccessor(n);
                }
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        int expectedMetadata;
        int currentIndex;
        int indexToRemove;

        private Itr() {
            this.expectedMetadata = CompactHashMap.this.metadata;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @ParametricNullness
        abstract T getOutput(int var1);

        @Override
        @ParametricNullness
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexToRemove = this.currentIndex;
            T t2 = this.getOutput(this.currentIndex);
            this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
            return t2;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.indexToRemove >= 0);
            this.incrementExpectedModCount();
            CompactHashMap.this.remove(CompactHashMap.this.key(this.indexToRemove));
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }

        void incrementExpectedModCount() {
            this.expectedMetadata += 32;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.metadata != this.expectedMetadata) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

