/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;
    private static final long serialVersionUID = 2447537837011683357L;

    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument(map.isEmpty());
        this.map = map;
    }

    final void setMap(Map<K, Collection<V>> map) {
        this.map = map;
        this.totalSize = 0;
        for (Collection<Collection<V>> collection : map.values()) {
            Preconditions.checkArgument(!collection.isEmpty());
            this.totalSize += collection.size();
        }
    }

    Collection<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass(this.createCollection());
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(@ParametricNullness K k) {
        return this.createCollection();
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean containsKey(@CheckForNull Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean put(@ParametricNullness K k, @ParametricNullness V v) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            collection = this.createCollection(k);
            if (collection.add(v)) {
                ++this.totalSize;
                this.map.put(k, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(v)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<V> getOrCreateCollection(@ParametricNullness K k) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            collection = this.createCollection(k);
            this.map.put(k, collection);
        }
        return collection;
    }

    @Override
    public Collection<V> replaceValues(@ParametricNullness K k, Iterable<? extends V> iterable) {
        Iterator<V> iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            return this.removeAll(k);
        }
        Collection<V> collection = this.getOrCreateCollection(k);
        Collection<V> collection2 = this.createCollection();
        collection2.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator2.hasNext()) {
            if (!collection.add(iterator2.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass(collection2);
    }

    @Override
    public Collection<V> removeAll(@CheckForNull Object object) {
        Collection<V> collection = this.map.remove(object);
        if (collection == null) {
            return this.createUnmodifiableEmptyCollection();
        }
        Collection<V> collection2 = this.createCollection();
        collection2.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        return this.unmodifiableCollectionSubclass(collection2);
    }

    <E> Collection<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public void clear() {
        for (Collection<V> collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    @Override
    public Collection<V> get(@ParametricNullness K k) {
        Collection<V> collection = this.map.get(k);
        if (collection == null) {
            collection = this.createCollection(k);
        }
        return this.wrapCollection(k, collection);
    }

    Collection<V> wrapCollection(@ParametricNullness K k, Collection<V> collection) {
        return new WrappedCollection(k, collection, null);
    }

    final List<V> wrapList(@ParametricNullness K k, List<V> list, @CheckForNull WrappedCollection wrappedCollection) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(this, k, list, wrappedCollection) : new WrappedList(k, list, wrappedCollection);
    }

    private static <E> Iterator<E> iteratorOrListIterator(Collection<E> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    @Override
    Set<K> createKeySet() {
        return new KeySet(this.map);
    }

    final Set<K> createMaybeNavigableKeySet() {
        if (this.map instanceof NavigableMap) {
            return new NavigableKeySet((NavigableMap)this.map);
        }
        if (this.map instanceof SortedMap) {
            return new SortedKeySet((SortedMap)this.map);
        }
        return new KeySet(this.map);
    }

    private void removeValuesForKey(@CheckForNull Object object) {
        Collection<V> collection = Maps.safeRemove(this.map, object);
        if (collection != null) {
            int n = collection.size();
            collection.clear();
            this.totalSize -= n;
        }
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    Collection<V> createValues() {
        return new AbstractMultimap.Values(this);
    }

    @Override
    Iterator<V> valueIterator() {
        return new Itr<V>(this){

            @Override
            @ParametricNullness
            V output(@ParametricNullness K k, @ParametricNullness V v) {
                return v;
            }
        };
    }

    @Override
    Spliterator<V> valueSpliterator() {
        return CollectSpliterators.flatMap(this.map.values().spliterator(), Collection::spliterator, 64, this.size());
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new AbstractMultimap.EntrySet(this);
        }
        return new AbstractMultimap.Entries(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(this){

            @Override
            Map.Entry<K, V> output(@ParametricNullness K k, @ParametricNullness V v) {
                return Maps.immutableEntry(k, v);
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.flatMap(this.map.entrySet().spliterator(), entry -> {
            Object k = entry.getKey();
            Collection collection = (Collection)entry.getValue();
            return CollectSpliterators.map(collection.spliterator(), object2 -> Maps.immutableEntry(k, object2));
        }, 64, this.size());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        this.map.forEach((object, collection) -> collection.forEach((? super T object2) -> biConsumer.accept((Object)object, (Object)object2)));
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new AsMap(this.map);
    }

    final Map<K, Collection<V>> createMaybeNavigableAsMap() {
        if (this.map instanceof NavigableMap) {
            return new NavigableAsMap((NavigableMap)this.map);
        }
        if (this.map instanceof SortedMap) {
            return new SortedAsMap((SortedMap)this.map);
        }
        return new AsMap(this.map);
    }

    private final class NavigableAsMap
    extends SortedAsMap
    implements NavigableMap<K, Collection<V>> {
        NavigableAsMap(NavigableMap<K, Collection<V>> navigableMap) {
            super(navigableMap);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> lowerEntry(@ParametricNullness K k) {
            Map.Entry entry = this.sortedMap().lowerEntry(k);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        @CheckForNull
        public K lowerKey(@ParametricNullness K k) {
            return this.sortedMap().lowerKey(k);
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> floorEntry(@ParametricNullness K k) {
            Map.Entry entry = this.sortedMap().floorEntry(k);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        @CheckForNull
        public K floorKey(@ParametricNullness K k) {
            return this.sortedMap().floorKey(k);
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> ceilingEntry(@ParametricNullness K k) {
            Map.Entry entry = this.sortedMap().ceilingEntry(k);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        @CheckForNull
        public K ceilingKey(@ParametricNullness K k) {
            return this.sortedMap().ceilingKey(k);
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> higherEntry(@ParametricNullness K k) {
            Map.Entry entry = this.sortedMap().higherEntry(k);
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        @CheckForNull
        public K higherKey(@ParametricNullness K k) {
            return this.sortedMap().higherKey(k);
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> firstEntry() {
            Map.Entry entry = this.sortedMap().firstEntry();
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> lastEntry() {
            Map.Entry entry = this.sortedMap().lastEntry();
            return entry == null ? null : this.wrapEntry(entry);
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> pollFirstEntry() {
            return this.pollAsMapEntry(this.entrySet().iterator());
        }

        @Override
        @CheckForNull
        public Map.Entry<K, Collection<V>> pollLastEntry() {
            return this.pollAsMapEntry(this.descendingMap().entrySet().iterator());
        }

        @CheckForNull
        Map.Entry<K, Collection<V>> pollAsMapEntry(Iterator<Map.Entry<K, Collection<V>>> iterator2) {
            if (!iterator2.hasNext()) {
                return null;
            }
            Map.Entry entry = iterator2.next();
            Collection collection = AbstractMapBasedMultimap.this.createCollection();
            collection.addAll(entry.getValue());
            iterator2.remove();
            return Maps.immutableEntry(entry.getKey(), AbstractMapBasedMultimap.this.unmodifiableCollectionSubclass(collection));
        }

        @Override
        public NavigableMap<K, Collection<V>> descendingMap() {
            return new NavigableAsMap(this.sortedMap().descendingMap());
        }

        @Override
        public NavigableSet<K> keySet() {
            return (NavigableSet)super.keySet();
        }

        @Override
        NavigableSet<K> createKeySet() {
            return new NavigableKeySet(this.sortedMap());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.keySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<K, Collection<V>> subMap(@ParametricNullness K k, @ParametricNullness K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public NavigableMap<K, Collection<V>> subMap(@ParametricNullness K k, boolean bl, @ParametricNullness K k2, boolean bl2) {
            return new NavigableAsMap(this.sortedMap().subMap(k, bl, k2, bl2));
        }

        @Override
        public NavigableMap<K, Collection<V>> headMap(@ParametricNullness K k) {
            return this.headMap(k, false);
        }

        @Override
        public NavigableMap<K, Collection<V>> headMap(@ParametricNullness K k, boolean bl) {
            return new NavigableAsMap(this.sortedMap().headMap(k, bl));
        }

        @Override
        public NavigableMap<K, Collection<V>> tailMap(@ParametricNullness K k) {
            return this.tailMap(k, true);
        }

        @Override
        public NavigableMap<K, Collection<V>> tailMap(@ParametricNullness K k, boolean bl) {
            return new NavigableAsMap(this.sortedMap().tailMap(k, bl));
        }
    }

    private class SortedAsMap
    extends AsMap
    implements SortedMap<K, Collection<V>> {
        @CheckForNull
        SortedSet<K> sortedKeySet;

        SortedAsMap(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)this.submap;
        }

        @Override
        @CheckForNull
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        @ParametricNullness
        public K firstKey() {
            return this.sortedMap().firstKey();
        }

        @Override
        @ParametricNullness
        public K lastKey() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedMap<K, Collection<V>> headMap(@ParametricNullness K k) {
            return new SortedAsMap(this.sortedMap().headMap(k));
        }

        @Override
        public SortedMap<K, Collection<V>> subMap(@ParametricNullness K k, @ParametricNullness K k2) {
            return new SortedAsMap(this.sortedMap().subMap(k, k2));
        }

        @Override
        public SortedMap<K, Collection<V>> tailMap(@ParametricNullness K k) {
            return new SortedAsMap(this.sortedMap().tailMap(k));
        }

        @Override
        public SortedSet<K> keySet() {
            SortedSet sortedSet = this.sortedKeySet;
            return sortedSet == null ? (this.sortedKeySet = this.createKeySet()) : sortedSet;
        }

        @Override
        SortedSet<K> createKeySet() {
            return new SortedKeySet(this.sortedMap());
        }
    }

    private class AsMap
    extends Maps.ViewCachingAbstractMap<K, Collection<V>> {
        final transient Map<K, Collection<V>> submap;

        AsMap(Map<K, Collection<V>> map) {
            this.submap = map;
        }

        @Override
        protected Set<Map.Entry<K, Collection<V>>> createEntrySet() {
            return new AsMapEntries();
        }

        @Override
        public boolean containsKey(@CheckForNull Object object) {
            return Maps.safeContainsKey(this.submap, object);
        }

        @Override
        @CheckForNull
        public Collection<V> get(@CheckForNull Object object) {
            Collection collection = Maps.safeGet(this.submap, object);
            if (collection == null) {
                return null;
            }
            Object object2 = object;
            return AbstractMapBasedMultimap.this.wrapCollection(object2, collection);
        }

        @Override
        public Set<K> keySet() {
            return AbstractMapBasedMultimap.this.keySet();
        }

        @Override
        public int size() {
            return this.submap.size();
        }

        @Override
        @CheckForNull
        public Collection<V> remove(@CheckForNull Object object) {
            Collection collection = this.submap.remove(object);
            if (collection == null) {
                return null;
            }
            Collection collection2 = AbstractMapBasedMultimap.this.createCollection();
            collection2.addAll(collection);
            AbstractMapBasedMultimap.this.totalSize -= collection.size();
            collection.clear();
            return collection2;
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            return this == object || this.submap.equals(object);
        }

        @Override
        public int hashCode() {
            return this.submap.hashCode();
        }

        @Override
        public String toString() {
            return this.submap.toString();
        }

        @Override
        public void clear() {
            if (this.submap == AbstractMapBasedMultimap.this.map) {
                AbstractMapBasedMultimap.this.clear();
            } else {
                Iterators.clear(new AsMapIterator());
            }
        }

        Map.Entry<K, Collection<V>> wrapEntry(Map.Entry<K, Collection<V>> entry) {
            Object k = entry.getKey();
            return Maps.immutableEntry(k, AbstractMapBasedMultimap.this.wrapCollection(k, entry.getValue()));
        }

        class AsMapIterator
        implements Iterator<Map.Entry<K, Collection<V>>> {
            final Iterator<Map.Entry<K, Collection<V>>> delegateIterator;
            @CheckForNull
            Collection<V> collection;

            AsMapIterator() {
                this.delegateIterator = AsMap.this.submap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Collection<V>> next() {
                Map.Entry entry = this.delegateIterator.next();
                this.collection = entry.getValue();
                return AsMap.this.wrapEntry(entry);
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.collection != null, "no calls to next() since the last call to remove()");
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.this.totalSize -= this.collection.size();
                this.collection.clear();
                this.collection = null;
            }
        }

        class AsMapEntries
        extends Maps.EntrySet<K, Collection<V>> {
            AsMapEntries() {
            }

            @Override
            Map<K, Collection<V>> map() {
                return AsMap.this;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new AsMapIterator();
            }

            @Override
            public Spliterator<Map.Entry<K, Collection<V>>> spliterator() {
                return CollectSpliterators.map(AsMap.this.submap.entrySet().spliterator(), AsMap.this::wrapEntry);
            }

            @Override
            public boolean contains(@CheckForNull Object object) {
                return Collections2.safeContains(AsMap.this.submap.entrySet(), object);
            }

            @Override
            public boolean remove(@CheckForNull Object object) {
                if (!this.contains(object)) {
                    return false;
                }
                Map.Entry entry = Objects.requireNonNull((Map.Entry)object);
                AbstractMapBasedMultimap.this.removeValuesForKey(entry.getKey());
                return true;
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        final Iterator<Map.Entry<K, Collection<V>>> keyIterator;
        @CheckForNull
        K key;
        @CheckForNull
        Collection<V> collection;
        Iterator<V> valueIterator;

        Itr() {
            this.keyIterator = AbstractMapBasedMultimap.this.map.entrySet().iterator();
            this.key = null;
            this.collection = null;
            this.valueIterator = Iterators.emptyModifiableIterator();
        }

        abstract T output(@ParametricNullness K var1, @ParametricNullness V var2);

        @Override
        public boolean hasNext() {
            return this.keyIterator.hasNext() || this.valueIterator.hasNext();
        }

        @Override
        @ParametricNullness
        public T next() {
            if (!this.valueIterator.hasNext()) {
                Map.Entry entry = this.keyIterator.next();
                this.key = entry.getKey();
                this.collection = entry.getValue();
                this.valueIterator = this.collection.iterator();
            }
            return this.output(NullnessCasts.uncheckedCastNullableTToT(this.key), this.valueIterator.next());
        }

        @Override
        public void remove() {
            this.valueIterator.remove();
            if (Objects.requireNonNull(this.collection).isEmpty()) {
                this.keyIterator.remove();
            }
            AbstractMapBasedMultimap.this.totalSize--;
        }
    }

    private final class NavigableKeySet
    extends SortedKeySet
    implements NavigableSet<K> {
        NavigableKeySet(NavigableMap<K, Collection<V>> navigableMap) {
            super(navigableMap);
        }

        NavigableMap<K, Collection<V>> sortedMap() {
            return (NavigableMap)super.sortedMap();
        }

        @Override
        @CheckForNull
        public K lower(@ParametricNullness K k) {
            return this.sortedMap().lowerKey(k);
        }

        @Override
        @CheckForNull
        public K floor(@ParametricNullness K k) {
            return this.sortedMap().floorKey(k);
        }

        @Override
        @CheckForNull
        public K ceiling(@ParametricNullness K k) {
            return this.sortedMap().ceilingKey(k);
        }

        @Override
        @CheckForNull
        public K higher(@ParametricNullness K k) {
            return this.sortedMap().higherKey(k);
        }

        @Override
        @CheckForNull
        public K pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        @Override
        @CheckForNull
        public K pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new NavigableKeySet(this.sortedMap().descendingMap());
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> headSet(@ParametricNullness K k) {
            return this.headSet((K)k, false);
        }

        @Override
        public NavigableSet<K> headSet(@ParametricNullness K k, boolean bl) {
            return new NavigableKeySet(this.sortedMap().headMap(k, bl));
        }

        @Override
        public NavigableSet<K> subSet(@ParametricNullness K k, @ParametricNullness K k2) {
            return this.subSet((K)k, true, (K)k2, false);
        }

        @Override
        public NavigableSet<K> subSet(@ParametricNullness K k, boolean bl, @ParametricNullness K k2, boolean bl2) {
            return new NavigableKeySet(this.sortedMap().subMap(k, bl, k2, bl2));
        }

        @Override
        public NavigableSet<K> tailSet(@ParametricNullness K k) {
            return this.tailSet((K)k, true);
        }

        @Override
        public NavigableSet<K> tailSet(@ParametricNullness K k, boolean bl) {
            return new NavigableKeySet(this.sortedMap().tailMap(k, bl));
        }
    }

    private class SortedKeySet
    extends KeySet
    implements SortedSet<K> {
        SortedKeySet(SortedMap<K, Collection<V>> sortedMap) {
            super(sortedMap);
        }

        SortedMap<K, Collection<V>> sortedMap() {
            return (SortedMap)super.map();
        }

        @Override
        @CheckForNull
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        @ParametricNullness
        public K first() {
            return this.sortedMap().firstKey();
        }

        @Override
        public SortedSet<K> headSet(@ParametricNullness K k) {
            return new SortedKeySet(this.sortedMap().headMap(k));
        }

        @Override
        @ParametricNullness
        public K last() {
            return this.sortedMap().lastKey();
        }

        @Override
        public SortedSet<K> subSet(@ParametricNullness K k, @ParametricNullness K k2) {
            return new SortedKeySet(this.sortedMap().subMap(k, k2));
        }

        @Override
        public SortedSet<K> tailSet(@ParametricNullness K k) {
            return new SortedKeySet(this.sortedMap().tailMap(k));
        }
    }

    private class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        KeySet(Map<K, Collection<V>> map) {
            super(map);
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator iterator2 = this.map().entrySet().iterator();
            return new Iterator<K>(){
                @CheckForNull
                Map.Entry<K, Collection<V>> entry;

                @Override
                public boolean hasNext() {
                    return iterator2.hasNext();
                }

                @Override
                @ParametricNullness
                public K next() {
                    this.entry = (Map.Entry)iterator2.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.entry != null, "no calls to next() since the last call to remove()");
                    Collection collection = this.entry.getValue();
                    iterator2.remove();
                    AbstractMapBasedMultimap.this.totalSize -= collection.size();
                    collection.clear();
                    this.entry = null;
                }
            };
        }

        @Override
        public Spliterator<K> spliterator() {
            return this.map().keySet().spliterator();
        }

        @Override
        public boolean remove(@CheckForNull Object object) {
            int n = 0;
            Collection collection = (Collection)this.map().remove(object);
            if (collection != null) {
                n = collection.size();
                collection.clear();
                AbstractMapBasedMultimap.this.totalSize -= n;
            }
            return n > 0;
        }

        @Override
        public void clear() {
            Iterators.clear(this.iterator());
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.map().keySet().containsAll(collection);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            return this == object || this.map().keySet().equals(object);
        }

        @Override
        public int hashCode() {
            return this.map().keySet().hashCode();
        }
    }

    private class RandomAccessWrappedList
    extends WrappedList
    implements RandomAccess {
        RandomAccessWrappedList(AbstractMapBasedMultimap abstractMapBasedMultimap, @ParametricNullness K k, List<V> list, @CheckForNull WrappedCollection wrappedCollection) {
            super(k, list, wrappedCollection);
        }
    }

    class WrappedList
    extends WrappedCollection
    implements List<V> {
        WrappedList(@ParametricNullness K k, List<V> list, @CheckForNull WrappedCollection wrappedCollection) {
            super(k, list, wrappedCollection);
        }

        List<V> getListDelegate() {
            return (List)this.getDelegate();
        }

        @Override
        public boolean addAll(int n, Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n2 = this.size();
            boolean bl = this.getListDelegate().addAll(n, collection);
            if (bl) {
                int n3 = this.getDelegate().size();
                AbstractMapBasedMultimap.this.totalSize += n3 - n2;
                if (n2 == 0) {
                    this.addToMap();
                }
            }
            return bl;
        }

        @Override
        @ParametricNullness
        public V get(int n) {
            this.refreshIfEmpty();
            return this.getListDelegate().get(n);
        }

        @Override
        @ParametricNullness
        public V set(int n, @ParametricNullness V v) {
            this.refreshIfEmpty();
            return this.getListDelegate().set(n, v);
        }

        @Override
        public void add(int n, @ParametricNullness V v) {
            this.refreshIfEmpty();
            boolean bl = this.getDelegate().isEmpty();
            this.getListDelegate().add(n, v);
            AbstractMapBasedMultimap.this.totalSize++;
            if (bl) {
                this.addToMap();
            }
        }

        @Override
        @ParametricNullness
        public V remove(int n) {
            this.refreshIfEmpty();
            Object v = this.getListDelegate().remove(n);
            AbstractMapBasedMultimap.this.totalSize--;
            this.removeIfEmpty();
            return v;
        }

        @Override
        public int indexOf(@CheckForNull Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().indexOf(object);
        }

        @Override
        public int lastIndexOf(@CheckForNull Object object) {
            this.refreshIfEmpty();
            return this.getListDelegate().lastIndexOf(object);
        }

        @Override
        public ListIterator<V> listIterator() {
            this.refreshIfEmpty();
            return new WrappedListIterator();
        }

        @Override
        public ListIterator<V> listIterator(int n) {
            this.refreshIfEmpty();
            return new WrappedListIterator(n);
        }

        @Override
        public List<V> subList(int n, int n2) {
            this.refreshIfEmpty();
            return AbstractMapBasedMultimap.this.wrapList(this.getKey(), this.getListDelegate().subList(n, n2), this.getAncestor() == null ? this : this.getAncestor());
        }

        /*
         * Signature claims super is com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection.WrappedIterator, not com.google.common.collect.AbstractMapBasedMultimap$WrappedCollection$WrappedIterator - discarding signature.
         */
        private class WrappedListIterator
        extends WrappedCollection.WrappedIterator
        implements ListIterator {
            WrappedListIterator() {
            }

            public WrappedListIterator(int n) {
                super(WrappedList.this.getListDelegate().listIterator(n));
            }

            private ListIterator<V> getDelegateListIterator() {
                return (ListIterator)this.getDelegateIterator();
            }

            @Override
            public boolean hasPrevious() {
                return this.getDelegateListIterator().hasPrevious();
            }

            @ParametricNullness
            public V previous() {
                return this.getDelegateListIterator().previous();
            }

            @Override
            public int nextIndex() {
                return this.getDelegateListIterator().nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.getDelegateListIterator().previousIndex();
            }

            public void set(@ParametricNullness V v) {
                this.getDelegateListIterator().set(v);
            }

            public void add(@ParametricNullness V v) {
                boolean bl = WrappedList.this.isEmpty();
                this.getDelegateListIterator().add(v);
                AbstractMapBasedMultimap.this.totalSize++;
                if (bl) {
                    WrappedList.this.addToMap();
                }
            }
        }
    }

    class WrappedNavigableSet
    extends WrappedSortedSet
    implements NavigableSet<V> {
        WrappedNavigableSet(@ParametricNullness K k, NavigableSet<V> navigableSet, @CheckForNull WrappedCollection wrappedCollection) {
            super(k, navigableSet, wrappedCollection);
        }

        NavigableSet<V> getSortedSetDelegate() {
            return (NavigableSet)super.getSortedSetDelegate();
        }

        @Override
        @CheckForNull
        public V lower(@ParametricNullness V v) {
            return this.getSortedSetDelegate().lower(v);
        }

        @Override
        @CheckForNull
        public V floor(@ParametricNullness V v) {
            return this.getSortedSetDelegate().floor(v);
        }

        @Override
        @CheckForNull
        public V ceiling(@ParametricNullness V v) {
            return this.getSortedSetDelegate().ceiling(v);
        }

        @Override
        @CheckForNull
        public V higher(@ParametricNullness V v) {
            return this.getSortedSetDelegate().higher(v);
        }

        @Override
        @CheckForNull
        public V pollFirst() {
            return Iterators.pollNext(this.iterator());
        }

        @Override
        @CheckForNull
        public V pollLast() {
            return Iterators.pollNext(this.descendingIterator());
        }

        private NavigableSet<V> wrap(NavigableSet<V> navigableSet) {
            return new WrappedNavigableSet(this.key, navigableSet, this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public NavigableSet<V> descendingSet() {
            return this.wrap(this.getSortedSetDelegate().descendingSet());
        }

        @Override
        public Iterator<V> descendingIterator() {
            return new WrappedCollection.WrappedIterator(this.getSortedSetDelegate().descendingIterator());
        }

        @Override
        public NavigableSet<V> subSet(@ParametricNullness V v, boolean bl, @ParametricNullness V v2, boolean bl2) {
            return this.wrap(this.getSortedSetDelegate().subSet(v, bl, v2, bl2));
        }

        @Override
        public NavigableSet<V> headSet(@ParametricNullness V v, boolean bl) {
            return this.wrap(this.getSortedSetDelegate().headSet(v, bl));
        }

        @Override
        public NavigableSet<V> tailSet(@ParametricNullness V v, boolean bl) {
            return this.wrap(this.getSortedSetDelegate().tailSet(v, bl));
        }
    }

    class WrappedSortedSet
    extends WrappedCollection
    implements SortedSet<V> {
        WrappedSortedSet(@ParametricNullness K k, SortedSet<V> sortedSet, @CheckForNull WrappedCollection wrappedCollection) {
            super(k, sortedSet, wrappedCollection);
        }

        SortedSet<V> getSortedSetDelegate() {
            return (SortedSet)this.getDelegate();
        }

        @Override
        @CheckForNull
        public Comparator<? super V> comparator() {
            return this.getSortedSetDelegate().comparator();
        }

        @Override
        @ParametricNullness
        public V first() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().first();
        }

        @Override
        @ParametricNullness
        public V last() {
            this.refreshIfEmpty();
            return this.getSortedSetDelegate().last();
        }

        @Override
        public SortedSet<V> headSet(@ParametricNullness V v) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().headSet(v), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> subSet(@ParametricNullness V v, @ParametricNullness V v2) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().subSet(v, v2), this.getAncestor() == null ? this : this.getAncestor());
        }

        @Override
        public SortedSet<V> tailSet(@ParametricNullness V v) {
            this.refreshIfEmpty();
            return new WrappedSortedSet(this.getKey(), this.getSortedSetDelegate().tailSet(v), this.getAncestor() == null ? this : this.getAncestor());
        }
    }

    class WrappedSet
    extends WrappedCollection
    implements Set<V> {
        WrappedSet(@ParametricNullness K k, Set<V> set) {
            super(k, set, null);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n = this.size();
            boolean bl = Sets.removeAllImpl((Set)this.delegate, collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n2 - n;
                this.removeIfEmpty();
            }
            return bl;
        }
    }

    class WrappedCollection
    extends AbstractCollection<V> {
        @ParametricNullness
        final K key;
        Collection<V> delegate;
        @CheckForNull
        final WrappedCollection ancestor;
        @CheckForNull
        final Collection<V> ancestorDelegate;

        WrappedCollection(@ParametricNullness K k, Collection<V> collection, @CheckForNull WrappedCollection wrappedCollection) {
            this.key = k;
            this.delegate = collection;
            this.ancestor = wrappedCollection;
            this.ancestorDelegate = wrappedCollection == null ? null : wrappedCollection.getDelegate();
        }

        void refreshIfEmpty() {
            Collection collection;
            if (this.ancestor != null) {
                this.ancestor.refreshIfEmpty();
                if (this.ancestor.getDelegate() != this.ancestorDelegate) {
                    throw new ConcurrentModificationException();
                }
            } else if (this.delegate.isEmpty() && (collection = (Collection)AbstractMapBasedMultimap.this.map.get(this.key)) != null) {
                this.delegate = collection;
            }
        }

        void removeIfEmpty() {
            if (this.ancestor != null) {
                this.ancestor.removeIfEmpty();
            } else if (this.delegate.isEmpty()) {
                AbstractMapBasedMultimap.this.map.remove(this.key);
            }
        }

        @ParametricNullness
        K getKey() {
            return this.key;
        }

        void addToMap() {
            if (this.ancestor != null) {
                this.ancestor.addToMap();
            } else {
                AbstractMapBasedMultimap.this.map.put(this.key, this.delegate);
            }
        }

        @Override
        public int size() {
            this.refreshIfEmpty();
            return this.delegate.size();
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            this.refreshIfEmpty();
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            this.refreshIfEmpty();
            return this.delegate.hashCode();
        }

        @Override
        public String toString() {
            this.refreshIfEmpty();
            return this.delegate.toString();
        }

        Collection<V> getDelegate() {
            return this.delegate;
        }

        @Override
        public Iterator<V> iterator() {
            this.refreshIfEmpty();
            return new WrappedIterator();
        }

        @Override
        public Spliterator<V> spliterator() {
            this.refreshIfEmpty();
            return this.delegate.spliterator();
        }

        @Override
        public boolean add(@ParametricNullness V v) {
            this.refreshIfEmpty();
            boolean bl = this.delegate.isEmpty();
            boolean bl2 = this.delegate.add(v);
            if (bl2) {
                AbstractMapBasedMultimap.this.totalSize++;
                if (bl) {
                    this.addToMap();
                }
            }
            return bl2;
        }

        @CheckForNull
        WrappedCollection getAncestor() {
            return this.ancestor;
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n = this.size();
            boolean bl = this.delegate.addAll(collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n2 - n;
                if (n == 0) {
                    this.addToMap();
                }
            }
            return bl;
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            this.refreshIfEmpty();
            return this.delegate.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            this.refreshIfEmpty();
            return this.delegate.containsAll(collection);
        }

        @Override
        public void clear() {
            int n = this.size();
            if (n == 0) {
                return;
            }
            this.delegate.clear();
            AbstractMapBasedMultimap.this.totalSize -= n;
            this.removeIfEmpty();
        }

        @Override
        public boolean remove(@CheckForNull Object object) {
            this.refreshIfEmpty();
            boolean bl = this.delegate.remove(object);
            if (bl) {
                AbstractMapBasedMultimap.this.totalSize--;
                this.removeIfEmpty();
            }
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            int n = this.size();
            boolean bl = this.delegate.removeAll(collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n2 - n;
                this.removeIfEmpty();
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Preconditions.checkNotNull(collection);
            int n = this.size();
            boolean bl = this.delegate.retainAll(collection);
            if (bl) {
                int n2 = this.delegate.size();
                AbstractMapBasedMultimap.this.totalSize += n2 - n;
                this.removeIfEmpty();
            }
            return bl;
        }

        class WrappedIterator
        implements Iterator<V> {
            final Iterator<V> delegateIterator;
            final Collection<V> originalDelegate;

            WrappedIterator() {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = AbstractMapBasedMultimap.iteratorOrListIterator(WrappedCollection.this.delegate);
            }

            WrappedIterator(Iterator<V> iterator2) {
                this.originalDelegate = WrappedCollection.this.delegate;
                this.delegateIterator = iterator2;
            }

            void validateIterator() {
                WrappedCollection.this.refreshIfEmpty();
                if (WrappedCollection.this.delegate != this.originalDelegate) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                this.validateIterator();
                return this.delegateIterator.hasNext();
            }

            @Override
            @ParametricNullness
            public V next() {
                this.validateIterator();
                return this.delegateIterator.next();
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                AbstractMapBasedMultimap.this.totalSize--;
                WrappedCollection.this.removeIfEmpty();
            }

            Iterator<V> getDelegateIterator() {
                this.validateIterator();
                return this.delegateIterator;
            }
        }
    }
}

