/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.ElementTypesAreNonnullByDefault;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Verify {
    public static void verify(boolean bl) {
        if (!bl) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, objectArray));
        }
    }

    public static void verify(boolean bl, String string, char c) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c)));
        }
    }

    public static void verify(boolean bl, String string, int n) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, n));
        }
    }

    public static void verify(boolean bl, String string, long l) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, l));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object));
        }
    }

    public static void verify(boolean bl, String string, char c, char c2) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c), Character.valueOf(c2)));
        }
    }

    public static void verify(boolean bl, String string, int n, char c) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, n, Character.valueOf(c)));
        }
    }

    public static void verify(boolean bl, String string, long l, char c) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, l, Character.valueOf(c)));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object, char c) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object, Character.valueOf(c)));
        }
    }

    public static void verify(boolean bl, String string, char c, int n) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c), n));
        }
    }

    public static void verify(boolean bl, String string, int n, int n2) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, n, n2));
        }
    }

    public static void verify(boolean bl, String string, long l, int n) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, l, n));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object, int n) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object, n));
        }
    }

    public static void verify(boolean bl, String string, char c, long l) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c), l));
        }
    }

    public static void verify(boolean bl, String string, int n, long l) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, n, l));
        }
    }

    public static void verify(boolean bl, String string, long l, long l2) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, l, l2));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object, long l) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object, l));
        }
    }

    public static void verify(boolean bl, String string, char c, @CheckForNull Object object) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c), object));
        }
    }

    public static void verify(boolean bl, String string, int n, @CheckForNull Object object) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, n, object));
        }
    }

    public static void verify(boolean bl, String string, long l, @CheckForNull Object object) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, l, object));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object, object2, object3));
        }
    }

    public static void verify(boolean bl, String string, @CheckForNull Object object, @CheckForNull Object object2, @CheckForNull Object object3, @CheckForNull Object object4) {
        if (!bl) {
            throw new VerifyException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@CheckForNull T t2) {
        return Verify.verifyNotNull(t2, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@CheckForNull T t2, String string, Object ... objectArray) {
        if (t2 == null) {
            throw new VerifyException(Strings.lenientFormat(string, objectArray));
        }
        return t2;
    }

    private Verify() {
    }
}

