/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.json.DupDetector;

public final class CBORReadContext
extends JsonStreamContext {
    protected final CBORReadContext _parent;
    protected final DupDetector _dups;
    protected int _expEntryCount;
    protected String _currentName;
    protected Object _currentValue;
    protected CBORReadContext _child = null;

    public CBORReadContext(CBORReadContext cBORReadContext, DupDetector dupDetector, int n, int n2) {
        this._parent = cBORReadContext;
        this._dups = dupDetector;
        this._type = n;
        this._expEntryCount = n2;
        this._index = -1;
    }

    protected void reset(int n, int n2) {
        this._type = n;
        this._expEntryCount = n2;
        this._index = -1;
        this._currentName = null;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public static CBORReadContext createRootContext(DupDetector dupDetector) {
        return new CBORReadContext(null, dupDetector, 0, -1);
    }

    public CBORReadContext createChildArrayContext(int n) {
        CBORReadContext cBORReadContext = this._child;
        if (cBORReadContext == null) {
            this._child = cBORReadContext = new CBORReadContext(this, this._dups == null ? null : this._dups.child(), 1, n);
        } else {
            cBORReadContext.reset(1, n);
        }
        return cBORReadContext;
    }

    public CBORReadContext createChildObjectContext(int n) {
        CBORReadContext cBORReadContext = this._child;
        if (cBORReadContext == null) {
            this._child = cBORReadContext = new CBORReadContext(this, this._dups == null ? null : this._dups.child(), 2, n);
            return cBORReadContext;
        }
        cBORReadContext.reset(2, n);
        return cBORReadContext;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public CBORReadContext getParent() {
        return this._parent;
    }

    public boolean hasExpectedLength() {
        return this._expEntryCount >= 0;
    }

    public int getExpectedLength() {
        return this._expEntryCount;
    }

    public boolean acceptsBreakMarker() {
        return this._expEntryCount < 0 && this._type != 0;
    }

    public boolean expectMoreValues() {
        return ++this._index != this._expEntryCount;
    }

    @Override
    public JsonLocation getStartLocation(Object object) {
        return new JsonLocation(object, 1L, -1, -1);
    }

    public void setCurrentName(String string) throws JsonProcessingException {
        this._currentName = string;
        if (this._dups != null) {
            this._checkDup(this._dups, string);
        }
    }

    private void _checkDup(DupDetector dupDetector, String string) throws JsonProcessingException {
        if (dupDetector.isDup(string)) {
            throw new JsonParseException(null, "Duplicate field '" + string + "'", dupDetector.findLocation());
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

