/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.fasterxml.jackson.dataformat.cbor.CBORWriteContext;
import com.fasterxml.jackson.dataformat.cbor.PackageVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class CBORGenerator
extends GeneratorBase {
    private static final int[] NO_INTS = new int[0];
    static final int BYTE_BUFFER_FOR_OUTPUT = 16000;
    static final int REPLACEMENT_CHAR = 65533;
    private static final int MAX_LONG_STRING_CHARS = 3996;
    private static final int MAX_LONG_STRING_BYTES = 11991;
    private static final int MIN_BUFFER_LENGTH = 770;
    private static final int INDEFINITE_LENGTH = -2;
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _formatFeatures;
    protected boolean _cfgMinimalInts;
    protected CBORWriteContext _cborContext;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected int _bytesWritten;
    protected int[] _elementCounts = NO_INTS;
    protected int _elementCountsPtr;
    protected int _currentRemainingElements = -2;
    protected boolean _bufferRecyclable;
    private static final int MAX_SHORT_STRING_CHARS = 23;
    private static final int MAX_SHORT_STRING_BYTES = 71;
    private static final int MAX_MEDIUM_STRING_CHARS = 255;
    private static final int MAX_MEDIUM_STRING_BYTES = 768;

    public CBORGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream2) {
        super(n, objectCodec, null);
        DupDetector dupDetector = JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector(this) : null;
        this._cborContext = CBORWriteContext.createRootContext(dupDetector);
        this._formatFeatures = n2;
        this._cfgMinimalInts = Feature.WRITE_MINIMAL_INTS.enabledIn(n2);
        this._ioContext = iOContext;
        this._out = outputStream2;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer(16000);
        this._outputEnd = this._outputBuffer.length;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least " + 770);
        }
    }

    public CBORGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream2, byte[] byArray, int n3, boolean bl) {
        super(n, objectCodec, null);
        DupDetector dupDetector = JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector(this) : null;
        this._cborContext = CBORWriteContext.createRootContext(dupDetector);
        this._formatFeatures = n2;
        this._cfgMinimalInts = Feature.WRITE_MINIMAL_INTS.enabledIn(n2);
        this._ioContext = iOContext;
        this._out = outputStream2;
        this._bufferRecyclable = bl;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least " + 770);
        }
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_BINARY_WRITE_CAPABILITIES;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._out;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n, int n2) {
        int n3 = this._features;
        int n4 = n3 & ~n2 | n & n2;
        if (n3 != n4) {
            this._features = n4;
        }
        return this;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n, int n2) {
        int n3 = this._formatFeatures;
        int n4 = this._formatFeatures & ~n2 | n & n2;
        if (n3 != n4) {
            this._formatFeatures = n4;
            this._cfgMinimalInts = Feature.WRITE_MINIMAL_INTS.enabledIn(n4);
        }
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._cborContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._cborContext.setCurrentValue(object);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._cborContext;
    }

    public CBORGenerator enable(Feature feature) {
        this._formatFeatures |= feature.getMask();
        if (feature == Feature.WRITE_MINIMAL_INTS) {
            this._cfgMinimalInts = true;
        }
        return this;
    }

    public CBORGenerator disable(Feature feature) {
        this._formatFeatures &= ~feature.getMask();
        if (feature == Feature.WRITE_MINIMAL_INTS) {
            this._cfgMinimalInts = false;
        }
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._formatFeatures & feature.getMask()) != 0;
    }

    public CBORGenerator configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    @Override
    public final void writeFieldName(String string) throws IOException {
        if (!this._cborContext.writeFieldName(string)) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeString(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) throws IOException {
        byte[] byArray;
        int n;
        if (!this._cborContext.writeFieldName(serializableString.getValue())) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if ((n = (byArray = serializableString.asUnquotedUTF8()).length) == 0) {
            this._writeByte((byte)96);
            return;
        }
        this._writeLengthMarker(96, n);
        this._writeBytes(byArray, 0, n);
    }

    @Override
    public final void writeFieldId(long l) throws IOException {
        if (!this._cborContext.writeFieldId(l)) {
            this._reportError("Can not write a field id, expecting a value");
        }
        this._writeLongNoCheck(l);
    }

    @Override
    public void copyCurrentEvent(JsonParser jsonParser) throws IOException {
        this.maybeCopyTag(jsonParser);
        super.copyCurrentEvent(jsonParser);
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) throws IOException {
        this.maybeCopyTag(jsonParser);
        super.copyCurrentStructure(jsonParser);
    }

    protected void maybeCopyTag(JsonParser jsonParser) throws IOException {
        int n;
        if (jsonParser instanceof CBORParser && jsonParser.hasCurrentToken() && (n = ((CBORParser)jsonParser).getCurrentTag()) != -1) {
            this.writeTag(n);
        }
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._cborContext = this._cborContext.createChildArrayContext(null);
        if (this._elementCountsPtr > 0) {
            this._pushRemainingElements();
        }
        this._currentRemainingElements = -2;
        this._writeByte((byte)-97);
    }

    @Override
    public void writeStartArray(Object object) throws IOException {
        this._verifyValueWrite("start an array");
        this._cborContext = this._cborContext.createChildArrayContext(object);
        if (this._elementCountsPtr > 0) {
            this._pushRemainingElements();
        }
        this._currentRemainingElements = -2;
        this._writeByte((byte)-97);
    }

    @Override
    public void writeStartArray(Object object, int n) throws IOException {
        this._verifyValueWrite("start an array");
        this._cborContext = this._cborContext.createChildArrayContext(object);
        this._pushRemainingElements();
        this._currentRemainingElements = n;
        this._writeLengthMarker(128, n);
    }

    @Override
    @Deprecated
    public void writeStartArray(int n) throws IOException {
        this._verifyValueWrite("start an array");
        this._cborContext = this._cborContext.createChildArrayContext(null);
        this._pushRemainingElements();
        this._currentRemainingElements = n;
        this._writeLengthMarker(128, n);
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._cborContext.inArray()) {
            this._reportError("Current context not Array but " + this._cborContext.typeDesc());
        }
        this.closeComplexElement();
        this._cborContext = this._cborContext.getParent();
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._cborContext = this._cborContext.createChildObjectContext(null);
        if (this._elementCountsPtr > 0) {
            this._pushRemainingElements();
        }
        this._currentRemainingElements = -2;
        this._writeByte((byte)-65);
    }

    @Override
    public final void writeStartObject(Object object) throws IOException {
        CBORWriteContext cBORWriteContext;
        this._verifyValueWrite("start an object");
        this._cborContext = cBORWriteContext = this._cborContext.createChildObjectContext(object);
        if (this._elementCountsPtr > 0) {
            this._pushRemainingElements();
        }
        this._currentRemainingElements = -2;
        this._writeByte((byte)-65);
    }

    public final void writeStartObject(int n) throws IOException {
        this._verifyValueWrite("start an object");
        this._cborContext = this._cborContext.createChildObjectContext(null);
        this._pushRemainingElements();
        this._currentRemainingElements = n;
        this._writeLengthMarker(160, n);
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._cborContext.inObject()) {
            this._reportError("Current context not Object but " + this._cborContext.typeDesc());
        }
        this.closeComplexElement();
        this._cborContext = this._cborContext.getParent();
    }

    @Override
    public void writeArray(int[] nArray, int n, int n2) throws IOException {
        this._verifyOffsets(nArray.length, n, n2);
        this._verifyValueWrite("write int array");
        this._writeLengthMarker(128, n2);
        if (this._cfgMinimalInts) {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                int n4 = nArray[i];
                if (n4 < 0) {
                    this._writeIntMinimal(32, -n4 - 1);
                    continue;
                }
                this._writeIntMinimal(0, n4);
            }
        } else {
            int n5 = n + n2;
            for (int i = n; i < n5; ++i) {
                int n6 = nArray[i];
                if (n6 < 0) {
                    this._writeIntFull(32, -n6 - 1);
                    continue;
                }
                this._writeIntFull(0, n6);
            }
        }
    }

    @Override
    public void writeArray(long[] lArray, int n, int n2) throws IOException {
        this._verifyOffsets(lArray.length, n, n2);
        this._verifyValueWrite("write int array");
        this._writeLengthMarker(128, n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this._writeLongNoCheck(lArray[i]);
        }
    }

    @Override
    public void writeArray(double[] dArray, int n, int n2) throws IOException {
        this._verifyOffsets(dArray.length, n, n2);
        this._verifyValueWrite("write int array");
        this._writeLengthMarker(128, n2);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this._writeDoubleNoCheck(dArray[i]);
        }
    }

    private final void _pushRemainingElements() {
        if (this._elementCounts.length == this._elementCountsPtr) {
            this._elementCounts = Arrays.copyOf(this._elementCounts, this._elementCounts.length + 10);
        }
        this._elementCounts[this._elementCountsPtr++] = this._currentRemainingElements;
    }

    private final void _writeIntMinimal(int n, int n2) throws IOException {
        byte by;
        this._ensureRoomForOutput(5);
        if (n2 >= 0) {
            if (n2 < 24) {
                this._outputBuffer[this._outputTail++] = (byte)(n + n2);
                return;
            }
            if (n2 <= 255) {
                this._outputBuffer[this._outputTail++] = (byte)(n + 24);
                this._outputBuffer[this._outputTail++] = (byte)n2;
                return;
            }
            by = (byte)n2;
            if ((n2 >>= 8) <= 255) {
                this._outputBuffer[this._outputTail++] = (byte)(n + 25);
                this._outputBuffer[this._outputTail++] = (byte)n2;
                this._outputBuffer[this._outputTail++] = by;
                return;
            }
        } else {
            by = (byte)n2;
            n2 >>= 8;
        }
        this._outputBuffer[this._outputTail++] = (byte)(n + 26);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n2;
        this._outputBuffer[this._outputTail++] = by;
    }

    private final void _writeIntFull(int n, int n2) throws IOException {
        this._ensureRoomForOutput(5);
        this._outputBuffer[this._outputTail++] = (byte)(n + 26);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n2;
    }

    private final void _writeLongNoCheck(long l) throws IOException {
        if (this._cfgMinimalInts) {
            if (l >= 0L) {
                if (l < 0x100000000L) {
                    this._writeIntMinimal(0, (int)l);
                    return;
                }
            } else if (l >= -4294967296L) {
                this._writeIntMinimal(32, (int)(-l - 1L));
                return;
            }
        }
        this._ensureRoomForOutput(9);
        if (l < 0L) {
            ++l;
            l = -l;
            this._outputBuffer[this._outputTail++] = 59;
        } else {
            this._outputBuffer[this._outputTail++] = 27;
        }
        int n = (int)(l >> 32);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
        n = (int)l;
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
    }

    private final void _writeDoubleNoCheck(double d) throws IOException {
        this._ensureRoomForOutput(11);
        long l = Double.doubleToRawLongBits(d);
        this._outputBuffer[this._outputTail++] = -5;
        int n = (int)(l >> 32);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
        n = (int)l;
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
    }

    @Override
    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeString(string);
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write String value");
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n = byArray.length;
        if (n == 0) {
            this._writeByte((byte)96);
            return;
        }
        this._writeLengthMarker(96, n);
        this._writeBytes(byArray, 0, n);
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException {
        this._verifyValueWrite("write String value");
        if (n2 == 0) {
            this._writeByte((byte)96);
            return;
        }
        this._writeString(cArray, n, n2);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this._verifyValueWrite("write String value");
        if (n2 == 0) {
            this._writeByte((byte)96);
            return;
        }
        this._writeLengthMarker(96, n2);
        this._writeBytes(byArray, 0, n2);
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n, int n2) throws IOException {
        this.writeRawUTF8String(byArray, n, n2);
    }

    @Override
    public void writeRaw(String string) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char c) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string, int n, int n2) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        this._writeLengthMarker(64, n2);
        this._writeBytes(byArray, n, n2);
    }

    @Override
    public int writeBinary(InputStream inputStream2, int n) throws IOException {
        if (n < 0) {
            throw new UnsupportedOperationException("Must pass actual length for CBOR encoded data");
        }
        this._verifyValueWrite("write Binary value");
        this._writeLengthMarker(64, n);
        int n2 = this._writeBytes(inputStream2, n);
        if (n2 > 0) {
            this._reportError("Too few bytes available: missing " + n2 + " bytes (out of " + n + ")");
        }
        return n;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream2, int n) throws IOException {
        return this.writeBinary(inputStream2, n);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (bl) {
            this._writeByte((byte)-11);
        } else {
            this._writeByte((byte)-12);
        }
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)-10);
    }

    @Override
    public void writeNumber(int n) throws IOException {
        byte by;
        int n2;
        this._verifyValueWrite("write number");
        if (n < 0) {
            n = -n - 1;
            n2 = 32;
        } else {
            n2 = 0;
        }
        this._ensureRoomForOutput(5);
        if (this._cfgMinimalInts) {
            if (n < 24) {
                this._outputBuffer[this._outputTail++] = (byte)(n2 + n);
                return;
            }
            if (n <= 255) {
                this._outputBuffer[this._outputTail++] = (byte)(n2 + 24);
                this._outputBuffer[this._outputTail++] = (byte)n;
                return;
            }
            by = (byte)n;
            if ((n >>= 8) <= 255) {
                this._outputBuffer[this._outputTail++] = (byte)(n2 + 25);
                this._outputBuffer[this._outputTail++] = (byte)n;
                this._outputBuffer[this._outputTail++] = by;
                return;
            }
        } else {
            by = (byte)n;
            n >>= 8;
        }
        this._outputBuffer[this._outputTail++] = (byte)(n2 + 26);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
        this._outputBuffer[this._outputTail++] = by;
    }

    @Override
    public void writeNumber(long l) throws IOException {
        this._verifyValueWrite("write number");
        if (this._cfgMinimalInts) {
            if (l >= 0L) {
                if (l < 0x100000000L) {
                    this._writeIntMinimal(0, (int)l);
                    return;
                }
            } else if (l >= -4294967296L) {
                this._writeIntMinimal(32, (int)(-l - 1L));
                return;
            }
        }
        this._ensureRoomForOutput(9);
        if (l < 0L) {
            ++l;
            l = -l;
            this._outputBuffer[this._outputTail++] = 59;
        } else {
            this._outputBuffer[this._outputTail++] = 27;
        }
        int n = (int)(l >> 32);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
        n = (int)l;
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._write(bigInteger);
    }

    protected void _write(BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() < 0) {
            this._writeByte((byte)-61);
            bigInteger = bigInteger.negate();
        } else {
            this._writeByte((byte)-62);
        }
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length;
        this._writeLengthMarker(64, n);
        this._writeBytes(byArray, 0, n);
    }

    @Override
    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite("write number");
        this._ensureRoomForOutput(11);
        long l = Double.doubleToRawLongBits(d);
        this._outputBuffer[this._outputTail++] = -5;
        int n = (int)(l >> 32);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
        n = (int)l;
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
    }

    @Override
    public void writeNumber(float f) throws IOException {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int n = Float.floatToRawIntBits(f);
        this._outputBuffer[this._outputTail++] = -6;
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)-60);
        this._writeByte((byte)-126);
        int n = bigDecimal.scale();
        this._writeIntValue(-n);
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n2 = bigInteger.bitLength();
        if (n2 <= 31) {
            this._writeIntValue(bigInteger.intValue());
        } else if (n2 <= 63) {
            this._writeLongValue(bigInteger.longValue());
        } else {
            this._write(bigInteger);
        }
    }

    @Override
    public void writeNumber(String string) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(string);
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException {
        int n;
        if (!this._cborContext.writeValue()) {
            this._reportError("Can not " + string + ", expecting field name/id");
        }
        if ((n = this._currentRemainingElements) != -2) {
            if (--n < 0) {
                this._failSizedArrayOrObject();
                return;
            }
            this._currentRemainingElements = n;
        }
    }

    private void _failSizedArrayOrObject() throws IOException {
        this._reportError(String.format("%s size mismatch: number of element encoded is not equal to reported array/map size.", this._cborContext.typeDesc()));
    }

    @Override
    public final void flush() throws IOException {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext jsonStreamContext;
                if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonStreamContext.inObject()) break;
                this.writeEndObject();
            }
        }
        super.close();
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    public void writeTag(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can not write negative tag ids (" + n + ")");
        }
        this._writeLengthMarker(192, n);
    }

    public void writeRaw(byte by) throws IOException {
        this._writeByte(by);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this._writeBytes(byArray, n, n2);
    }

    protected final void _writeString(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            this._writeByte((byte)96);
            return;
        }
        if (n <= 23) {
            this._ensureSpace(71);
            int n2 = this._encode(this._outputTail + 1, string, n);
            byte[] byArray = this._outputBuffer;
            int n3 = this._outputTail;
            if (n2 <= 23) {
                byArray[n3++] = (byte)(96 + n2);
                this._outputTail = n3 + n2;
                return;
            }
            System.arraycopy(byArray, n3 + 1, byArray, n3 + 2, n2);
            byArray[n3++] = 120;
            byArray[n3++] = (byte)n2;
            this._outputTail = n3 + n2;
            return;
        }
        char[] cArray = this._charBuffer;
        if (n > cArray.length) {
            this._charBuffer = cArray = new char[Math.max(this._charBuffer.length + 32, n)];
        }
        string.getChars(0, n, cArray, 0);
        this._writeString(cArray, 0, n);
    }

    protected final void _ensureSpace(int n) throws IOException {
        if (this._outputTail + n + 3 > this._outputEnd) {
            this._flushBuffer();
        }
    }

    protected final void _writeString(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= 23) {
            this._ensureSpace(71);
            int n3 = this._encode(this._outputTail + 1, cArray, n, n + n2);
            byte[] byArray = this._outputBuffer;
            int n4 = this._outputTail;
            if (n3 <= 23) {
                byArray[n4++] = (byte)(96 + n3);
                this._outputTail = n4 + n3;
                return;
            }
            System.arraycopy(byArray, n4 + 1, byArray, n4 + 2, n3);
            byArray[n4++] = 120;
            byArray[n4++] = (byte)n3;
            this._outputTail = n4 + n3;
            return;
        }
        if (n2 <= 255) {
            this._ensureSpace(768);
            int n5 = this._encode(this._outputTail + 2, cArray, n, n + n2);
            byte[] byArray = this._outputBuffer;
            int n6 = this._outputTail;
            if (n5 <= 255) {
                byArray[n6++] = 120;
                byArray[n6++] = (byte)n5;
                this._outputTail = n6 + n5;
                return;
            }
            System.arraycopy(byArray, n6 + 2, byArray, n6 + 3, n5);
            byArray[n6++] = 121;
            byArray[n6++] = (byte)(n5 >> 8);
            byArray[n6++] = (byte)n5;
            this._outputTail = n6 + n5;
            return;
        }
        if (n2 <= 3996) {
            this._ensureSpace(11991);
            int n7 = this._outputTail;
            int n8 = this._encode(n7 + 3, cArray, n, n + n2);
            byte[] byArray = this._outputBuffer;
            byArray[n7++] = 121;
            byArray[n7++] = (byte)(n8 >> 8);
            byArray[n7++] = (byte)n8;
            this._outputTail = n7 + n8;
            return;
        }
        this._writeChunkedString(cArray, n, n2);
    }

    protected final void _writeChunkedString(char[] cArray, int n, int n2) throws IOException {
        this._writeByte((byte)127);
        while (n2 > 3996) {
            this._ensureSpace(11991);
            int n3 = this._outputTail;
            int n4 = 3996;
            int n5 = n + n4;
            char c = cArray[n5 - 1];
            if (c >= '\ud800' && c <= '\udbff') {
                --n5;
                --n4;
            }
            int n6 = this._encode(this._outputTail + 3, cArray, n, n5);
            byte[] byArray = this._outputBuffer;
            byArray[n3++] = 121;
            byArray[n3++] = (byte)(n6 >> 8);
            byArray[n3++] = (byte)n6;
            this._outputTail = n3 + n6;
            n += n4;
            n2 -= n4;
        }
        if (n2 > 0) {
            this._writeString(cArray, n, n2);
        }
        this._writeByte((byte)-1);
    }

    private final int _encode(int n, char[] cArray, int n2, int n3) {
        byte[] byArray = this._outputBuffer;
        int n4 = n;
        do {
            char c;
            if ((c = cArray[n2]) > '\u007f') {
                return this._shortUTF8Encode2(cArray, n2, n3, n, n4);
            }
            byArray[n++] = (byte)c;
        } while (++n2 < n3);
        return n - n4;
    }

    private final int _shortUTF8Encode2(char[] cArray, int n, int n2, int n3, int n4) {
        byte[] byArray = this._outputBuffer;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c <= '\udbff' && n < n2) {
                char c2 = cArray[n];
                if (c2 <= '\udfff' && c2 >= '\udc00') {
                    ++n;
                    n3 = this._decodeAndWriteSurrogate(c, c2, byArray, n3);
                    continue;
                }
                n3 = this._invalidSurrogateEnd(c, c2, byArray, n3);
                continue;
            }
            n3 = this._invalidSurrogateStart(c, byArray, n3);
        }
        return n3 - n4;
    }

    private final int _encode(int n, String string, int n2) {
        byte[] byArray = this._outputBuffer;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                return this._encode2(i, n, string, n2, n3);
            }
            byArray[n++] = (byte)c;
        }
        return n - n3;
    }

    private final int _encode2(int n, int n2, String string, int n3, int n4) {
        byte[] byArray = this._outputBuffer;
        while (n < n3) {
            char c;
            if ((c = string.charAt(n++)) <= '\u007f') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n2++] = (byte)(0xC0 | c >> 6);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                byArray[n2++] = (byte)(0xE0 | c >> 12);
                byArray[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c <= '\udbff' && n < n3) {
                char c2 = string.charAt(n);
                if (c2 <= '\udfff' && c2 >= '\udc00') {
                    ++n;
                    n2 = this._decodeAndWriteSurrogate(c, c2, byArray, n2);
                    continue;
                }
                n2 = this._invalidSurrogateEnd(c, c2, byArray, n2);
                continue;
            }
            n2 = this._invalidSurrogateStart(c, byArray, n2);
        }
        return n2 - n4;
    }

    private int _invalidSurrogateStart(int n, byte[] byArray, int n2) {
        if (this.isEnabled(Feature.LENIENT_UTF_ENCODING)) {
            return this._appendReplacementChar(byArray, n2);
        }
        if (n <= 56319) {
            throw new IllegalArgumentException(String.format("Unmatched surrogate pair, starts with valid high surrogate (0x%04X) but ends without low surrogate", n));
        }
        throw new IllegalArgumentException(String.format("Invalid surrogate pair, starts with invalid high surrogate (0x%04X), not in valid range [0xD800, 0xDBFF]", n));
    }

    private int _invalidSurrogateEnd(int n, int n2, byte[] byArray, int n3) {
        if (this.isEnabled(Feature.LENIENT_UTF_ENCODING)) {
            return this._appendReplacementChar(byArray, n3);
        }
        throw new IllegalArgumentException(String.format("Invalid surrogate pair, starts with valid high surrogate (0x%04X) but ends with invalid low surrogate (0x%04X), not in valid range [0xDC00, 0xDFFF]", n, n2));
    }

    private int _appendReplacementChar(byte[] byArray, int n) {
        byArray[n++] = -17;
        byArray[n++] = -65;
        byArray[n++] = -67;
        return n;
    }

    private int _decodeAndWriteSurrogate(int n, int n2, byte[] byArray, int n3) {
        int n4 = 65536 + (n - 55296 << 10) + (n2 - 56320);
        byArray[n3++] = (byte)(0xF0 | n4 >> 18);
        byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
        byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
        byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
        return n3;
    }

    private final void _ensureRoomForOutput(int n) throws IOException {
        if (this._outputTail + n >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeIntValue(int n) throws IOException {
        int n2;
        if (n < 0) {
            n = -n - 1;
            n2 = 32;
        } else {
            n2 = 0;
        }
        this._writeLengthMarker(n2, n);
    }

    private final void _writeLongValue(long l) throws IOException {
        this._ensureRoomForOutput(9);
        if (l < 0L) {
            ++l;
            l = -l;
            this._outputBuffer[this._outputTail++] = 59;
        } else {
            this._outputBuffer[this._outputTail++] = 27;
        }
        int n = (int)(l >> 32);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
        n = (int)l;
        this._outputBuffer[this._outputTail++] = (byte)(n >> 24);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n;
    }

    private final void _writeLengthMarker(int n, int n2) throws IOException {
        this._ensureRoomForOutput(5);
        if (n2 < 24) {
            this._outputBuffer[this._outputTail++] = (byte)(n + n2);
            return;
        }
        if (n2 <= 255) {
            this._outputBuffer[this._outputTail++] = (byte)(n + 24);
            this._outputBuffer[this._outputTail++] = (byte)n2;
            return;
        }
        byte by = (byte)n2;
        if ((n2 >>= 8) <= 255) {
            this._outputBuffer[this._outputTail++] = (byte)(n + 25);
            this._outputBuffer[this._outputTail++] = (byte)n2;
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        this._outputBuffer[this._outputTail++] = (byte)(n + 26);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 16);
        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 8);
        this._outputBuffer[this._outputTail++] = (byte)n2;
        this._outputBuffer[this._outputTail++] = by;
    }

    private final void _writeByte(byte by) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
    }

    private final void _writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._writeBytesLong(byArray, n, n2);
            return;
        }
        System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final int _writeBytes(InputStream inputStream2, int n) throws IOException {
        while (n > 0) {
            int n2;
            int n3 = this._outputEnd - this._outputTail;
            if (n3 <= 0) {
                this._flushBuffer();
                n3 = this._outputEnd - this._outputTail;
            }
            if ((n2 = inputStream2.read(this._outputBuffer, this._outputTail, n3)) < 0) break;
            this._outputTail += n2;
            n -= n2;
        }
        return n;
    }

    private final void _writeBytesLong(byte[] byArray, int n, int n2) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int n3 = Math.min(n2, this._outputEnd - this._outputTail);
            System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            if ((n2 -= n3) == 0) break;
            n += n3;
            this._flushBuffer();
        }
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray;
        byte[] byArray = this._outputBuffer;
        if (byArray != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(byArray);
        }
        if ((cArray = this._charBuffer) != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final void closeComplexElement() throws IOException {
        switch (this._currentRemainingElements) {
            case -2: {
                this._writeByte((byte)-1);
                break;
            }
            case 0: {
                break;
            }
            default: {
                this._reportError(String.format("%s size mismatch: expected %d more elements", this._cborContext.typeDesc(), this._currentRemainingElements));
            }
        }
        this._currentRemainingElements = this._elementCountsPtr == 0 ? -2 : this._elementCounts[--this._elementCountsPtr];
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }

    public static enum Feature implements FormatFeature
    {
        WRITE_MINIMAL_INTS(true),
        WRITE_TYPE_HEADER(false),
        LENIENT_UTF_ENCODING(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int n) {
            return (n & this.getMask()) != 0;
        }

        @Override
        public int getMask() {
            return this._mask;
        }
    }
}

