/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.cbor;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.cbor.CBORFactoryBuilder;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.fasterxml.jackson.dataformat.cbor.CBORParserBootstrapper;
import com.fasterxml.jackson.dataformat.cbor.PackageVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class CBORFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME = "CBOR";
    static final int DEFAULT_CBOR_PARSER_FEATURE_FLAGS = CBORParser.Feature.collectDefaults();
    static final int DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS = CBORGenerator.Feature.collectDefaults();
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;

    public CBORFactory() {
        this((ObjectCodec)null);
    }

    public CBORFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._formatParserFeatures = DEFAULT_CBOR_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = DEFAULT_CBOR_GENERATOR_FEATURE_FLAGS;
    }

    public CBORFactory(CBORFactory cBORFactory, ObjectCodec objectCodec) {
        super(cBORFactory, objectCodec);
        this._formatParserFeatures = cBORFactory._formatParserFeatures;
        this._formatGeneratorFeatures = cBORFactory._formatGeneratorFeatures;
    }

    protected CBORFactory(CBORFactoryBuilder cBORFactoryBuilder) {
        super(cBORFactoryBuilder, false);
        this._formatParserFeatures = cBORFactoryBuilder.formatParserFeaturesMask();
        this._formatGeneratorFeatures = cBORFactoryBuilder.formatGeneratorFeaturesMask();
    }

    public CBORFactoryBuilder rebuild() {
        return new CBORFactoryBuilder(this);
    }

    public static CBORFactoryBuilder builder() {
        return new CBORFactoryBuilder();
    }

    @Override
    public CBORFactory copy() {
        this._checkInvalidCopy(CBORFactory.class);
        return new CBORFactory(this, null);
    }

    @Override
    protected Object readResolve() {
        return new CBORFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        return CBORParserBootstrapper.hasCBORFormat(inputAccessor);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    public Class<CBORParser.Feature> getFormatReadFeatureType() {
        return CBORParser.Feature.class;
    }

    public Class<CBORGenerator.Feature> getFormatWriteFeatureType() {
        return CBORGenerator.Feature.class;
    }

    public final CBORFactory configure(CBORParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public CBORFactory enable(CBORParser.Feature feature) {
        this._formatParserFeatures |= feature.getMask();
        return this;
    }

    public CBORFactory disable(CBORParser.Feature feature) {
        this._formatParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(CBORParser.Feature feature) {
        return (this._formatParserFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFormatParserFeatures() {
        return this._formatParserFeatures;
    }

    public final CBORFactory configure(CBORGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public CBORFactory enable(CBORGenerator.Feature feature) {
        this._formatGeneratorFeatures |= feature.getMask();
        return this;
    }

    public CBORFactory disable(CBORGenerator.Feature feature) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(CBORGenerator.Feature feature) {
        return (this._formatGeneratorFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return this._formatGeneratorFeatures;
    }

    @Override
    public CBORParser createParser(File file) throws IOException {
        IOContext iOContext = this._createContext(file, true);
        return this._createParser(this._decorate(new FileInputStream(file), iOContext), iOContext);
    }

    @Override
    public CBORParser createParser(URL uRL) throws IOException {
        IOContext iOContext = this._createContext(uRL, true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(uRL), iOContext), iOContext);
    }

    @Override
    public CBORParser createParser(InputStream inputStream2) throws IOException {
        IOContext iOContext = this._createContext(inputStream2, false);
        return this._createParser(this._decorate(inputStream2, iOContext), iOContext);
    }

    @Override
    public CBORParser createParser(byte[] byArray) throws IOException {
        return this.createParser(byArray, 0, byArray.length);
    }

    @Override
    public CBORParser createParser(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream2;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream2 = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream2, iOContext);
        }
        return this._createParser(byArray, n, n2, iOContext);
    }

    @Override
    public CBORGenerator createGenerator(OutputStream outputStream2, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream2, false);
        return this._createCBORGenerator(iOContext, this._generatorFeatures, this._formatGeneratorFeatures, this._objectCodec, this._decorate(outputStream2, iOContext));
    }

    @Override
    public CBORGenerator createGenerator(OutputStream outputStream2) throws IOException {
        IOContext iOContext = this._createContext(outputStream2, false);
        return this._createCBORGenerator(iOContext, this._generatorFeatures, this._formatGeneratorFeatures, this._objectCodec, this._decorate(outputStream2, iOContext));
    }

    @Override
    protected IOContext _createContext(Object object, boolean bl) {
        return super._createContext(object, bl);
    }

    @Override
    protected CBORParser _createParser(InputStream inputStream2, IOContext iOContext) throws IOException {
        return new CBORParserBootstrapper(iOContext, inputStream2).constructParser(this._factoryFeatures, this._parserFeatures, this._formatParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected JsonParser _createParser(char[] cArray, int n, int n2, IOContext iOContext, boolean bl) throws IOException {
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected CBORParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException {
        return new CBORParserBootstrapper(iOContext, byArray, n, n2).constructParser(this._factoryFeatures, this._parserFeatures, this._formatParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected CBORGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        return (CBORGenerator)this._nonByteTarget();
    }

    @Override
    protected CBORGenerator _createUTF8Generator(OutputStream outputStream2, IOContext iOContext) throws IOException {
        return this._createCBORGenerator(iOContext, this._generatorFeatures, this._formatGeneratorFeatures, this._objectCodec, outputStream2);
    }

    @Override
    protected Writer _createWriter(OutputStream outputStream2, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        return (Writer)this._nonByteTarget();
    }

    private final CBORGenerator _createCBORGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream2) throws IOException {
        CBORGenerator cBORGenerator = new CBORGenerator(iOContext, n, n2, this._objectCodec, outputStream2);
        if (CBORGenerator.Feature.WRITE_TYPE_HEADER.enabledIn(n2)) {
            cBORGenerator.writeTag(55799);
        }
        return cBORGenerator;
    }

    protected <T> T _nonByteSource() {
        throw new UnsupportedOperationException("Can not create parser for non-byte-based source");
    }

    protected <T> T _nonByteTarget() {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }
}

