/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.LookupCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public class LRUMap<K, V>
implements LookupCache<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient int _maxEntries;
    protected final transient ConcurrentHashMap<K, V> _map;
    protected transient int _jdkSerializeMaxEntries;

    public LRUMap(int n, int n2) {
        this._map = new ConcurrentHashMap(n, 0.8f, 4);
        this._maxEntries = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        if (this._map.size() >= this._maxEntries) {
            LRUMap lRUMap = this;
            synchronized (lRUMap) {
                if (this._map.size() >= this._maxEntries) {
                    this.clear();
                }
            }
        }
        return this._map.put(k, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        if (this._map.size() >= this._maxEntries) {
            LRUMap lRUMap = this;
            synchronized (lRUMap) {
                if (this._map.size() >= this._maxEntries) {
                    this.clear();
                }
            }
        }
        return this._map.putIfAbsent(k, v);
    }

    @Override
    public V get(Object object) {
        return this._map.get(object);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this._jdkSerializeMaxEntries = objectInputStream.readInt();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._jdkSerializeMaxEntries);
    }

    protected Object readResolve() {
        return new LRUMap<K, V>(this._jdkSerializeMaxEntries, this._jdkSerializeMaxEntries);
    }
}

