/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.ClassStack;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.PlaceholderForType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.type.TypeParser;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class TypeFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected static final TypeFactory instance = new TypeFactory();
    protected static final TypeBindings EMPTY_BINDINGS = TypeBindings.emptyBindings();
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_COMPARABLE = Comparable.class;
    private static final Class<?> CLS_CLASS = Class.class;
    private static final Class<?> CLS_ENUM = Enum.class;
    private static final Class<?> CLS_JSON_NODE = JsonNode.class;
    private static final Class<?> CLS_BOOL = Boolean.TYPE;
    private static final Class<?> CLS_INT = Integer.TYPE;
    private static final Class<?> CLS_LONG = Long.TYPE;
    protected static final SimpleType CORE_TYPE_BOOL = new SimpleType(CLS_BOOL);
    protected static final SimpleType CORE_TYPE_INT = new SimpleType(CLS_INT);
    protected static final SimpleType CORE_TYPE_LONG = new SimpleType(CLS_LONG);
    protected static final SimpleType CORE_TYPE_STRING = new SimpleType(CLS_STRING);
    protected static final SimpleType CORE_TYPE_OBJECT = new SimpleType(CLS_OBJECT);
    protected static final SimpleType CORE_TYPE_COMPARABLE = new SimpleType(CLS_COMPARABLE);
    protected static final SimpleType CORE_TYPE_ENUM = new SimpleType(CLS_ENUM);
    protected static final SimpleType CORE_TYPE_CLASS = new SimpleType(CLS_CLASS);
    protected static final SimpleType CORE_TYPE_JSON_NODE = new SimpleType(CLS_JSON_NODE);
    protected final LookupCache<Object, JavaType> _typeCache;
    protected final TypeModifier[] _modifiers;
    protected final TypeParser _parser;
    protected final ClassLoader _classLoader;

    private TypeFactory() {
        this((LookupCache<Object, JavaType>)null);
    }

    @Deprecated
    protected TypeFactory(LRUMap<Object, JavaType> lRUMap) {
        this((LookupCache<Object, JavaType>)lRUMap);
    }

    protected TypeFactory(LookupCache<Object, JavaType> lookupCache) {
        if (lookupCache == null) {
            lookupCache = new LRUMap<Object, JavaType>(16, 200);
        }
        this._typeCache = lookupCache;
        this._parser = new TypeParser(this);
        this._modifiers = null;
        this._classLoader = null;
    }

    @Deprecated
    protected TypeFactory(LRUMap<Object, JavaType> lRUMap, TypeParser typeParser, TypeModifier[] typeModifierArray, ClassLoader classLoader) {
        this((LookupCache<Object, JavaType>)lRUMap, typeParser, typeModifierArray, classLoader);
    }

    protected TypeFactory(LookupCache<Object, JavaType> lookupCache, TypeParser typeParser, TypeModifier[] typeModifierArray, ClassLoader classLoader) {
        if (lookupCache == null) {
            lookupCache = new LRUMap<Object, JavaType>(16, 200);
        }
        this._typeCache = lookupCache;
        this._parser = typeParser.withFactory(this);
        this._modifiers = typeModifierArray;
        this._classLoader = classLoader;
    }

    public TypeFactory withModifier(TypeModifier typeModifier) {
        TypeModifier[] typeModifierArray;
        LookupCache<Object, JavaType> lookupCache = this._typeCache;
        if (typeModifier == null) {
            typeModifierArray = null;
            lookupCache = null;
        } else if (this._modifiers == null) {
            typeModifierArray = new TypeModifier[]{typeModifier};
            lookupCache = null;
        } else {
            typeModifierArray = ArrayBuilders.insertInListNoDup(this._modifiers, typeModifier);
        }
        return new TypeFactory(lookupCache, this._parser, typeModifierArray, this._classLoader);
    }

    public TypeFactory withClassLoader(ClassLoader classLoader) {
        return new TypeFactory(this._typeCache, this._parser, this._modifiers, classLoader);
    }

    @Deprecated
    public TypeFactory withCache(LRUMap<Object, JavaType> lRUMap) {
        return new TypeFactory(lRUMap, this._parser, this._modifiers, this._classLoader);
    }

    public TypeFactory withCache(LookupCache<Object, JavaType> lookupCache) {
        return new TypeFactory(lookupCache, this._parser, this._modifiers, this._classLoader);
    }

    public static TypeFactory defaultInstance() {
        return instance;
    }

    public void clearCache() {
        this._typeCache.clear();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public static JavaType unknownType() {
        return TypeFactory.defaultInstance()._unknownType();
    }

    public static Class<?> rawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return TypeFactory.defaultInstance().constructType(type).getRawClass();
    }

    public Class<?> findClass(String string) throws ClassNotFoundException {
        Serializable serializable;
        if (string.indexOf(46) < 0 && (serializable = this._findPrimitive(string)) != null) {
            return serializable;
        }
        serializable = null;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader != null) {
            try {
                return this.classForName(string, true, classLoader);
            }
            catch (Exception exception) {
                serializable = ClassUtil.getRootCause(exception);
            }
        }
        try {
            return this.classForName(string);
        }
        catch (Exception exception) {
            if (serializable == null) {
                serializable = ClassUtil.getRootCause(exception);
            }
            ClassUtil.throwIfRTE(serializable);
            throw new ClassNotFoundException(((Throwable)serializable).getMessage(), (Throwable)serializable);
        }
    }

    protected Class<?> classForName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string, true, classLoader);
    }

    protected Class<?> classForName(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    protected Class<?> _findPrimitive(String string) {
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("void".equals(string)) {
            return Void.TYPE;
        }
        return null;
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) throws IllegalArgumentException {
        return this.constructSpecializedType(javaType, clazz, false);
    }

    /*
     * Unable to fully structure code
     */
    public JavaType constructSpecializedType(JavaType var1_1, Class<?> var2_2, boolean var3_3) throws IllegalArgumentException {
        block10: {
            block11: {
                block9: {
                    var4_4 = var1_1.getRawClass();
                    if (var4_4 == var2_2) {
                        return var1_1;
                    }
                    if (var4_4 != Object.class) break block9;
                    var5_5 = this._fromClass(null, var2_2, TypeFactory.EMPTY_BINDINGS);
                    break block10;
                }
                if (!var4_4.isAssignableFrom(var2_2)) {
                    throw new IllegalArgumentException(String.format("Class %s not subtype of %s", new Object[]{ClassUtil.nameOf(var2_2), ClassUtil.getTypeDescription(var1_1)}));
                }
                if (!var1_1.isContainerType()) ** GOTO lbl22
                if (!var1_1.isMapLikeType()) break block11;
                if (var2_2 != HashMap.class && var2_2 != LinkedHashMap.class && var2_2 != EnumMap.class && var2_2 != TreeMap.class) ** GOTO lbl22
                var5_5 = this._fromClass(null, var2_2, TypeBindings.create(var2_2, var1_1.getKeyType(), var1_1.getContentType()));
                break block10;
            }
            if (!var1_1.isCollectionLikeType()) ** GOTO lbl22
            if (var2_2 == ArrayList.class || var2_2 == LinkedList.class || var2_2 == HashSet.class || var2_2 == TreeSet.class) {
                var5_5 = this._fromClass(null, var2_2, TypeBindings.create(var2_2, var1_1.getContentType()));
            } else {
                if (var4_4 == EnumSet.class) {
                    return var1_1;
                }
lbl22:
                // 5 sources

                if (var1_1.getBindings().isEmpty()) {
                    var5_5 = this._fromClass(null, var2_2, TypeFactory.EMPTY_BINDINGS);
                } else {
                    var6_6 = var2_2.getTypeParameters().length;
                    if (var6_6 == 0) {
                        var5_5 = this._fromClass(null, var2_2, TypeFactory.EMPTY_BINDINGS);
                    } else {
                        var7_7 = this._bindingsForSubtype(var1_1, var6_6, var2_2, var3_3);
                        var5_5 = this._fromClass(null, var2_2, var7_7);
                    }
                }
            }
        }
        var5_5 = var5_5.withHandlersFrom(var1_1);
        return var5_5;
    }

    private TypeBindings _bindingsForSubtype(JavaType javaType, int n, Class<?> clazz, boolean bl) {
        JavaType[] javaTypeArray = new PlaceholderForType[n];
        for (int i = 0; i < n; ++i) {
            javaTypeArray[i] = new PlaceholderForType(i);
        }
        TypeBindings typeBindings = TypeBindings.create(clazz, javaTypeArray);
        JavaType javaType2 = this._fromClass(null, clazz, typeBindings);
        JavaType javaType3 = javaType2.findSuperType(javaType.getRawClass());
        if (javaType3 == null) {
            throw new IllegalArgumentException(String.format("Internal error: unable to locate supertype (%s) from resolved subtype %s", javaType.getRawClass().getName(), clazz.getName()));
        }
        String string = this._resolveTypePlaceholders(javaType, javaType3);
        if (string != null && !bl) {
            throw new IllegalArgumentException("Failed to specialize base type " + javaType.toCanonical() + " as " + clazz.getName() + ", problem: " + string);
        }
        JavaType[] javaTypeArray2 = new JavaType[n];
        for (int i = 0; i < n; ++i) {
            JavaType javaType4 = ((PlaceholderForType)javaTypeArray[i]).actualType();
            if (javaType4 == null) {
                javaType4 = TypeFactory.unknownType();
            }
            javaTypeArray2[i] = javaType4;
        }
        return TypeBindings.create(clazz, javaTypeArray2);
    }

    private String _resolveTypePlaceholders(JavaType javaType, JavaType javaType2) throws IllegalArgumentException {
        List<JavaType> list = javaType.getBindings().getTypeParameters();
        List<JavaType> list2 = javaType2.getBindings().getTypeParameters();
        int n = list2.size();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JavaType javaType3;
            JavaType javaType4 = list.get(i);
            JavaType javaType5 = javaType3 = i < n ? list2.get(i) : TypeFactory.unknownType();
            if (this._verifyAndResolvePlaceholders(javaType4, javaType3) || javaType4.hasRawClass(Object.class) || i == 0 && javaType.isMapLikeType() && javaType3.hasRawClass(Object.class) || javaType4.isInterface() && javaType4.isTypeOrSuperTypeOf(javaType3.getRawClass())) continue;
            return String.format("Type parameter #%d/%d differs; can not specialize %s with %s", i + 1, n2, javaType4.toCanonical(), javaType3.toCanonical());
        }
        return null;
    }

    private boolean _verifyAndResolvePlaceholders(JavaType javaType, JavaType javaType2) {
        if (javaType2 instanceof PlaceholderForType) {
            ((PlaceholderForType)javaType2).actualType(javaType);
            return true;
        }
        if (javaType.getRawClass() != javaType2.getRawClass()) {
            return false;
        }
        List<JavaType> list = javaType.getBindings().getTypeParameters();
        List<JavaType> list2 = javaType2.getBindings().getTypeParameters();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JavaType javaType3;
            JavaType javaType4 = list.get(i);
            if (this._verifyAndResolvePlaceholders(javaType4, javaType3 = list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public JavaType constructGeneralizedType(JavaType javaType, Class<?> clazz) {
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 == clazz) {
            return javaType;
        }
        JavaType javaType2 = javaType.findSuperType(clazz);
        if (javaType2 == null) {
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException(String.format("Class %s not a super-type of %s", clazz.getName(), javaType));
            }
            throw new IllegalArgumentException(String.format("Internal error: class %s not included as super-type for %s", clazz.getName(), javaType));
        }
        return javaType2;
    }

    public JavaType constructFromCanonical(String string) throws IllegalArgumentException {
        return this._parser.parse(string);
    }

    public JavaType[] findTypeParameters(JavaType javaType, Class<?> clazz) {
        JavaType javaType2 = javaType.findSuperType(clazz);
        if (javaType2 == null) {
            return NO_TYPES;
        }
        return javaType2.getBindings().typeParameterArray();
    }

    @Deprecated
    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2, TypeBindings typeBindings) {
        return this.findTypeParameters(this.constructType(clazz, typeBindings), clazz2);
    }

    @Deprecated
    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2) {
        return this.findTypeParameters(this.constructType(clazz), clazz2);
    }

    public JavaType moreSpecificType(JavaType javaType, JavaType javaType2) {
        Class<?> clazz;
        if (javaType == null) {
            return javaType2;
        }
        if (javaType2 == null) {
            return javaType;
        }
        Class<?> clazz2 = javaType.getRawClass();
        if (clazz2 == (clazz = javaType2.getRawClass())) {
            return javaType;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return javaType2;
        }
        return javaType;
    }

    public JavaType constructType(Type type) {
        return this._fromAny(null, type, EMPTY_BINDINGS);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        return this._fromAny(null, typeReference.getType(), EMPTY_BINDINGS);
    }

    public JavaType resolveMemberType(Type type, TypeBindings typeBindings) {
        return this._fromAny(null, type, typeBindings);
    }

    @Deprecated
    public JavaType constructType(Type type, TypeBindings typeBindings) {
        if (type instanceof Class) {
            JavaType javaType = this._fromClass(null, (Class)type, typeBindings);
            return this._applyModifiers(type, javaType);
        }
        return this._fromAny(null, type, typeBindings);
    }

    @Deprecated
    public JavaType constructType(Type type, Class<?> clazz) {
        JavaType javaType = clazz == null ? null : this.constructType(clazz);
        return this.constructType(type, javaType);
    }

    @Deprecated
    public JavaType constructType(Type type, JavaType javaType) {
        TypeBindings typeBindings;
        if (javaType == null) {
            typeBindings = EMPTY_BINDINGS;
        } else {
            typeBindings = javaType.getBindings();
            if (type.getClass() != Class.class) {
                while (typeBindings.isEmpty() && (javaType = javaType.getSuperClass()) != null) {
                    typeBindings = javaType.getBindings();
                }
            }
        }
        return this._fromAny(null, type, typeBindings);
    }

    public ArrayType constructArrayType(Class<?> clazz) {
        return ArrayType.construct(this._fromAny(null, clazz, null), null);
    }

    public ArrayType constructArrayType(JavaType javaType) {
        return ArrayType.construct(javaType, null);
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, Class<?> clazz2) {
        return this.constructCollectionType(clazz, this._fromClass(null, clazz2, EMPTY_BINDINGS));
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, JavaType javaType) {
        JavaType javaType2;
        JavaType javaType3;
        TypeBindings typeBindings = TypeBindings.createIfNeeded(clazz, javaType);
        CollectionType collectionType = (CollectionType)this._fromClass(null, clazz, typeBindings);
        if (typeBindings.isEmpty() && javaType != null && !(javaType3 = (javaType2 = collectionType.findSuperType(Collection.class)).getContentType()).equals(javaType)) {
            throw new IllegalArgumentException(String.format("Non-generic Collection class %s did not resolve to something with element type %s but %s ", ClassUtil.nameOf(clazz), javaType, javaType3));
        }
        return collectionType;
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, Class<?> clazz2) {
        return this.constructCollectionLikeType(clazz, this._fromClass(null, clazz2, EMPTY_BINDINGS));
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, JavaType javaType) {
        JavaType javaType2 = this._fromClass(null, clazz, TypeBindings.createIfNeeded(clazz, javaType));
        if (javaType2 instanceof CollectionLikeType) {
            return (CollectionLikeType)javaType2;
        }
        return CollectionLikeType.upgradeFrom(javaType2, javaType);
    }

    public MapType constructMapType(Class<? extends Map> clazz, Class<?> clazz2, Class<?> clazz3) {
        JavaType javaType;
        JavaType javaType2;
        if (clazz == Properties.class) {
            javaType = javaType2 = CORE_TYPE_STRING;
        } else {
            javaType = this._fromClass(null, clazz2, EMPTY_BINDINGS);
            javaType2 = this._fromClass(null, clazz3, EMPTY_BINDINGS);
        }
        return this.constructMapType(clazz, javaType, javaType2);
    }

    public MapType constructMapType(Class<? extends Map> clazz, JavaType javaType, JavaType javaType2) {
        TypeBindings typeBindings = TypeBindings.createIfNeeded(clazz, new JavaType[]{javaType, javaType2});
        MapType mapType = (MapType)this._fromClass(null, clazz, typeBindings);
        if (typeBindings.isEmpty()) {
            JavaType javaType3 = mapType.findSuperType(Map.class);
            JavaType javaType4 = javaType3.getKeyType();
            if (!javaType4.equals(javaType)) {
                throw new IllegalArgumentException(String.format("Non-generic Map class %s did not resolve to something with key type %s but %s ", ClassUtil.nameOf(clazz), javaType, javaType4));
            }
            JavaType javaType5 = javaType3.getContentType();
            if (!javaType5.equals(javaType2)) {
                throw new IllegalArgumentException(String.format("Non-generic Map class %s did not resolve to something with value type %s but %s ", ClassUtil.nameOf(clazz), javaType2, javaType5));
            }
        }
        return mapType;
    }

    public MapLikeType constructMapLikeType(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        return this.constructMapLikeType(clazz, this._fromClass(null, clazz2, EMPTY_BINDINGS), this._fromClass(null, clazz3, EMPTY_BINDINGS));
    }

    public MapLikeType constructMapLikeType(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        JavaType javaType3 = this._fromClass(null, clazz, TypeBindings.createIfNeeded(clazz, new JavaType[]{javaType, javaType2}));
        if (javaType3 instanceof MapLikeType) {
            return (MapLikeType)javaType3;
        }
        return MapLikeType.upgradeFrom(javaType3, javaType, javaType2);
    }

    public JavaType constructSimpleType(Class<?> clazz, JavaType[] javaTypeArray) {
        return this._fromClass(null, clazz, TypeBindings.create(clazz, javaTypeArray));
    }

    @Deprecated
    public JavaType constructSimpleType(Class<?> clazz, Class<?> clazz2, JavaType[] javaTypeArray) {
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    public JavaType constructReferenceType(Class<?> clazz, JavaType javaType) {
        return ReferenceType.construct(clazz, TypeBindings.create(clazz, javaType), null, null, javaType);
    }

    @Deprecated
    public JavaType uncheckedSimpleType(Class<?> clazz) {
        return this._constructSimple(clazz, EMPTY_BINDINGS, null, null);
    }

    public JavaType constructParametricType(Class<?> clazz, Class<?> ... classArray) {
        int n = classArray.length;
        JavaType[] javaTypeArray = new JavaType[n];
        for (int i = 0; i < n; ++i) {
            javaTypeArray[i] = this._fromClass(null, classArray[i], EMPTY_BINDINGS);
        }
        return this.constructParametricType(clazz, javaTypeArray);
    }

    public JavaType constructParametricType(Class<?> clazz, JavaType ... javaTypeArray) {
        return this.constructParametricType(clazz, TypeBindings.create(clazz, javaTypeArray));
    }

    public JavaType constructParametricType(Class<?> clazz, TypeBindings typeBindings) {
        JavaType javaType = this._fromClass(null, clazz, typeBindings);
        return this._applyModifiers(clazz, javaType);
    }

    @Deprecated
    public JavaType constructParametrizedType(Class<?> clazz, Class<?> clazz2, JavaType ... javaTypeArray) {
        return this.constructParametricType(clazz, javaTypeArray);
    }

    @Deprecated
    public JavaType constructParametrizedType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        return this.constructParametricType(clazz, classArray);
    }

    public CollectionType constructRawCollectionType(Class<? extends Collection> clazz) {
        return this.constructCollectionType(clazz, TypeFactory.unknownType());
    }

    public CollectionLikeType constructRawCollectionLikeType(Class<?> clazz) {
        return this.constructCollectionLikeType(clazz, TypeFactory.unknownType());
    }

    public MapType constructRawMapType(Class<? extends Map> clazz) {
        return this.constructMapType(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    public MapLikeType constructRawMapLikeType(Class<?> clazz) {
        return this.constructMapLikeType(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    private JavaType _mapType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        JavaType javaType2;
        JavaType javaType3;
        if (clazz == Properties.class) {
            javaType2 = javaType3 = CORE_TYPE_STRING;
        } else {
            List<JavaType> list = typeBindings.getTypeParameters();
            int n = list.size();
            switch (n) {
                case 0: {
                    javaType2 = javaType3 = this._unknownType();
                    break;
                }
                case 2: {
                    javaType2 = list.get(0);
                    javaType3 = list.get(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Strange Map type %s with %d type parameter%s (%s), can not resolve", ClassUtil.nameOf(clazz), n, n == 1 ? "" : "s", typeBindings));
                }
            }
        }
        return MapType.construct(clazz, typeBindings, javaType, javaTypeArray, javaType2, javaType3);
    }

    private JavaType _collectionType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        JavaType javaType2;
        List<JavaType> list = typeBindings.getTypeParameters();
        if (list.isEmpty()) {
            javaType2 = this._unknownType();
        } else if (list.size() == 1) {
            javaType2 = list.get(0);
        } else {
            throw new IllegalArgumentException("Strange Collection type " + clazz.getName() + ": cannot determine type parameters");
        }
        return CollectionType.construct(clazz, typeBindings, javaType, javaTypeArray, javaType2);
    }

    private JavaType _referenceType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        JavaType javaType2;
        List<JavaType> list = typeBindings.getTypeParameters();
        if (list.isEmpty()) {
            javaType2 = this._unknownType();
        } else if (list.size() == 1) {
            javaType2 = list.get(0);
        } else {
            throw new IllegalArgumentException("Strange Reference type " + clazz.getName() + ": cannot determine type parameters");
        }
        return ReferenceType.construct(clazz, typeBindings, javaType, javaTypeArray, javaType2);
    }

    protected JavaType _constructSimple(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        JavaType javaType2;
        if (typeBindings.isEmpty() && (javaType2 = this._findWellKnownSimple(clazz)) != null) {
            return javaType2;
        }
        return this._newSimpleType(clazz, typeBindings, javaType, javaTypeArray);
    }

    protected JavaType _newSimpleType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return new SimpleType(clazz, typeBindings, javaType, javaTypeArray);
    }

    protected JavaType _unknownType() {
        return CORE_TYPE_OBJECT;
    }

    protected JavaType _findWellKnownSimple(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == CLS_BOOL) {
                return CORE_TYPE_BOOL;
            }
            if (clazz == CLS_INT) {
                return CORE_TYPE_INT;
            }
            if (clazz == CLS_LONG) {
                return CORE_TYPE_LONG;
            }
        } else {
            if (clazz == CLS_STRING) {
                return CORE_TYPE_STRING;
            }
            if (clazz == CLS_OBJECT) {
                return CORE_TYPE_OBJECT;
            }
            if (clazz == CLS_JSON_NODE) {
                return CORE_TYPE_JSON_NODE;
            }
        }
        return null;
    }

    protected JavaType _fromAny(ClassStack classStack, Type type, TypeBindings typeBindings) {
        JavaType javaType;
        if (type instanceof Class) {
            javaType = this._fromClass(classStack, (Class)type, EMPTY_BINDINGS);
        } else if (type instanceof ParameterizedType) {
            javaType = this._fromParamType(classStack, (ParameterizedType)type, typeBindings);
        } else {
            if (type instanceof JavaType) {
                return (JavaType)type;
            }
            if (type instanceof GenericArrayType) {
                javaType = this._fromArrayType(classStack, (GenericArrayType)type, typeBindings);
            } else if (type instanceof TypeVariable) {
                javaType = this._fromVariable(classStack, (TypeVariable)type, typeBindings);
            } else if (type instanceof WildcardType) {
                javaType = this._fromWildcard(classStack, (WildcardType)type, typeBindings);
            } else {
                throw new IllegalArgumentException("Unrecognized Type: " + (type == null ? "[null]" : type.toString()));
            }
        }
        return this._applyModifiers(type, javaType);
    }

    protected JavaType _applyModifiers(Type type, JavaType javaType) {
        if (this._modifiers == null) {
            return javaType;
        }
        JavaType javaType2 = javaType;
        TypeBindings typeBindings = javaType2.getBindings();
        if (typeBindings == null) {
            typeBindings = EMPTY_BINDINGS;
        }
        for (TypeModifier typeModifier : this._modifiers) {
            JavaType javaType3 = typeModifier.modifyType(javaType2, type, typeBindings, this);
            if (javaType3 == null) {
                throw new IllegalStateException(String.format("TypeModifier %s (of type %s) return null for type %s", typeModifier, typeModifier.getClass().getName(), javaType2));
            }
            javaType2 = javaType3;
        }
        return javaType2;
    }

    protected JavaType _fromClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Object object;
        JavaType javaType = this._findWellKnownSimple(clazz);
        if (javaType != null) {
            return javaType;
        }
        Object object2 = typeBindings == null || typeBindings.isEmpty() ? clazz : typeBindings.asKey(clazz);
        javaType = this._typeCache.get(object2);
        if (javaType != null) {
            return javaType;
        }
        if (classStack == null) {
            classStack = new ClassStack(clazz);
        } else {
            object = classStack.find(clazz);
            if (object != null) {
                ResolvedRecursiveType resolvedRecursiveType = new ResolvedRecursiveType(clazz, EMPTY_BINDINGS);
                ((ClassStack)object).addSelfReference(resolvedRecursiveType);
                return resolvedRecursiveType;
            }
            classStack = classStack.child(clazz);
        }
        if (clazz.isArray()) {
            javaType = ArrayType.construct(this._fromAny(classStack, clazz.getComponentType(), typeBindings), typeBindings);
        } else {
            JavaType[] javaTypeArray;
            if (clazz.isInterface()) {
                object = null;
                javaTypeArray = this._resolveSuperInterfaces(classStack, clazz, typeBindings);
            } else {
                object = this._resolveSuperClass(classStack, clazz, typeBindings);
                javaTypeArray = this._resolveSuperInterfaces(classStack, clazz, typeBindings);
            }
            if (clazz == Properties.class) {
                javaType = MapType.construct(clazz, typeBindings, (JavaType)object, javaTypeArray, CORE_TYPE_STRING, CORE_TYPE_STRING);
            } else if (object != null) {
                javaType = ((JavaType)object).refine(clazz, typeBindings, (JavaType)object, javaTypeArray);
            }
            if (javaType == null && (javaType = this._fromWellKnownClass(classStack, clazz, typeBindings, (JavaType)object, javaTypeArray)) == null && (javaType = this._fromWellKnownInterface(classStack, clazz, typeBindings, (JavaType)object, javaTypeArray)) == null) {
                javaType = this._newSimpleType(clazz, typeBindings, (JavaType)object, javaTypeArray);
            }
        }
        classStack.resolveSelfReferences(javaType);
        if (!javaType.hasHandlers()) {
            this._typeCache.putIfAbsent(object2, javaType);
        }
        return javaType;
    }

    protected JavaType _resolveSuperClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Type type = ClassUtil.getGenericSuperclass(clazz);
        if (type == null) {
            return null;
        }
        return this._fromAny(classStack, type, typeBindings);
    }

    protected JavaType[] _resolveSuperInterfaces(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Type[] typeArray = ClassUtil.getGenericInterfaces(clazz);
        if (typeArray == null || typeArray.length == 0) {
            return NO_TYPES;
        }
        int n = typeArray.length;
        JavaType[] javaTypeArray = new JavaType[n];
        for (int i = 0; i < n; ++i) {
            Type type = typeArray[i];
            javaTypeArray[i] = this._fromAny(classStack, type, typeBindings);
        }
        return javaTypeArray;
    }

    protected JavaType _fromWellKnownClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        if (typeBindings == null) {
            typeBindings = EMPTY_BINDINGS;
        }
        if (clazz == Map.class) {
            return this._mapType(clazz, typeBindings, javaType, javaTypeArray);
        }
        if (clazz == Collection.class) {
            return this._collectionType(clazz, typeBindings, javaType, javaTypeArray);
        }
        if (clazz == AtomicReference.class) {
            return this._referenceType(clazz, typeBindings, javaType, javaTypeArray);
        }
        return null;
    }

    protected JavaType _fromWellKnownInterface(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        int n = javaTypeArray.length;
        for (int i = 0; i < n; ++i) {
            JavaType javaType2 = javaTypeArray[i].refine(clazz, typeBindings, javaType, javaTypeArray);
            if (javaType2 == null) continue;
            return javaType2;
        }
        return null;
    }

    protected JavaType _fromParamType(ClassStack classStack, ParameterizedType parameterizedType, TypeBindings typeBindings) {
        TypeBindings typeBindings2;
        int n;
        Class clazz = (Class)parameterizedType.getRawType();
        if (clazz == CLS_ENUM) {
            return CORE_TYPE_ENUM;
        }
        if (clazz == CLS_COMPARABLE) {
            return CORE_TYPE_COMPARABLE;
        }
        if (clazz == CLS_CLASS) {
            return CORE_TYPE_CLASS;
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n2 = n = typeArray == null ? 0 : typeArray.length;
        if (n == 0) {
            typeBindings2 = EMPTY_BINDINGS;
        } else {
            JavaType[] javaTypeArray = new JavaType[n];
            for (int i = 0; i < n; ++i) {
                javaTypeArray[i] = this._fromAny(classStack, typeArray[i], typeBindings);
            }
            typeBindings2 = TypeBindings.create(clazz, javaTypeArray);
        }
        return this._fromClass(classStack, clazz, typeBindings2);
    }

    protected JavaType _fromArrayType(ClassStack classStack, GenericArrayType genericArrayType, TypeBindings typeBindings) {
        JavaType javaType = this._fromAny(classStack, genericArrayType.getGenericComponentType(), typeBindings);
        return ArrayType.construct(javaType, typeBindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaType _fromVariable(ClassStack classStack, TypeVariable<?> typeVariable, TypeBindings typeBindings) {
        Type[] typeArray;
        String string = typeVariable.getName();
        if (typeBindings == null) {
            throw new IllegalArgumentException("Null `bindings` passed (type variable \"" + string + "\")");
        }
        JavaType javaType = typeBindings.findBoundType(string);
        if (javaType != null) {
            return javaType;
        }
        if (typeBindings.hasUnbound(string)) {
            return CORE_TYPE_OBJECT;
        }
        typeBindings = typeBindings.withUnboundVariable(string);
        TypeVariable<?> typeVariable2 = typeVariable;
        synchronized (typeVariable2) {
            typeArray = typeVariable.getBounds();
        }
        return this._fromAny(classStack, typeArray[0], typeBindings);
    }

    protected JavaType _fromWildcard(ClassStack classStack, WildcardType wildcardType, TypeBindings typeBindings) {
        return this._fromAny(classStack, wildcardType.getUpperBounds()[0], typeBindings);
    }
}

