/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeBindings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_STRINGS = new String[0];
    private static final JavaType[] NO_TYPES = new JavaType[0];
    private static final TypeBindings EMPTY = new TypeBindings(NO_STRINGS, NO_TYPES, null);
    private final String[] _names;
    private final JavaType[] _types;
    private final String[] _unboundVariables;
    private final int _hashCode;

    private TypeBindings(String[] stringArray, JavaType[] javaTypeArray, String[] stringArray2) {
        this._names = stringArray == null ? NO_STRINGS : stringArray;
        JavaType[] javaTypeArray2 = this._types = javaTypeArray == null ? NO_TYPES : javaTypeArray;
        if (this._names.length != this._types.length) {
            throw new IllegalArgumentException("Mismatching names (" + this._names.length + "), types (" + this._types.length + ")");
        }
        int n = 1;
        int n2 = this._types.length;
        for (int i = 0; i < n2; ++i) {
            n += this._types[i].hashCode();
        }
        this._unboundVariables = stringArray2;
        this._hashCode = n;
    }

    public static TypeBindings emptyBindings() {
        return EMPTY;
    }

    protected Object readResolve() {
        if (this._names == null || this._names.length == 0) {
            return EMPTY;
        }
        return this;
    }

    public static TypeBindings create(Class<?> clazz, List<JavaType> list) {
        JavaType[] javaTypeArray = list == null || list.isEmpty() ? NO_TYPES : list.toArray(NO_TYPES);
        return TypeBindings.create(clazz, javaTypeArray);
    }

    public static TypeBindings create(Class<?> clazz, JavaType[] javaTypeArray) {
        String[] stringArray;
        if (javaTypeArray == null) {
            javaTypeArray = NO_TYPES;
        } else {
            switch (javaTypeArray.length) {
                case 1: {
                    return TypeBindings.create(clazz, javaTypeArray[0]);
                }
                case 2: {
                    return TypeBindings.create(clazz, javaTypeArray[0], javaTypeArray[1]);
                }
            }
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray == null || typeVariableArray.length == 0) {
            stringArray = NO_STRINGS;
        } else {
            int n = typeVariableArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = typeVariableArray[i].getName();
            }
        }
        if (stringArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with " + javaTypeArray.length + " type parameter" + (javaTypeArray.length == 1 ? "" : "s") + ": class expects " + stringArray.length);
        }
        return new TypeBindings(stringArray, javaTypeArray, null);
    }

    public static TypeBindings create(Class<?> clazz, JavaType javaType) {
        int n;
        TypeVariable<?>[] typeVariableArray = TypeParamStash.paramsFor1(clazz);
        int n2 = n = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 1 type parameter: class expects " + n);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName()}, new JavaType[]{javaType}, null);
    }

    public static TypeBindings create(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        int n;
        TypeVariable<?>[] typeVariableArray = TypeParamStash.paramsFor2(clazz);
        int n2 = n = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n != 2) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 2 type parameters: class expects " + n);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName(), typeVariableArray[1].getName()}, new JavaType[]{javaType, javaType2}, null);
    }

    public static TypeBindings create(List<String> list, List<JavaType> list2) {
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            return EMPTY;
        }
        return new TypeBindings(list.toArray(NO_STRINGS), list2.toArray(NO_TYPES), null);
    }

    public static TypeBindings createIfNeeded(Class<?> clazz, JavaType javaType) {
        int n;
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        int n2 = n = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n == 0) {
            return EMPTY;
        }
        if (n != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 1 type parameter: class expects " + n);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName()}, new JavaType[]{javaType}, null);
    }

    public static TypeBindings createIfNeeded(Class<?> clazz, JavaType[] javaTypeArray) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray == null || typeVariableArray.length == 0) {
            return EMPTY;
        }
        if (javaTypeArray == null) {
            javaTypeArray = NO_TYPES;
        }
        int n = typeVariableArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = typeVariableArray[i].getName();
        }
        if (stringArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with " + javaTypeArray.length + " type parameter" + (javaTypeArray.length == 1 ? "" : "s") + ": class expects " + stringArray.length);
        }
        return new TypeBindings(stringArray, javaTypeArray, null);
    }

    public TypeBindings withUnboundVariable(String string) {
        int n = this._unboundVariables == null ? 0 : this._unboundVariables.length;
        String[] stringArray = n == 0 ? new String[1] : Arrays.copyOf(this._unboundVariables, n + 1);
        stringArray[n] = string;
        return new TypeBindings(this._names, this._types, stringArray);
    }

    public JavaType findBoundType(String string) {
        int n = this._names.length;
        for (int i = 0; i < n; ++i) {
            ResolvedRecursiveType resolvedRecursiveType;
            JavaType javaType;
            if (!string.equals(this._names[i])) continue;
            JavaType javaType2 = this._types[i];
            if (javaType2 instanceof ResolvedRecursiveType && (javaType = (resolvedRecursiveType = (ResolvedRecursiveType)javaType2).getSelfReferencedType()) != null) {
                javaType2 = javaType;
            }
            return javaType2;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._types.length == 0;
    }

    public int size() {
        return this._types.length;
    }

    public String getBoundName(int n) {
        if (n < 0 || n >= this._names.length) {
            return null;
        }
        return this._names[n];
    }

    public JavaType getBoundType(int n) {
        if (n < 0 || n >= this._types.length) {
            return null;
        }
        return this._types[n];
    }

    public List<JavaType> getTypeParameters() {
        if (this._types.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._types);
    }

    public boolean hasUnbound(String string) {
        if (this._unboundVariables != null) {
            int n = this._unboundVariables.length;
            while (--n >= 0) {
                if (!string.equals(this._unboundVariables[n])) continue;
                return true;
            }
        }
        return false;
    }

    public Object asKey(Class<?> clazz) {
        return new AsKey(clazz, this._types, this._hashCode);
    }

    public String toString() {
        if (this._types.length == 0) {
            return "<>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        int n = this._types.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            String string = this._types[i].getGenericSignature();
            stringBuilder.append(string);
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        int n = this._types.length;
        TypeBindings typeBindings = (TypeBindings)object;
        if (n != typeBindings.size()) {
            return false;
        }
        JavaType[] javaTypeArray = typeBindings._types;
        for (int i = 0; i < n; ++i) {
            if (javaTypeArray[i].equals(this._types[i])) continue;
            return false;
        }
        return true;
    }

    protected JavaType[] typeParameterArray() {
        return this._types;
    }

    static final class AsKey {
        private final Class<?> _raw;
        private final JavaType[] _params;
        private final int _hash;

        public AsKey(Class<?> clazz, JavaType[] javaTypeArray, int n) {
            this._raw = clazz;
            this._params = javaTypeArray;
            this._hash = n;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            JavaType[] javaTypeArray;
            int n;
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            AsKey asKey = (AsKey)object;
            if (this._hash == asKey._hash && this._raw == asKey._raw && (n = this._params.length) == (javaTypeArray = asKey._params).length) {
                for (int i = 0; i < n; ++i) {
                    if (this._params[i].equals(javaTypeArray[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this._raw.getName() + "<>";
        }
    }

    static class TypeParamStash {
        private static final TypeVariable<?>[] VARS_ABSTRACT_LIST = AbstractList.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_COLLECTION = Collection.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_ITERABLE = Iterable.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_LIST = List.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_ARRAY_LIST = ArrayList.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_MAP = Map.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_HASH_MAP = HashMap.class.getTypeParameters();
        private static final TypeVariable<?>[] VARS_LINKED_HASH_MAP = LinkedHashMap.class.getTypeParameters();

        TypeParamStash() {
        }

        public static TypeVariable<?>[] paramsFor1(Class<?> clazz) {
            if (clazz == Collection.class) {
                return VARS_COLLECTION;
            }
            if (clazz == List.class) {
                return VARS_LIST;
            }
            if (clazz == ArrayList.class) {
                return VARS_ARRAY_LIST;
            }
            if (clazz == AbstractList.class) {
                return VARS_ABSTRACT_LIST;
            }
            if (clazz == Iterable.class) {
                return VARS_ITERABLE;
            }
            return clazz.getTypeParameters();
        }

        public static TypeVariable<?>[] paramsFor2(Class<?> clazz) {
            if (clazz == Map.class) {
                return VARS_MAP;
            }
            if (clazz == HashMap.class) {
                return VARS_HASH_MAP;
            }
            if (clazz == LinkedHashMap.class) {
                return VARS_LINKED_HASH_MAP;
            }
            return clazz.getTypeParameters();
        }
    }
}

