/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public class UUIDSerializer
extends StdScalarSerializer<UUID>
implements ContextualSerializer {
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    protected final Boolean _asBinary;

    public UUIDSerializer() {
        this((Boolean)null);
    }

    protected UUIDSerializer(Boolean bl) {
        super(UUID.class);
        this._asBinary = bl;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, UUID uUID) {
        return uUID.getLeastSignificantBits() == 0L && uUID.getMostSignificantBits() == 0L;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        Boolean bl = null;
        if (value != null) {
            JsonFormat.Shape shape = value.getShape();
            if (shape == JsonFormat.Shape.BINARY) {
                bl = true;
            } else if (shape == JsonFormat.Shape.STRING) {
                bl = false;
            }
        }
        if (!Objects.equals(bl, this._asBinary)) {
            return new UUIDSerializer(bl);
        }
        return this;
    }

    @Override
    public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._writeAsBinary(jsonGenerator)) {
            jsonGenerator.writeBinary(UUIDSerializer._asBytes(uUID));
            return;
        }
        char[] cArray = new char[36];
        long l = uUID.getMostSignificantBits();
        UUIDSerializer._appendInt((int)(l >> 32), cArray, 0);
        cArray[8] = 45;
        int n = (int)l;
        UUIDSerializer._appendShort(n >>> 16, cArray, 9);
        cArray[13] = 45;
        UUIDSerializer._appendShort(n, cArray, 14);
        cArray[18] = 45;
        long l2 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendShort((int)(l2 >>> 48), cArray, 19);
        cArray[23] = 45;
        UUIDSerializer._appendShort((int)(l2 >>> 32), cArray, 24);
        UUIDSerializer._appendInt((int)l2, cArray, 28);
        jsonGenerator.writeString(cArray, 0, 36);
    }

    protected boolean _writeAsBinary(JsonGenerator jsonGenerator) {
        if (this._asBinary != null) {
            return this._asBinary;
        }
        return !(jsonGenerator instanceof TokenBuffer) && jsonGenerator.canWriteBinaryNatively();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this.visitStringFormat(jsonFormatVisitorWrapper, javaType, JsonValueFormat.UUID);
    }

    private static void _appendInt(int n, char[] cArray, int n2) {
        UUIDSerializer._appendShort(n >> 16, cArray, n2);
        UUIDSerializer._appendShort(n, cArray, n2 + 4);
    }

    private static void _appendShort(int n, char[] cArray, int n2) {
        cArray[n2] = HEX_CHARS[n >> 12 & 0xF];
        cArray[++n2] = HEX_CHARS[n >> 8 & 0xF];
        cArray[++n2] = HEX_CHARS[n >> 4 & 0xF];
        cArray[++n2] = HEX_CHARS[n & 0xF];
    }

    private static final byte[] _asBytes(UUID uUID) {
        byte[] byArray = new byte[16];
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendInt((int)(l >> 32), byArray, 0);
        UUIDSerializer._appendInt((int)l, byArray, 4);
        UUIDSerializer._appendInt((int)(l2 >> 32), byArray, 8);
        UUIDSerializer._appendInt((int)l2, byArray, 12);
        return byArray;
    }

    private static final void _appendInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[++n2] = (byte)(n >> 16);
        byArray[++n2] = (byte)(n >> 8);
        byArray[++n2] = (byte)n;
    }
}

