/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final AccessorNamingStrategy _accessorNaming;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final boolean _useAnnotations;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected LinkedList<POJOPropertyBuilder> _creatorProperties;
    protected Map<PropertyName, PropertyName> _fieldRenameMappings;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMember> _anyGetterField;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMember> _jsonKeyAccessors;
    protected LinkedList<AnnotatedMember> _jsonValueAccessors;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;
    @Deprecated
    protected final boolean _stdBeanNaming;
    @Deprecated
    protected String _mutatorPrefix = "set";

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl, JavaType javaType, AnnotatedClass annotatedClass, AccessorNamingStrategy accessorNamingStrategy) {
        this._config = mapperConfig;
        this._forSerialization = bl;
        this._type = javaType;
        this._classDef = annotatedClass;
        if (mapperConfig.isAnnotationProcessingEnabled()) {
            this._useAnnotations = true;
            this._annotationIntrospector = this._config.getAnnotationIntrospector();
        } else {
            this._useAnnotations = false;
            this._annotationIntrospector = AnnotationIntrospector.nopInstance();
        }
        this._visibilityChecker = this._config.getDefaultVisibilityChecker(javaType.getRawClass(), annotatedClass);
        this._accessorNaming = accessorNamingStrategy;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
    }

    @Deprecated
    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl, JavaType javaType, AnnotatedClass annotatedClass, String string) {
        this(mapperConfig, bl, javaType, annotatedClass, POJOPropertiesCollector._accessorNaming(mapperConfig, annotatedClass, string));
        this._mutatorPrefix = string;
    }

    private static AccessorNamingStrategy _accessorNaming(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, String string) {
        if (string == null) {
            string = "set";
        }
        return new DefaultAccessorNamingStrategy.Provider().withSetterPrefix(string).forPOJO(mapperConfig, annotatedClass);
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = this.getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    public AnnotatedMember getJsonKeyAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonKeyAccessors != null) {
            if (this._jsonKeyAccessors.size() > 1) {
                this.reportProblem("Multiple 'as-key' properties defined (%s vs %s)", this._jsonKeyAccessors.get(0), this._jsonKeyAccessors.get(1));
            }
            return this._jsonKeyAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getJsonValueAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonValueAccessors != null) {
            if (this._jsonValueAccessors.size() > 1) {
                this.reportProblem("Multiple 'as-value' properties defined (%s vs %s)", this._jsonValueAccessors.get(0), this._jsonValueAccessors.get(1));
            }
            return this._jsonValueAccessors.get(0);
        }
        return null;
    }

    @Deprecated
    public AnnotatedMember getAnyGetter() {
        return this.getAnyGetterMethod();
    }

    public AnnotatedMember getAnyGetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetterField != null) {
            if (this._anyGetterField.size() > 1) {
                this.reportProblem("Multiple 'any-getter' fields defined (%s vs %s)", this._anyGetterField.get(0), this._anyGetterField.get(1));
            }
            return this._anyGetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnyGetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getter' methods defined (%s vs %s)", this._anyGetters.get(0), this._anyGetters.get(1));
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetterField != null) {
            if (this._anySetterField.size() > 1) {
                this.reportProblem("Multiple 'any-setter' fields defined (%s vs %s)", this._anySetterField.get(0), this._anySetterField.get(1));
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setter' methods defined (%s vs %s)", this._anySetters.get(0), this._anySetters.get(1));
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    @Deprecated
    public AnnotatedMethod getJsonValueMethod() {
        AnnotatedMember annotatedMember = this.getJsonValueAccessor();
        if (annotatedMember instanceof AnnotatedMethod) {
            return (AnnotatedMethod)annotatedMember;
        }
        return null;
    }

    @Deprecated
    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    protected void collectAll() {
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>();
        this._addFields(linkedHashMap);
        this._addMethods(linkedHashMap);
        if (!this._classDef.isNonStaticInnerClass()) {
            this._addCreators(linkedHashMap);
        }
        this._removeUnwantedProperties(linkedHashMap);
        this._removeUnwantedAccessor(linkedHashMap);
        this._renameProperties(linkedHashMap);
        this._addInjectables(linkedHashMap);
        for (POJOPropertyBuilder object : linkedHashMap.values()) {
            object.mergeAnnotations(this._forSerialization);
        }
        PropertyNamingStrategy propertyNamingStrategy = this._findNamingStrategy();
        if (propertyNamingStrategy != null) {
            this._renameUsing(linkedHashMap, propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap);
        }
        this._sortProperties(linkedHashMap);
        this._properties = linkedHashMap;
        this._collected = true;
    }

    protected void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl2 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl3;
            PropertyName propertyName;
            boolean bl4;
            boolean bl5;
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedField))) {
                if (this._jsonKeyAccessors == null) {
                    this._jsonKeyAccessors = new LinkedList();
                }
                this._jsonKeyAccessors.add(annotatedField);
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedField))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedField);
                continue;
            }
            boolean bl6 = Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedField));
            boolean bl7 = Boolean.TRUE.equals(annotationIntrospector.hasAnySetter(annotatedField));
            if (bl6 || bl7) {
                if (bl6) {
                    if (this._anyGetterField == null) {
                        this._anyGetterField = new LinkedList();
                    }
                    this._anyGetterField.add(annotatedField);
                }
                if (!bl7) continue;
                if (this._anySetterField == null) {
                    this._anySetterField = new LinkedList();
                }
                this._anySetterField.add(annotatedField);
                continue;
            }
            String string = annotationIntrospector.findImplicitPropertyName(annotatedField);
            if (string == null) {
                string = annotatedField.getName();
            }
            if ((string = this._accessorNaming.modifyFieldName(annotatedField, string)) == null) continue;
            PropertyName propertyName2 = this._propNameFromSimple(string);
            PropertyName propertyName3 = annotationIntrospector.findRenameByField(this._config, annotatedField, propertyName2);
            if (propertyName3 != null && !propertyName3.equals(propertyName2)) {
                if (this._fieldRenameMappings == null) {
                    this._fieldRenameMappings = new HashMap<PropertyName, PropertyName>();
                }
                this._fieldRenameMappings.put(propertyName3, propertyName2);
            }
            if ((bl5 = (bl4 = (propertyName = this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField)) != null)) && propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl5 = false;
            }
            boolean bl8 = bl3 = propertyName != null;
            if (!bl3) {
                bl3 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl9 = annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (annotatedField.isTransient() && !bl4) {
                bl3 = false;
                if (bl2) {
                    bl9 = true;
                }
            }
            if (bl && propertyName == null && !bl9 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            this._property(map, string).addField(annotatedField, propertyName, bl5, bl3, bl9);
        }
    }

    protected void _addCreators(Map<String, POJOPropertyBuilder> map) {
        int n;
        int n2;
        if (!this._useAnnotations) {
            return;
        }
        for (AnnotatedConstructor annotatedWithParams : this._classDef.getConstructors()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n2 = annotatedWithParams.getParameterCount();
            for (n = 0; n < n2; ++n) {
                this._addCreatorParam(map, annotatedWithParams.getParameter(n));
            }
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.getFactoryMethods()) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            n2 = annotatedMethod.getParameterCount();
            for (n = 0; n < n2; ++n) {
                this._addCreatorParam(map, annotatedMethod.getParameter(n));
            }
        }
    }

    protected void _addCreatorParam(Map<String, POJOPropertyBuilder> map, AnnotatedParameter annotatedParameter) {
        Object object;
        PropertyName propertyName;
        boolean bl;
        String string = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter);
        if (string == null) {
            string = "";
        }
        boolean bl2 = bl = (propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedParameter)) != null && !propertyName.isEmpty();
        if (!bl) {
            if (string.isEmpty()) {
                return;
            }
            object = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedParameter.getOwner());
            if (object == null || object == JsonCreator.Mode.DISABLED) {
                return;
            }
            propertyName = PropertyName.construct(string);
        }
        string = this._checkRenameByField(string);
        object = bl && string.isEmpty() ? this._property(map, propertyName) : this._property(map, string);
        ((POJOPropertyBuilder)object).addCtor(annotatedParameter, propertyName, bl, true, false);
        this._creatorProperties.add((POJOPropertyBuilder)object);
    }

    protected void _addMethods(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n = annotatedMethod.getParameterCount();
            if (n == 0) {
                this._addGetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n == 1) {
                this._addSetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n != 2 || !Boolean.TRUE.equals(this._annotationIntrospector.hasAnySetter(annotatedMethod))) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        boolean bl2;
        Object object = annotatedMethod.getRawReturnType();
        if (object == Void.TYPE || object == Void.class && !this._config.isEnabled(MapperFeature.ALLOW_VOID_VALUED_PROPERTIES)) {
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedMethod))) {
            if (this._anyGetters == null) {
                this._anyGetters = new LinkedList();
            }
            this._anyGetters.add(annotatedMethod);
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedMethod))) {
            if (this._jsonKeyAccessors == null) {
                this._jsonKeyAccessors = new LinkedList();
            }
            this._jsonKeyAccessors.add(annotatedMethod);
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedMethod))) {
            if (this._jsonValueAccessors == null) {
                this._jsonValueAccessors = new LinkedList();
            }
            this._jsonValueAccessors.add(annotatedMethod);
            return;
        }
        PropertyName propertyName = annotationIntrospector.findNameForSerialization(annotatedMethod);
        boolean bl3 = bl2 = propertyName != null;
        if (!bl2) {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null) {
                object = this._accessorNaming.findNameForRegularGetter(annotatedMethod, annotatedMethod.getName());
            }
            if (object == null) {
                object = this._accessorNaming.findNameForIsGetter(annotatedMethod, annotatedMethod.getName());
                if (object == null) {
                    return;
                }
                bl = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null && (object = this._accessorNaming.findNameForRegularGetter(annotatedMethod, annotatedMethod.getName())) == null) {
                object = this._accessorNaming.findNameForIsGetter(annotatedMethod, annotatedMethod.getName());
            }
            if (object == null) {
                object = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple((String)object);
                bl2 = false;
            }
            bl = true;
        }
        object = this._checkRenameByField((String)object);
        boolean bl4 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, (String)object).addGetter(annotatedMethod, propertyName, bl2, bl, bl4);
    }

    protected void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl;
        String string;
        boolean bl2;
        PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl3 = bl2 = propertyName != null;
        if (!bl2) {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = this._accessorNaming.findNameForMutator(annotatedMethod, annotatedMethod.getName());
            }
            if (string == null) {
                return;
            }
            bl = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = this._accessorNaming.findNameForMutator(annotatedMethod, annotatedMethod.getName());
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl2 = false;
            }
            bl = true;
        }
        string = this._checkRenameByField(string);
        boolean bl4 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addSetter(annotatedMethod, propertyName, bl2, bl, bl4);
    }

    protected void _addInjectables(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedField annotatedMember : this._classDef.fields()) {
            this._doAddInjectable(this._annotationIntrospector.findInjectableValue(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (annotatedMethod.getParameterCount() != 1) continue;
            this._doAddInjectable(this._annotationIntrospector.findInjectableValue(annotatedMethod), annotatedMethod);
        }
    }

    protected void _doAddInjectable(JacksonInject.Value value, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (value == null) {
            return;
        }
        Object object = value.getId();
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null && annotatedMember2.getClass() == annotatedMember.getClass()) {
            String string = object.getClass().getName();
            throw new IllegalArgumentException("Duplicate injectable value with id '" + object + "' (of type " + string + ")");
        }
    }

    private PropertyName _propNameFromSimple(String string) {
        return PropertyName.construct(string, null);
    }

    private String _checkRenameByField(String string) {
        PropertyName propertyName;
        if (this._fieldRenameMappings != null && (propertyName = this._fieldRenameMappings.get(this._propNameFromSimple(string))) != null) {
            string = propertyName.getSimpleName();
            return string;
        }
        return string;
    }

    protected void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> map) {
        Iterator<POJOPropertyBuilder> iterator2 = map.values().iterator();
        while (iterator2.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = iterator2.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                iterator2.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (!pOJOPropertyBuilder.isExplicitlyIncluded()) {
                iterator2.remove();
                this._collectIgnorals(pOJOPropertyBuilder.getName());
                continue;
            }
            pOJOPropertyBuilder.removeIgnored();
            if (pOJOPropertyBuilder.couldDeserialize()) continue;
            this._collectIgnorals(pOJOPropertyBuilder.getName());
        }
    }

    protected void _removeUnwantedAccessor(Map<String, POJOPropertyBuilder> map) {
        boolean bl = this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
            pOJOPropertyBuilder.removeNonVisible(bl, this._forSerialization ? null : this);
        }
    }

    protected void _collectIgnorals(String string) {
        if (!this._forSerialization && string != null) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    protected void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator2 = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator2.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.findExplicitNames();
            if (object2.isEmpty()) continue;
            iterator2.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            if (object2.size() == 1) {
                object = (PropertyName)object2.iterator().next();
                linkedList.add(pOJOPropertyBuilder.withName((PropertyName)object));
                continue;
            }
            linkedList.addAll(pOJOPropertyBuilder.explode((Collection<PropertyName>)object2));
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                } else {
                    ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
                }
                if (!this._replaceCreatorProperty(pOJOPropertyBuilder, this._creatorProperties) || this._ignoredPropertyNames == null) continue;
                this._ignoredPropertyNames.remove(object2);
            }
        }
    }

    protected void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            String string;
            PropertyName propertyName = pOJOPropertyBuilder.getFullName();
            String string2 = null;
            if (!pOJOPropertyBuilder.isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                if (this._forSerialization) {
                    if (pOJOPropertyBuilder.hasGetter()) {
                        string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                    } else if (pOJOPropertyBuilder.hasField()) {
                        string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                    }
                } else if (pOJOPropertyBuilder.hasSetter()) {
                    string2 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetterUnchecked(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasConstructorParameter()) {
                    string2 = propertyNamingStrategy.nameForConstructorParameter(this._config, pOJOPropertyBuilder.getConstructorParameter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasField()) {
                    string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getFieldUnchecked(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasGetter()) {
                    string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetterUnchecked(), propertyName.getSimpleName());
                }
            }
            if (string2 != null && !propertyName.hasSimpleName(string2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName(string2);
                string = string2;
            } else {
                string = propertyName.getSimpleName();
            }
            POJOPropertyBuilder pOJOPropertyBuilder2 = map.get(string);
            if (pOJOPropertyBuilder2 == null) {
                map.put(string, pOJOPropertyBuilder);
            } else {
                pOJOPropertyBuilder2.addAll(pOJOPropertyBuilder);
            }
            this._replaceCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
        }
    }

    protected void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator2 = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator2.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator2.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(pOJOPropertyBuilder.getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator2.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        Comparable<POJOPropertyBuilder> comparable;
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        Boolean bl = annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
        boolean bl2 = bl == null ? this._config.shouldSortPropertiesAlphabetically() : bl.booleanValue();
        boolean bl3 = this._anyIndexed(map.values());
        String[] stringArray = annotationIntrospector.findSerializationPropertyOrder(this._classDef);
        if (!bl2 && !bl3 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n = map.size();
        AbstractMap abstractMap = bl2 ? new TreeMap() : new LinkedHashMap(n + n);
        for (POJOPropertyBuilder object22 : map.values()) {
            abstractMap.put(object22.getName(), object22);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(n + n);
        if (stringArray != null) {
            for (String string : stringArray) {
                void var13_27;
                comparable = (POJOPropertyBuilder)abstractMap.remove(string);
                if (comparable == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
                        if (!string.equals(pOJOPropertyBuilder.getInternalName())) continue;
                        comparable = pOJOPropertyBuilder;
                        String string2 = pOJOPropertyBuilder.getName();
                        break;
                    }
                }
                if (comparable == null) continue;
                linkedHashMap.put(var13_27, comparable);
            }
        }
        if (bl3) {
            TreeMap<POJOPropertyBuilder, POJOPropertyBuilder> treeMap = new TreeMap<POJOPropertyBuilder, POJOPropertyBuilder>();
            Iterator iterator2 = abstractMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)entry.getValue();
                comparable = pOJOPropertyBuilder.getMetadata().getIndex();
                if (comparable == null) continue;
                treeMap.put((POJOPropertyBuilder)comparable, pOJOPropertyBuilder);
                iterator2.remove();
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : treeMap.values()) {
                linkedHashMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
            }
        }
        if (this._creatorProperties != null && (!bl2 || this._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_FIRST))) {
            void var10_17;
            if (bl2) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    treeMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                LinkedList<POJOPropertyBuilder> linkedList = this._creatorProperties;
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : var10_17) {
                String string = pOJOPropertyBuilder.getName();
                if (!abstractMap.containsKey(string)) continue;
                linkedHashMap.put(string, pOJOPropertyBuilder);
            }
        }
        linkedHashMap.putAll(abstractMap);
        map.clear();
        map.putAll(linkedHashMap);
    }

    private boolean _anyIndexed(Collection<POJOPropertyBuilder> collection) {
        for (POJOPropertyBuilder pOJOPropertyBuilder : collection) {
            if (!pOJOPropertyBuilder.getMetadata().hasIndex()) continue;
            return true;
        }
        return false;
    }

    protected void reportProblem(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, PropertyName propertyName) {
        String string = propertyName.getSimpleName();
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, PropertyName.construct(string));
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        PropertyNamingStrategy propertyNamingStrategy;
        Object object = this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned PropertyNamingStrategy definition of type " + object.getClass().getName() + "; expected type PropertyNamingStrategy or Class<PropertyNamingStrategy> instead");
        }
        Class clazz = (Class)object;
        if (clazz == PropertyNamingStrategy.class) {
            return null;
        }
        if (!PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<PropertyNamingStrategy>");
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        if (handlerInstantiator != null && (propertyNamingStrategy = handlerInstantiator.namingStrategyInstance(this._config, this._classDef, clazz)) != null) {
            return propertyNamingStrategy;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
    }

    @Deprecated
    protected void _updateCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        this._replaceCreatorProperty(pOJOPropertyBuilder, list);
    }

    protected boolean _replaceCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        if (list != null) {
            String string = pOJOPropertyBuilder.getInternalName();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!list.get(i).getInternalName().equals(string)) continue;
                list.set(i, pOJOPropertyBuilder);
                return true;
            }
        }
        return false;
    }
}

