/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    private static final long serialVersionUID = 1L;
    static final int[] HEX_DIGITS;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return new UUID(0L, 0L);
    }

    @Override
    protected UUID _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
        if (string.length() != 36) {
            if (string.length() == 24) {
                byte[] byArray = Base64Variants.getDefaultVariant().decode(string);
                return this._fromBytes(byArray, deserializationContext);
            }
            return this._badFormat(string, deserializationContext);
        }
        if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            this._badFormat(string, deserializationContext);
        }
        long l = this.intFromChars(string, 0, deserializationContext);
        long l2 = (long)this.shortFromChars(string, 9, deserializationContext) << 16;
        long l3 = (l <<= 32) + (l2 |= (long)this.shortFromChars(string, 14, deserializationContext));
        int n = this.shortFromChars(string, 19, deserializationContext) << 16 | this.shortFromChars(string, 24, deserializationContext);
        l = n;
        l2 = this.intFromChars(string, 28, deserializationContext);
        l2 = l2 << 32 >>> 32;
        long l4 = (l <<= 32) | l2;
        return new UUID(l3, l4);
    }

    @Override
    protected UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException {
        if (object instanceof byte[]) {
            return this._fromBytes((byte[])object, deserializationContext);
        }
        return (UUID)super._deserializeEmbedded(object, deserializationContext);
    }

    private UUID _badFormat(String string, DeserializationContext deserializationContext) throws IOException {
        return (UUID)deserializationContext.handleWeirdStringValue(this.handledType(), string, "UUID has to be represented by standard 36-char representation", new Object[0]);
    }

    int intFromChars(String string, int n, DeserializationContext deserializationContext) throws JsonMappingException {
        return (this.byteFromChars(string, n, deserializationContext) << 24) + (this.byteFromChars(string, n + 2, deserializationContext) << 16) + (this.byteFromChars(string, n + 4, deserializationContext) << 8) + this.byteFromChars(string, n + 6, deserializationContext);
    }

    int shortFromChars(String string, int n, DeserializationContext deserializationContext) throws JsonMappingException {
        return (this.byteFromChars(string, n, deserializationContext) << 8) + this.byteFromChars(string, n + 2, deserializationContext);
    }

    int byteFromChars(String string, int n, DeserializationContext deserializationContext) throws JsonMappingException {
        int n2;
        char c = string.charAt(n);
        char c2 = string.charAt(n + 1);
        if (c <= '\u007f' && c2 <= '\u007f' && (n2 = HEX_DIGITS[c] << 4 | HEX_DIGITS[c2]) >= 0) {
            return n2;
        }
        if (c > '\u007f' || HEX_DIGITS[c] < 0) {
            return this._badChar(string, n, deserializationContext, c);
        }
        return this._badChar(string, n + 1, deserializationContext, c2);
    }

    int _badChar(String string, int n, DeserializationContext deserializationContext, char c) throws JsonMappingException {
        throw deserializationContext.weirdStringException(string, this.handledType(), String.format("Non-hex character '%c' (value 0x%s), not valid for UUID String", Character.valueOf(c), Integer.toHexString(c)));
    }

    private UUID _fromBytes(byte[] byArray, DeserializationContext deserializationContext) throws JsonMappingException {
        if (byArray.length != 16) {
            throw InvalidFormatException.from(deserializationContext.getParser(), "Can only construct UUIDs from byte[16]; got " + byArray.length + " bytes", byArray, this.handledType());
        }
        return new UUID(UUIDDeserializer._long(byArray, 0), UUIDDeserializer._long(byArray, 8));
    }

    private static long _long(byte[] byArray, int n) {
        long l = (long)UUIDDeserializer._int(byArray, n) << 32;
        long l2 = UUIDDeserializer._int(byArray, n + 4);
        l2 = l2 << 32 >>> 32;
        return l | l2;
    }

    private static int _int(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static {
        int n;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (n = 0; n < 10; ++n) {
            UUIDDeserializer.HEX_DIGITS[48 + n] = n;
        }
        for (n = 0; n < 6; ++n) {
            UUIDDeserializer.HEX_DIGITS[97 + n] = 10 + n;
            UUIDDeserializer.HEX_DIGITS[65 + n] = 10 + n;
        }
    }
}

