/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class PropertyBasedCreator {
    protected final int _propertyCount;
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _propertyLookup;
    protected final SettableBeanProperty[] _allProperties;

    protected PropertyBasedCreator(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, boolean bl, boolean bl2) {
        Object object;
        int n;
        this._valueInstantiator = valueInstantiator;
        this._propertyLookup = bl ? CaseInsensitiveMap.construct(deserializationContext.getConfig().getLocale()) : new HashMap();
        this._propertyCount = n = settableBeanPropertyArray.length;
        this._allProperties = new SettableBeanProperty[n];
        if (bl2) {
            DeserializationConfig deserializationConfig = deserializationContext.getConfig();
            object = settableBeanPropertyArray;
            int n2 = ((SettableBeanProperty[])object).length;
            for (int i = 0; i < n2; ++i) {
                List<PropertyName> list;
                SettableBeanProperty settableBeanProperty = object[i];
                if (settableBeanProperty.isIgnorable() || (list = settableBeanProperty.findAliases(deserializationConfig)).isEmpty()) continue;
                for (PropertyName propertyName : list) {
                    this._propertyLookup.put(propertyName.getSimpleName(), settableBeanProperty);
                }
            }
        }
        for (int i = 0; i < n; ++i) {
            this._allProperties[i] = object = settableBeanPropertyArray[i];
            if (((SettableBeanProperty)object).isIgnorable()) continue;
            this._propertyLookup.put(((SettableBeanProperty)object).getName(), (SettableBeanProperty)object);
        }
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, BeanPropertyMap beanPropertyMap) throws JsonMappingException {
        int n = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n];
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i];
            if (!settableBeanProperty.hasValueDeserializer() && !settableBeanProperty.isInjectionOnly()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i] = settableBeanProperty;
        }
        return new PropertyBasedCreator(deserializationContext, valueInstantiator, settableBeanPropertyArray2, beanPropertyMap.isCaseInsensitive(), true);
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, boolean bl) throws JsonMappingException {
        int n = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n];
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i];
            if (!settableBeanProperty.hasValueDeserializer()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i] = settableBeanProperty;
        }
        return new PropertyBasedCreator(deserializationContext, valueInstantiator, settableBeanPropertyArray2, bl, false);
    }

    @Deprecated
    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) throws JsonMappingException {
        return PropertyBasedCreator.construct(deserializationContext, valueInstantiator, settableBeanPropertyArray, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
    }

    public Collection<SettableBeanProperty> properties() {
        return this._propertyLookup.values();
    }

    public SettableBeanProperty findCreatorProperty(String string) {
        return this._propertyLookup.get(string);
    }

    public SettableBeanProperty findCreatorProperty(int n) {
        for (SettableBeanProperty settableBeanProperty : this._propertyLookup.values()) {
            if (settableBeanProperty.getPropertyIndex() != n) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public PropertyValueBuffer startBuilding(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectIdReader objectIdReader) {
        return new PropertyValueBuffer(jsonParser, deserializationContext, this._propertyCount, objectIdReader);
    }

    public Object build(DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer) throws IOException {
        Object object = this._valueInstantiator.createFromObjectWith(deserializationContext, this._allProperties, propertyValueBuffer);
        if (object != null) {
            object = propertyValueBuffer.handleIdValue(deserializationContext, object);
            PropertyValue propertyValue = propertyValueBuffer.buffered();
            while (propertyValue != null) {
                propertyValue.assign(object);
                propertyValue = propertyValue.next;
            }
        }
        return object;
    }

    static class CaseInsensitiveMap
    extends HashMap<String, SettableBeanProperty> {
        private static final long serialVersionUID = 1L;
        protected final Locale _locale;

        @Deprecated
        public CaseInsensitiveMap() {
            this(Locale.getDefault());
        }

        public CaseInsensitiveMap(Locale locale) {
            this._locale = locale;
        }

        public static CaseInsensitiveMap construct(Locale locale) {
            return new CaseInsensitiveMap(locale);
        }

        @Override
        public SettableBeanProperty get(Object object) {
            return (SettableBeanProperty)super.get(((String)object).toLowerCase(this._locale));
        }

        @Override
        public SettableBeanProperty put(String string, SettableBeanProperty settableBeanProperty) {
            string = string.toLowerCase(this._locale);
            return super.put(string, settableBeanProperty);
        }
    }
}

