/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public class UTF8StreamJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_NON_NUM_NUMBERS = JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected ObjectCodec _objectCodec;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int _quad1;
    protected int _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    @Deprecated
    public UTF8StreamJsonParser(IOContext iOContext, int n, InputStream inputStream2, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, byte[] byArray, int n2, int n3, boolean bl) {
        this(iOContext, n, inputStream2, objectCodec, byteQuadsCanonicalizer, byArray, n2, n3, 0, bl);
    }

    public UTF8StreamJsonParser(IOContext iOContext, int n, InputStream inputStream2, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, byte[] byArray, int n2, int n3, int n4, boolean bl) {
        super(iOContext, n);
        this._inputStream = inputStream2;
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._currInputRowStart = n2 - n4;
        this._currInputProcessed = -n2 + n4;
        this._bufferRecyclable = bl;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return JSON_READ_CAPABILITIES;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream2) throws IOException {
        int n = this._inputEnd - this._inputPtr;
        if (n < 1) {
            return 0;
        }
        int n2 = this._inputPtr;
        this._inputPtr += n;
        outputStream2.write(this._inputBuffer, n2, n);
        return n;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    protected final boolean _loadMore() throws IOException {
        if (this._inputStream != null) {
            int n = this._inputBuffer.length;
            if (n == 0) {
                return false;
            }
            int n2 = this._inputStream.read(this._inputBuffer, 0, n);
            if (n2 > 0) {
                int n3 = this._inputEnd;
                this._currInputProcessed += (long)n3;
                this._currInputRowStart -= n3;
                this._nameStartOffset -= n3;
                this._inputPtr = 0;
                this._inputEnd = n2;
                return true;
            }
            this._closeInput();
            if (n2 == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        byte[] byArray;
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable && (byArray = this._inputBuffer) != null && byArray != NO_BYTES) {
            this._inputBuffer = NO_BYTES;
            this._ioContext.releaseReadIOBuffer(byArray);
        }
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            String string = this._parsingContext.getCurrentName();
            writer.write(string);
            return string.length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            writer.write(cArray);
            return cArray.length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(n);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return this._parsingContext.getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream2) throws IOException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream2.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n = this._readBinary(base64Variant, outputStream2, byArray);
            return n;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream2, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = byArray.length - 3;
        int n3 = 0;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n5 = base64Variant.decodeBase64Char(n4);
            if (n5 < 0) {
                if (n4 == 34) break;
                n5 = this._decodeBase64Escape(base64Variant, n4, 0);
                if (n5 < 0) continue;
            }
            if (n > n2) {
                n3 += n;
                outputStream2.write(byArray, 0, n);
                n = 0;
            }
            int n6 = n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n5 = this._decodeBase64Escape(base64Variant, n4, 1);
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n5 != -2) {
                    if (n4 == 34) {
                        byArray[n++] = (byte)(n6 >>= 4);
                        if (!base64Variant.usesPadding()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n4, 2);
                }
                if (n5 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n4 = this._inputBuffer[this._inputPtr++] & 0xFF) && this._decodeBase64Escape(base64Variant, n4, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, n4, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n++] = (byte)(n6 >>= 4);
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n5 = base64Variant.decodeBase64Char(n4 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n5 != -2) {
                    if (n4 == 34) {
                        byArray[n++] = (byte)((n6 >>= 2) >> 8);
                        byArray[n++] = (byte)n6;
                        if (!base64Variant.usesPadding()) break;
                        --this._inputPtr;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, n4, 3);
                }
                if (n5 == -2) {
                    byArray[n++] = (byte)((n6 >>= 2) >> 8);
                    byArray[n++] = (byte)n6;
                    continue;
                }
            }
            n6 = n6 << 6 | n5;
            byArray[n++] = (byte)(n6 >> 16);
            byArray[n++] = (byte)(n6 >> 8);
            byArray[n++] = (byte)n6;
        }
        this._tokenIncomplete = false;
        if (n > 0) {
            n3 += n;
            outputStream2.write(byArray, 0, n);
        }
        return n3;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        int n;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n == 93) {
            this._closeArrayScope();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n == 93 || n == 125)) {
                return this._closeScope(n);
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            return this._nextTokenNotInObject(n);
        }
        this._updateNameLocation();
        String string = this._parseName(n);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        this._updateLocation();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken _nextTokenNotInObject(int n) throws IOException {
        if (n == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchTrue();
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchFalse();
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchNull();
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod();
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parsePosNumber(n);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n);
        return this._currToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public boolean nextFieldName(SerializableString serializableString) throws IOException {
        int n;
        byte[] byArray;
        int n2;
        int n3;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n3 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._binaryValue = null;
        if (n3 == 93) {
            this._closeArrayScope();
            this._currToken = JsonToken.END_ARRAY;
            return false;
        }
        if (n3 == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return false;
        }
        if (this._parsingContext.expectComma()) {
            if (n3 != 44) {
                this._reportUnexpectedChar(n3, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n3 = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n3 == 93 || n3 == 125)) {
                this._closeScope(n3);
                return false;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n3);
            return false;
        }
        this._updateNameLocation();
        if (n3 == 34 && this._inputPtr + (n2 = (byArray = serializableString.asQuotedUTF8()).length) + 4 < this._inputEnd && this._inputBuffer[n = this._inputPtr + n2] == 34) {
            int n4 = 0;
            int n5 = this._inputPtr;
            while (true) {
                if (n5 == n) {
                    this._parsingContext.setCurrentName(serializableString.getValue());
                    n3 = this._skipColonFast(n5 + 1);
                    this._isNextTokenNameYes(n3);
                    return true;
                }
                if (byArray[n4] != this._inputBuffer[n5]) break;
                ++n4;
                ++n5;
            }
        }
        return this._isNextTokenNameMaybe(n3, serializableString);
    }

    @Override
    public String nextFieldName() throws IOException {
        JsonToken jsonToken;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (n == 93) {
            this._closeArrayScope();
            this._currToken = JsonToken.END_ARRAY;
            return null;
        }
        if (n == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return null;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n == 93 || n == 125)) {
                this._closeScope(n);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._updateLocation();
            this._nextTokenNotInObject(n);
            return null;
        }
        this._updateNameLocation();
        String string = this._parseName(n);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        this._updateLocation();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    private final int _skipColonFast(int n) throws IOException {
        byte by;
        if ((by = this._inputBuffer[n++]) == 58) {
            if ((by = this._inputBuffer[n++]) > 32) {
                if (by != 47 && by != 35) {
                    this._inputPtr = n;
                    return by;
                }
            } else if ((by == 32 || by == 9) && (by = this._inputBuffer[n++]) > 32 && by != 47 && by != 35) {
                this._inputPtr = n;
                return by;
            }
            this._inputPtr = n - 1;
            return this._skipColon2(true);
        }
        if (by == 32 || by == 9) {
            by = this._inputBuffer[n++];
        }
        if (by == 58) {
            if ((by = this._inputBuffer[n++]) > 32) {
                if (by != 47 && by != 35) {
                    this._inputPtr = n;
                    return by;
                }
            } else if ((by == 32 || by == 9) && (by = this._inputBuffer[n++]) > 32 && by != 47 && by != 35) {
                this._inputPtr = n;
                return by;
            }
            this._inputPtr = n - 1;
            return this._skipColon2(true);
        }
        this._inputPtr = n - 1;
        return this._skipColon2(false);
    }

    private final void _isNextTokenNameYes(int n) throws IOException {
        this._currToken = JsonToken.FIELD_NAME;
        this._updateLocation();
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            case 91: {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            case 123: {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            case 116: {
                this._matchTrue();
                this._nextToken = JsonToken.VALUE_TRUE;
                return;
            }
            case 102: {
                this._matchFalse();
                this._nextToken = JsonToken.VALUE_FALSE;
                return;
            }
            case 110: {
                this._matchNull();
                this._nextToken = JsonToken.VALUE_NULL;
                return;
            }
            case 45: {
                this._nextToken = this._parseNegNumber();
                return;
            }
            case 46: {
                this._nextToken = this._parseFloatThatStartsWithPeriod();
                return;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._nextToken = this._parsePosNumber(n);
                return;
            }
        }
        this._nextToken = this._handleUnexpectedValue(n);
    }

    private final boolean _isNextTokenNameMaybe(int n, SerializableString serializableString) throws IOException {
        JsonToken jsonToken;
        String string = this._parseName(n);
        this._parsingContext.setCurrentName(string);
        boolean bl = string.equals(serializableString.getValue());
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        this._updateLocation();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return bl;
        }
        switch (n) {
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n);
            }
        }
        this._nextToken = jsonToken;
        return bl;
    }

    @Override
    public String nextTextValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this._finishAndReturnString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n;
    }

    @Override
    public long nextLongValue(long l) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod() throws IOException {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleUnexpectedValue(46);
        }
        return this._parseFloat(this._textBuffer.emptyAndGetCurrentSegment(), 0, 46, false, 0);
    }

    protected JsonToken _parsePosNumber(int n) throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n == 48) {
            n = this._verifyNoLeadingZeroes();
        }
        cArray[0] = (char)n;
        int n2 = 1;
        int n3 = 1;
        int n4 = Math.min(this._inputEnd, this._inputPtr + cArray.length - 1);
        while (true) {
            if (this._inputPtr >= n4) {
                return this._parseNumber2(cArray, n3, false, n2);
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n > 57) break;
            ++n2;
            cArray[n3++] = (char)n;
        }
        if (n == 46 || n == 101 || n == 69) {
            return this._parseFloat(cArray, n3, n, false, n2);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        return this.resetInt(false, n2);
    }

    protected JsonToken _parseNegNumber() throws IOException {
        int n;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        cArray[n2++] = 45;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 48) {
            if (n != 48) {
                return this._handleInvalidNumberStart(n, true);
            }
            n = this._verifyNoLeadingZeroes();
        } else if (n > 57) {
            return this._handleInvalidNumberStart(n, true);
        }
        cArray[n2++] = (char)n;
        int n3 = 1;
        int n4 = Math.min(this._inputEnd, this._inputPtr + cArray.length - n2);
        while (true) {
            if (this._inputPtr >= n4) {
                return this._parseNumber2(cArray, n2, true, n3);
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n > 57) break;
            ++n3;
            cArray[n2++] = (char)n;
        }
        if (n == 46 || n == 101 || n == 69) {
            return this._parseFloat(cArray, n2, n, true, n3);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        return this.resetInt(true, n3);
    }

    private final JsonToken _parseNumber2(char[] cArray, int n, boolean bl, int n2) throws IOException {
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._textBuffer.setCurrentLength(n);
                return this.resetInt(bl, n2);
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) > 57 || n3 < 48) {
                if (n3 != 46 && n3 != 101 && n3 != 69) break;
                return this._parseFloat(cArray, n, n3, bl, n2);
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n3;
            ++n2;
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(this._inputBuffer[this._inputPtr] & 0xFF);
        }
        return this.resetInt(bl, n2);
    }

    private final int _verifyNoLeadingZeroes() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return 48;
        }
        int n = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n < 48 || n > 57) {
            return 48;
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (n == 48) {
            while (this._inputPtr < this._inputEnd || this._loadMore()) {
                n = this._inputBuffer[this._inputPtr] & 0xFF;
                if (n < 48 || n > 57) {
                    return 48;
                }
                ++this._inputPtr;
                if (n == 48) continue;
                break;
            }
        }
        return n;
    }

    private final JsonToken _parseFloat(char[] cArray, int n, int n2, boolean bl, int n3) throws IOException {
        int n4 = 0;
        boolean bl2 = false;
        if (n2 == 46) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
                ++n4;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (n2 == 101 || n2 == 69) {
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || n2 == 43) {
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                }
                n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (n2 >= 48 && n2 <= 57) {
                ++n5;
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = (char)n2;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl2 = true;
                    break;
                }
                n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(n2);
            }
        }
        this._textBuffer.setCurrentLength(n);
        return this.resetFloat(bl, n3, n4, n5);
    }

    private final void _verifyRootSpace(int n) throws IOException {
        ++this._inputPtr;
        switch (n) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                this._skipCR();
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n);
    }

    protected final String _parseName(int n) throws IOException {
        int n2;
        if (n != 34) {
            return this._handleOddName(n);
        }
        if (this._inputPtr + 13 > this._inputEnd) {
            return this.slowParseName();
        }
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
            if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                n2 = n2 << 8 | n;
                if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                    n2 = n2 << 8 | n;
                    if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                        n2 = n2 << 8 | n;
                        if (nArray[n = byArray[this._inputPtr++] & 0xFF] == 0) {
                            this._quad1 = n2;
                            return this.parseMediumName(n);
                        }
                        if (n == 34) {
                            return this.findName(n2, 4);
                        }
                        return this.parseName(n2, n, 4);
                    }
                    if (n == 34) {
                        return this.findName(n2, 3);
                    }
                    return this.parseName(n2, n, 3);
                }
                if (n == 34) {
                    return this.findName(n2, 2);
                }
                return this.parseName(n2, n, 2);
            }
            if (n == 34) {
                return this.findName(n2, 1);
            }
            return this.parseName(n2, n, 1);
        }
        if (n2 == 34) {
            return "";
        }
        return this.parseName(0, n2, 0);
    }

    protected final String parseMediumName(int n) throws IOException {
        int n2;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 1);
            }
            return this.parseName(this._quad1, n, n2, 1);
        }
        n = n << 8 | n2;
        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 2);
            }
            return this.parseName(this._quad1, n, n2, 2);
        }
        n = n << 8 | n2;
        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 3);
            }
            return this.parseName(this._quad1, n, n2, 3);
        }
        n = n << 8 | n2;
        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n2 == 34) {
                return this.findName(this._quad1, n, 4);
            }
            return this.parseName(this._quad1, n, n2, 4);
        }
        return this.parseMediumName2(n2, n);
    }

    protected final String parseMediumName2(int n, int n2) throws IOException {
        int n3;
        int[] nArray = _icLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 1);
            }
            return this.parseName(this._quad1, n2, n, n3, 1);
        }
        n = n << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 2);
            }
            return this.parseName(this._quad1, n2, n, n3, 2);
        }
        n = n << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 3);
            }
            return this.parseName(this._quad1, n2, n, n3, 3);
        }
        n = n << 8 | n3;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, n, 4);
            }
            return this.parseName(this._quad1, n2, n, n3, 4);
        }
        return this.parseLongName(n3, n2, n);
    }

    protected final String parseLongName(int n, int n2, int n3) throws IOException {
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n2;
        this._quadBuffer[2] = n3;
        byte[] byArray = this._inputBuffer;
        int[] nArray = _icLatin1;
        int n4 = 3;
        while (this._inputPtr + 4 <= this._inputEnd) {
            int n5;
            if (nArray[n5 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 1);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 1);
            }
            n = n << 8 | n5;
            if (nArray[n5 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 2);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 2);
            }
            n = n << 8 | n5;
            if (nArray[n5 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 3);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 3);
            }
            n = n << 8 | n5;
            if (nArray[n5 = byArray[this._inputPtr++] & 0xFF] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n, 4);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n, n5, 4);
            }
            if (n4 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8StreamJsonParser.growArrayBy(this._quadBuffer, n4);
            }
            this._quadBuffer[n4++] = n;
            n = n5;
        }
        return this.parseEscapedName(this._quadBuffer, n4, 0, n, 0);
    }

    protected String slowParseName() throws IOException {
        int n;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name", JsonToken.FIELD_NAME);
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return "";
        }
        return this.parseEscapedName(this._quadBuffer, 0, 0, n, 0);
    }

    private final String parseName(int n, int n2, int n3) throws IOException {
        return this.parseEscapedName(this._quadBuffer, 0, n, n2, n3);
    }

    private final String parseName(int n, int n2, int n3, int n4) throws IOException {
        this._quadBuffer[0] = n;
        return this.parseEscapedName(this._quadBuffer, 1, n2, n3, n4);
    }

    private final String parseName(int n, int n2, int n3, int n4, int n5) throws IOException {
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.parseEscapedName(this._quadBuffer, 2, n3, n4, n5);
    }

    protected final String parseEscapedName(int[] nArray, int n, int n2, int n3, int n4) throws IOException {
        String string;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (nArray2[n3] != 0) {
                if (n3 == 34) break;
                if (n3 != 92) {
                    this._throwUnquotedSpace(n3, "name");
                } else {
                    n3 = this._decodeEscaped();
                }
                if (n3 > 127) {
                    if (n4 >= 4) {
                        if (n >= nArray.length) {
                            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n++] = n2;
                        n2 = 0;
                        n4 = 0;
                    }
                    if (n3 < 2048) {
                        n2 = n2 << 8 | (0xC0 | n3 >> 6);
                        ++n4;
                    } else {
                        n2 = n2 << 8 | (0xE0 | n3 >> 12);
                        if (++n4 >= 4) {
                            if (n >= nArray.length) {
                                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n++] = n2;
                            n2 = 0;
                            n4 = 0;
                        }
                        n2 = n2 << 8 | (0x80 | n3 >> 6 & 0x3F);
                        ++n4;
                    }
                    n3 = 0x80 | n3 & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n2 = n2 << 8 | n3;
            } else {
                if (n >= nArray.length) {
                    nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n++] = n2;
                n2 = n3;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n >= nArray.length) {
                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n++] = UTF8StreamJsonParser._padLastQuad(n2, n4);
        }
        if ((string = this._symbols.findName(nArray, n)) == null) {
            string = this.addName(nArray, n, n4);
        }
        return string;
    }

    protected String _handleOddName(int n) throws IOException {
        String string;
        int[] nArray;
        if (n == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            char c = (char)this._decodeCharForError(n);
            this._reportUnexpectedChar(c, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n] != 0) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray2.length) {
                    this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                }
                nArray2[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            if (nArray[n = this._inputBuffer[this._inputPtr] & 0xFF] != 0) break;
            ++this._inputPtr;
        }
        if (n4 > 0) {
            if (n2 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n2++] = n3;
        }
        if ((string = this._symbols.findName(nArray2, n2)) == null) {
            string = this.addName(nArray2, n2, n4);
        }
        return string;
    }

    protected String _parseAposName() throws IOException {
        String string;
        int n;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for field name", JsonToken.FIELD_NAME);
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray2 = _icLatin1;
        while (n != 39) {
            if (nArray2[n] != 0 && n != 34) {
                if (n != 92) {
                    this._throwUnquotedSpace(n, "name");
                } else {
                    n = this._decodeEscaped();
                }
                if (n > 127) {
                    if (n4 >= 4) {
                        if (n2 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n4 = 0;
                    }
                    if (n < 2048) {
                        n3 = n3 << 8 | (0xC0 | n >> 6);
                        ++n4;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n >> 12);
                        if (++n4 >= 4) {
                            if (n2 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n4 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n >> 6 & 0x3F);
                        ++n4;
                    }
                    n = 0x80 | n & 0x3F;
                }
            }
            if (n4 < 4) {
                ++n4;
                n3 = n3 << 8 | n;
            } else {
                if (n2 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n2++] = n3;
                n3 = n;
                n4 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            n = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n4 > 0) {
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n2++] = UTF8StreamJsonParser._padLastQuad(n3, n4);
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this.addName(nArray, n2, n4);
        }
        return string;
    }

    private final String findName(int n, int n2) throws JsonParseException {
        String string = this._symbols.findName(n = UTF8StreamJsonParser._padLastQuad(n, n2));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n;
        return this.addName(this._quadBuffer, 1, n2);
    }

    private final String findName(int n, int n2, int n3) throws JsonParseException {
        String string = this._symbols.findName(n, n2 = UTF8StreamJsonParser._padLastQuad(n2, n3));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n;
        this._quadBuffer[1] = n2;
        return this.addName(this._quadBuffer, 2, n3);
    }

    private final String findName(int n, int n2, int n3, int n4) throws JsonParseException {
        String string = this._symbols.findName(n, n2, n3 = UTF8StreamJsonParser._padLastQuad(n3, n4));
        if (string != null) {
            return string;
        }
        int[] nArray = this._quadBuffer;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = UTF8StreamJsonParser._padLastQuad(n3, n4);
        return this.addName(nArray, 3, n4);
    }

    private final String findName(int[] nArray, int n, int n2, int n3) throws JsonParseException {
        if (n >= nArray.length) {
            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n++] = UTF8StreamJsonParser._padLastQuad(n2, n3);
        String string = this._symbols.findName(nArray, n);
        if (string == null) {
            return this.addName(nArray, n, n3);
        }
        return string;
    }

    private final String addName(int[] nArray, int n, int n2) throws JsonParseException {
        int n3;
        int n4 = (n << 2) - 4 + n2;
        if (n2 < 4) {
            n3 = nArray[n - 1];
            nArray[n - 1] = n3 << (4 - n2 << 3);
        } else {
            n3 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = nArray[n6 >> 2];
            int n8 = n6 & 3;
            n7 = n7 >> (3 - n8 << 3) & 0xFF;
            ++n6;
            if (n7 > 127) {
                int n9;
                if ((n7 & 0xE0) == 192) {
                    n7 &= 0x1F;
                    n9 = 1;
                } else if ((n7 & 0xF0) == 224) {
                    n7 &= 0xF;
                    n9 = 2;
                } else if ((n7 & 0xF8) == 240) {
                    n7 &= 7;
                    n9 = 3;
                } else {
                    this._reportInvalidInitial(n7);
                    n7 = 1;
                    n9 = 1;
                }
                if (n6 + n9 > n4) {
                    this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                }
                int n10 = nArray[n6 >> 2];
                n8 = n6 & 3;
                ++n6;
                if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n10);
                }
                n7 = n7 << 6 | n10 & 0x3F;
                if (n9 > 1) {
                    n10 = nArray[n6 >> 2];
                    n8 = n6 & 3;
                    ++n6;
                    if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n10);
                    }
                    n7 = n7 << 6 | n10 & 0x3F;
                    if (n9 > 2) {
                        n10 = nArray[n6 >> 2];
                        n8 = n6 & 3;
                        ++n6;
                        if (((n10 >>= 3 - n8 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n10 & 0xFF);
                        }
                        n7 = n7 << 6 | n10 & 0x3F;
                    }
                }
                if (n9 > 2) {
                    n7 -= 65536;
                    if (n5 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n5++] = (char)(55296 + (n7 >> 10));
                    n7 = 0xDC00 | n7 & 0x3FF;
                }
            }
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n5++] = (char)n7;
        }
        String string = new String(cArray, 0, n5);
        if (n2 < 4) {
            nArray[n - 1] = n3;
        }
        return this._symbols.addName(string, nArray, n);
    }

    private static final int _padLastQuad(int n, int n2) {
        return n2 == 4 ? n : n | -1 << (n2 << 3);
    }

    protected void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Override
    protected void _finishString() throws IOException {
        int n = this._inputPtr;
        if (n >= this._inputEnd) {
            this._loadMoreGuaranteed();
            n = this._inputPtr;
        }
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = Math.min(this._inputEnd, n + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n < n3) {
            int n4 = byArray[n] & 0xFF;
            if (nArray[n4] != 0) {
                if (n4 != 34) break;
                this._inputPtr = n + 1;
                this._textBuffer.setCurrentLength(n2);
                return;
            }
            ++n;
            cArray[n2++] = (char)n4;
        }
        this._inputPtr = n;
        this._finishString2(cArray, n2);
    }

    protected String _finishAndReturnString() throws IOException {
        int n = this._inputPtr;
        if (n >= this._inputEnd) {
            this._loadMoreGuaranteed();
            n = this._inputPtr;
        }
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = Math.min(this._inputEnd, n + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n < n3) {
            int n4 = byArray[n] & 0xFF;
            if (nArray[n4] != 0) {
                if (n4 != 34) break;
                this._inputPtr = n + 1;
                return this._textBuffer.setCurrentAndReturn(n2);
            }
            ++n;
            cArray[n2++] = (char)n4;
        }
        this._inputPtr = n;
        this._finishString2(cArray, n2);
        return this._textBuffer.contentsAsString();
    }

    private final void _finishString2(char[] cArray, int n) throws IOException {
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n2;
            int n3;
            block15: {
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n = 0;
                }
                int n4 = Math.min(this._inputEnd, n3 + (cArray.length - n));
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) {
                        cArray[n++] = (char)n2;
                        continue;
                    }
                    break block15;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n++] = (char)(0xD800 | n2 >> 10);
                    if (n >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                        break;
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n;
            int n2;
            block10: {
                int n3;
                if ((n2 = this._inputPtr) >= (n3 = this._inputEnd)) {
                    this._loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n3 = this._inputEnd;
                }
                while (n2 < n3) {
                    if (nArray[n = byArray[n2++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n2;
                continue;
            }
            this._inputPtr = n2;
            if (n == 34) break;
            switch (nArray[n]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block6;
                }
            }
            if (n < 32) {
                this._throwUnquotedSpace(n, "string value");
                continue;
            }
            this._reportInvalidChar(n);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n) throws IOException {
        switch (n) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                    --this._inputPtr;
                    return JsonToken.VALUE_NULL;
                }
            }
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++] & 0xFF, false);
            }
        }
        if (Character.isJavaIdentifierStart(n)) {
            this._reportInvalidToken("" + (char)n, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() throws IOException {
        int n = 0;
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n3;
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            if ((n4 = this._inputPtr + (cArray.length - n2)) < (n3 = this._inputEnd)) {
                n3 = n4;
            }
            while (true) {
                if (this._inputPtr >= n3) continue block6;
                if ((n = byArray[this._inputPtr++] & 0xFF) == 39) break block6;
                if (nArray[n] != 0 && n != 34) break;
                cArray[n2++] = (char)n;
            }
            switch (nArray[n]) {
                case 1: {
                    n = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n = this._decodeUtf8_2(n);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n = this._decodeUtf8_3fast(n);
                        break;
                    }
                    n = this._decodeUtf8_3(n);
                    break;
                }
                case 4: {
                    n = this._decodeUtf8_4(n);
                    cArray[n2++] = (char)(0xD800 | n >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n = 0xDC00 | n & 0x3FF;
                    break;
                }
                default: {
                    if (n < 32) {
                        this._throwUnquotedSpace(n, "string value");
                    }
                    this._reportInvalidChar(n);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) throws IOException {
        while (n == 73) {
            String string;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_FLOAT);
            }
            if ((n = this._inputBuffer[this._inputPtr++]) == 78) {
                string = bl ? "-INF" : "+INF";
            } else {
                if (n != 110) break;
                string = bl ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '%s': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow", string);
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected final void _matchTrue() throws IOException {
        int n;
        byte[] byArray;
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n2++] == 114 && byArray[n2++] == 117 && byArray[n2++] == 101 && ((n = byArray[n2] & 0xFF) < 48 || n == 93 || n == 125)) {
            this._inputPtr = n2;
            return;
        }
        this._matchToken2("true", 1);
    }

    protected final void _matchFalse() throws IOException {
        int n;
        byte[] byArray;
        int n2 = this._inputPtr;
        if (n2 + 4 < this._inputEnd && (byArray = this._inputBuffer)[n2++] == 97 && byArray[n2++] == 108 && byArray[n2++] == 115 && byArray[n2++] == 101 && ((n = byArray[n2] & 0xFF) < 48 || n == 93 || n == 125)) {
            this._inputPtr = n2;
            return;
        }
        this._matchToken2("false", 1);
    }

    protected final void _matchNull() throws IOException {
        int n;
        byte[] byArray;
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd && (byArray = this._inputBuffer)[n2++] == 117 && byArray[n2++] == 108 && byArray[n2++] == 108 && ((n = byArray[n2] & 0xFF) < 48 || n == 93 || n == 125)) {
            this._inputPtr = n2;
            return;
        }
        this._matchToken2("null", 1);
    }

    protected final void _matchToken(String string, int n) throws IOException {
        int n2 = string.length();
        if (this._inputPtr + n2 >= this._inputEnd) {
            this._matchToken2(string, n);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < n2);
        int n3 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this._checkMatchEnd(string, n, n3);
        }
    }

    private final void _matchToken2(String string, int n) throws IOException {
        int n2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < n2);
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return;
        }
        int n3 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this._checkMatchEnd(string, n, n3);
        }
    }

    private final void _checkMatchEnd(String string, int n, int n2) throws IOException {
        char c = (char)this._decodeCharForError(n2);
        if (Character.isJavaIdentifierPart(c)) {
            this._reportInvalidToken(string.substring(0, n));
        }
    }

    private final int _skipWS() throws IOException {
        while (this._inputPtr < this._inputEnd) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n == 47 || n == 35) {
                    --this._inputPtr;
                    return this._skipWS2();
                }
                return n;
            }
            if (n == 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        return this._skipWS2();
    }

    private final int _skipWS2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n == 47) {
                    this._skipComment();
                    continue;
                }
                if (n == 35 && this._skipYAMLComment()) continue;
                return n;
            }
            if (n == 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException {
        int n;
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextChar();
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
            if (n == 47 || n == 35) {
                --this._inputPtr;
                return this._skipWSOrEnd2();
            }
            return n;
        }
        if (n != 32) {
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (n == 13) {
                this._skipCR();
            } else if (n != 9) {
                this._throwInvalidSpace(n);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n == 47 || n == 35) {
                    --this._inputPtr;
                    return this._skipWSOrEnd2();
                }
                return n;
            }
            if (n == 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        return this._skipWSOrEnd2();
    }

    private final int _skipWSOrEnd2() throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n == 47) {
                    this._skipComment();
                    continue;
                }
                if (n == 35 && this._skipYAMLComment()) continue;
                return n;
            }
            if (n == 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        return this._eofAsNextChar();
    }

    private final int _skipColon() throws IOException {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        byte by = this._inputBuffer[this._inputPtr];
        if (by == 58) {
            if ((by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by;
            }
            if ((by == 32 || by == 9) && (by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by;
            }
            return this._skipColon2(true);
        }
        if (by == 32 || by == 9) {
            by = this._inputBuffer[++this._inputPtr];
        }
        if (by == 58) {
            if ((by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by;
            }
            if ((by == 32 || by == 9) && (by = this._inputBuffer[++this._inputPtr]) > 32) {
                if (by == 47 || by == 35) {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return by;
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private final int _skipColon2(boolean bl) throws IOException {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n;
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n == 47) {
                    this._skipComment();
                    continue;
                }
                if (n == 35 && this._skipYAMLComment()) continue;
                if (bl) {
                    return n;
                }
                if (n != 58) {
                    this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
                }
                bl = true;
                continue;
            }
            if (n == 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
        return -1;
    }

    private final void _skipComment() throws IOException {
        int n;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipLine();
        } else if (n == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this._loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    break;
                }
                case 13: {
                    this._skipCR();
                    break;
                }
                case 2: {
                    this._skipUtf8_2();
                    break;
                }
                case 3: {
                    this._skipUtf8_3();
                    break;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    break;
                }
                default: {
                    this._reportInvalidChar(n);
                }
            }
        }
        this._reportInvalidEOF(" in a comment", null);
    }

    private final boolean _skipYAMLComment() throws IOException {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private final void _skipLine() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n;
            int n2;
            if ((n2 = nArray[n = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n2) {
                case 10: {
                    ++this._currInputRow;
                    this._currInputRowStart = this._inputPtr;
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block8;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block8;
                }
                case 4: {
                    this._skipUtf8_4(n);
                    continue block8;
                }
            }
            if (n2 >= 0) continue;
            this._reportInvalidChar(n);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        byte by = this._inputBuffer[this._inputPtr++];
        switch (by) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(by));
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            byte by2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
            }
            if ((n2 = CharTypes.charToHex(by2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by2 & 0xFF, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    protected int _decodeCharForError(int n) throws IOException {
        int n2 = n & 0xFF;
        if (n2 > 127) {
            int n3;
            if ((n2 & 0xE0) == 192) {
                n2 &= 0x1F;
                n3 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n2 &= 0xF;
                n3 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n2 &= 7;
                n3 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n3 = 1;
            }
            int n4 = this.nextByte();
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (n3 > 1) {
                n4 = this.nextByte();
                if ((n4 & 0xC0) != 128) {
                    this._reportInvalidOther(n4 & 0xFF);
                }
                n2 = n2 << 6 | n4 & 0x3F;
                if (n3 > 2) {
                    n4 = this.nextByte();
                    if ((n4 & 0xC0) != 128) {
                        this._reportInvalidOther(n4 & 0xFF);
                    }
                    n2 = n2 << 6 | n4 & 0x3F;
                }
            }
        }
        return n2;
    }

    private final int _decodeUtf8_2(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n & 0x1F) << 6 | by & 0x3F;
    }

    private final int _decodeUtf8_3(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_3fast(int n) throws IOException {
        byte by;
        n &= 0xF;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        int n2 = n << 6 | by & 0x3F;
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by & 0x3F;
        return n2;
    }

    private final int _decodeUtf8_4(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = (n & 7) << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        n = n << 6 | by & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        return (n << 6 | by & 0x3F) - 65536;
    }

    private final void _skipUtf8_2() throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_3() throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_4(int n) throws IOException {
        byte by;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidToken(String string, int n) throws IOException {
        this._inputPtr = n;
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String string) throws IOException {
        this._reportInvalidToken(string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(String string, String string2) throws IOException {
        byte by;
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c = (char)this._decodeCharForError(by = this._inputBuffer[this._inputPtr++]))) {
            stringBuilder.append(c);
            if (stringBuilder.length() < 256) continue;
            stringBuilder.append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", stringBuilder, string2);
    }

    protected void _reportInvalidChar(int n) throws JsonParseException {
        if (n < 32) {
            this._throwInvalidSpace(n);
        }
        this._reportInvalidInitial(n);
    }

    protected void _reportInvalidInitial(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n));
    }

    protected void _reportInvalidOther(int n, int n2) throws JsonParseException {
        this._inputPtr = n2;
        this._reportInvalidOther(n);
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n2 = base64Variant.decodeBase64Char(n);
            if (n2 < 0) {
                if (n == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, n, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, n, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    if (n == 34) {
                        byteArrayBuilder.append(n3 >>= 4);
                        if (base64Variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n = this._inputBuffer[this._inputPtr++] & 0xFF) && this._decodeBase64Escape(base64Variant, n, 3) != -2) {
                        throw this.reportInvalidBase64Char(base64Variant, n, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(n = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n2 != -2) {
                    if (n == 34) {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        if (base64Variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, n, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            long l = this._currInputProcessed + (long)(this._nameStartOffset - 1);
            return new JsonLocation(this._contentReference(), l, -1L, this._nameStartRow, this._nameStartCol);
        }
        return new JsonLocation(this._contentReference(), this._tokenInputTotal - 1L, -1L, this._tokenInputRow, this._tokenInputCol);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n = this._inputPtr - this._currInputRowStart + 1;
        return new JsonLocation(this._contentReference(), this._currInputProcessed + (long)this._inputPtr, -1L, this._currInputRow, n);
    }

    private final void _updateLocation() {
        this._tokenInputRow = this._currInputRow;
        int n = this._inputPtr;
        this._tokenInputTotal = this._currInputProcessed + (long)n;
        this._tokenInputCol = n - this._currInputRowStart;
    }

    private final void _updateNameLocation() {
        int n;
        this._nameStartRow = this._currInputRow;
        this._nameStartOffset = n = this._inputPtr;
        this._nameStartCol = n - this._currInputRowStart;
    }

    private final JsonToken _closeScope(int n) throws JsonParseException {
        if (n == 125) {
            this._closeObjectScope();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        this._closeArrayScope();
        this._currToken = JsonToken.END_ARRAY;
        return this._currToken;
    }

    private final void _closeArrayScope() throws JsonParseException {
        this._updateLocation();
        if (!this._parsingContext.inArray()) {
            this._reportMismatchedEndMarker(93, '}');
        }
        this._parsingContext = this._parsingContext.clearAndGetParent();
    }

    private final void _closeObjectScope() throws JsonParseException {
        this._updateLocation();
        if (!this._parsingContext.inObject()) {
            this._reportMismatchedEndMarker(125, ']');
        }
        this._parsingContext = this._parsingContext.clearAndGetParent();
    }
}

