/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.MergedStream;
import com.fasterxml.jackson.core.io.UTF32Reader;
import com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ByteSourceJsonBootstrapper {
    public static final byte UTF8_BOM_1 = -17;
    public static final byte UTF8_BOM_2 = -69;
    public static final byte UTF8_BOM_3 = -65;
    private final IOContext _context;
    private final InputStream _in;
    private final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    private boolean _bigEndian = true;
    private int _bytesPerChar;

    public ByteSourceJsonBootstrapper(IOContext iOContext, InputStream inputStream2) {
        this._context = iOContext;
        this._in = inputStream2;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._bufferRecyclable = true;
    }

    public ByteSourceJsonBootstrapper(IOContext iOContext, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._bufferRecyclable = false;
    }

    public JsonEncoding detectEncoding() throws IOException {
        JsonEncoding jsonEncoding;
        int n;
        boolean bl = false;
        if (this.ensureLoaded(4)) {
            n = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            if (this.handleBOM(n)) {
                bl = true;
            } else if (this.checkUTF32(n)) {
                bl = true;
            } else if (this.checkUTF16(n >>> 16)) {
                bl = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(n = (this._inputBuffer[this._inputPtr] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 1] & 0xFF)) {
            bl = true;
        }
        if (!bl) {
            jsonEncoding = JsonEncoding.UTF8;
        } else {
            switch (this._bytesPerChar) {
                case 1: {
                    jsonEncoding = JsonEncoding.UTF8;
                    break;
                }
                case 2: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
                    break;
                }
                case 4: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error");
                }
            }
        }
        this._context.setEncoding(jsonEncoding);
        return jsonEncoding;
    }

    public static int skipUTF8BOM(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if (n != 239) {
            return n;
        }
        n = dataInput.readUnsignedByte();
        if (n != 187) {
            throw new IOException("Unexpected byte 0x" + Integer.toHexString(n) + " following 0xEF; should get 0xBB as part of UTF-8 BOM");
        }
        n = dataInput.readUnsignedByte();
        if (n != 191) {
            throw new IOException("Unexpected byte 0x" + Integer.toHexString(n) + " following 0xEF 0xBB; should get 0xBF as part of UTF-8 BOM");
        }
        return dataInput.readUnsignedByte();
    }

    public Reader constructReader() throws IOException {
        JsonEncoding jsonEncoding = this._context.getEncoding();
        switch (jsonEncoding.bits()) {
            case 8: 
            case 16: {
                InputStream inputStream2 = this._in;
                if (inputStream2 == null) {
                    inputStream2 = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
                } else if (this._inputPtr < this._inputEnd) {
                    inputStream2 = new MergedStream(this._context, inputStream2, this._inputBuffer, this._inputPtr, this._inputEnd);
                }
                return new InputStreamReader(inputStream2, jsonEncoding.getJavaName());
            }
            case 32: {
                return new UTF32Reader(this._context, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
        }
        throw new RuntimeException("Internal error");
    }

    public JsonParser constructParser(int n, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, CharsToNameCanonicalizer charsToNameCanonicalizer, int n2) throws IOException {
        int n3 = this._inputPtr;
        JsonEncoding jsonEncoding = this.detectEncoding();
        int n4 = this._inputPtr - n3;
        if (jsonEncoding == JsonEncoding.UTF8 && JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2)) {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = byteQuadsCanonicalizer.makeChild(n2);
            return new UTF8StreamJsonParser(this._context, n, this._in, objectCodec, byteQuadsCanonicalizer2, this._inputBuffer, this._inputPtr, this._inputEnd, n4, this._bufferRecyclable);
        }
        return new ReaderBasedJsonParser(this._context, n, this.constructReader(), objectCodec, charsToNameCanonicalizer.makeChild(n2));
    }

    public static MatchStrength hasJSONFormat(InputAccessor inputAccessor) throws IOException {
        int n;
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
        }
        if ((n = ByteSourceJsonBootstrapper.skipSpace(inputAccessor, by)) < 0) {
            return MatchStrength.INCONCLUSIVE;
        }
        if (n == 123) {
            n = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n == 34 || n == 125) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (n == 91) {
            n = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n == 93 || n == 91) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.SOLID_MATCH;
        }
        MatchStrength matchStrength = MatchStrength.WEAK_MATCH;
        if (n == 34) {
            return matchStrength;
        }
        if (n <= 57 && n >= 48) {
            return matchStrength;
        }
        if (n == 45) {
            n = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            return n <= 57 && n >= 48 ? matchStrength : MatchStrength.NO_MATCH;
        }
        if (n == 110) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "ull", matchStrength);
        }
        if (n == 116) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "rue", matchStrength);
        }
        if (n == 102) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "alse", matchStrength);
        }
        return MatchStrength.NO_MATCH;
    }

    private static MatchStrength tryMatch(InputAccessor inputAccessor, String string, MatchStrength matchStrength) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() == string.charAt(i)) continue;
            return MatchStrength.NO_MATCH;
        }
        return matchStrength;
    }

    private static int skipSpace(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return -1;
        }
        return ByteSourceJsonBootstrapper.skipSpace(inputAccessor, inputAccessor.nextByte());
    }

    private static int skipSpace(InputAccessor inputAccessor, byte by) throws IOException {
        int n;
        while ((n = by & 0xFF) == 32 || n == 13 || n == 10 || n == 9) {
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by = inputAccessor.nextByte();
        }
        return n;
    }

    private boolean handleBOM(int n) throws IOException {
        switch (n) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
                break;
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
                break;
            }
        }
        int n2 = n >>> 16;
        if (n2 == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n2 == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int n) throws IOException {
        if (n >> 8 == 0) {
            this._bigEndian = true;
        } else if ((n & 0xFFFFFF) == 0) {
            this._bigEndian = false;
        } else if ((n & 0xFF00FFFF) == 0) {
            this.reportWeirdUCS4("3412");
        } else if ((n & 0xFFFF00FF) == 0) {
            this.reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this._bytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int n) {
        if ((n & 0xFF00) == 0) {
            this._bigEndian = true;
        } else if ((n & 0xFF) == 0) {
            this._bigEndian = false;
        } else {
            return false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    private void reportWeirdUCS4(String string) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    protected boolean ensureLoaded(int n) throws IOException {
        int n2;
        for (int i = this._inputEnd - this._inputPtr; i < n; i += n2) {
            n2 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n2 < 1) {
                return false;
            }
            this._inputEnd += n2;
        }
        return true;
    }
}

