/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.retry.RetryMode;
import com.amazonaws.util.HttpClientWrappingInputStream;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpProtocolParams;

public class RuntimeHttpUtils {
    private static final String COMMA = ", ";
    private static final String SPACE = " ";
    private static final String AWS_EXECUTION_ENV_PREFIX = "exec-env/";
    private static final String AWS_EXECUTION_ENV_NAME = "AWS_EXECUTION_ENV";
    private static final String RETRY_MODE_PREFIX = "cfg/retry-mode/";
    private static final String TRACE_ID_ENVIRONMENT_VARIABLE = "_X_AMZN_TRACE_ID";
    private static final String LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE = "AWS_LAMBDA_FUNCTION_NAME";

    public static InputStream fetchFile(URI uRI, ClientConfiguration clientConfiguration) throws IOException {
        Object object;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(basicHttpParams, RuntimeHttpUtils.getUserAgent(clientConfiguration, null));
        HttpConnectionParams.setConnectionTimeout(basicHttpParams, RuntimeHttpUtils.getConnectionTimeout(clientConfiguration));
        HttpConnectionParams.setSoTimeout(basicHttpParams, RuntimeHttpUtils.getSocketTimeout(clientConfiguration));
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(basicHttpParams);
        if (clientConfiguration != null) {
            object = clientConfiguration.getProxyHost();
            int n = clientConfiguration.getProxyPort();
            if (object != null && n > 0) {
                HttpHost httpHost = new HttpHost((String)object, n);
                defaultHttpClient.getParams().setParameter("http.route.default-proxy", httpHost);
                if (clientConfiguration.getProxyUsername() != null && clientConfiguration.getProxyPassword() != null) {
                    defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope((String)object, n), new NTCredentials(clientConfiguration.getProxyUsername(), clientConfiguration.getProxyPassword(), clientConfiguration.getProxyWorkstation(), clientConfiguration.getProxyDomain()));
                }
            }
        }
        if ((object = defaultHttpClient.execute(new HttpGet(uRI))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uRI + ": " + object);
        }
        return new HttpClientWrappingInputStream(defaultHttpClient, object.getEntity().getContent());
    }

    public static String getUserAgent(ClientConfiguration clientConfiguration, String string) {
        Object object;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = RuntimeHttpUtils.getEnvironmentVariable(AWS_EXECUTION_ENV_NAME);
        if (clientConfiguration != null) {
            string2 = clientConfiguration.getUserAgentPrefix();
            string3 = clientConfiguration.getUserAgentSuffix();
            object = clientConfiguration.getRetryMode() == null ? clientConfiguration.getRetryPolicy().getRetryMode() : clientConfiguration.getRetryMode();
            string4 = object != null ? ((RetryMode)((Object)object)).getName() : "";
        }
        object = new StringBuilder(string2.trim());
        if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(string2)) {
            ((StringBuilder)object).append(COMMA).append(ClientConfiguration.DEFAULT_USER_AGENT);
        }
        if (StringUtils.hasValue(string4)) {
            ((StringBuilder)object).append(SPACE).append(RETRY_MODE_PREFIX).append(string4.trim());
        }
        if (StringUtils.hasValue(string3)) {
            ((StringBuilder)object).append(COMMA).append(string3.trim());
        }
        if (StringUtils.hasValue(string5)) {
            ((StringBuilder)object).append(SPACE).append(AWS_EXECUTION_ENV_PREFIX).append(string5.trim());
        }
        if (StringUtils.hasValue(string)) {
            ((StringBuilder)object).append(SPACE).append(string.trim());
        }
        return ((StringBuilder)object).toString();
    }

    private static String getEnvironmentVariable(String string) {
        try {
            return System.getenv(string);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static int getConnectionTimeout(ClientConfiguration clientConfiguration) {
        if (clientConfiguration != null) {
            return clientConfiguration.getConnectionTimeout();
        }
        return 10000;
    }

    private static int getSocketTimeout(ClientConfiguration clientConfiguration) {
        if (clientConfiguration != null) {
            return clientConfiguration.getSocketTimeout();
        }
        return 50000;
    }

    public static URI toUri(String string, ClientConfiguration clientConfiguration) {
        if (clientConfiguration == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        return RuntimeHttpUtils.toUri(string, clientConfiguration.getProtocol());
    }

    public static URI toUri(String string, Protocol protocol) {
        if (string == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!string.contains("://")) {
            string = protocol.toString() + "://" + string;
        }
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @SdkProtectedApi
    public static URL convertRequestToUrl(Request<?> request, boolean bl, boolean bl2) {
        String string;
        String string2 = string = bl2 ? SdkHttpUtils.urlEncode(request.getResourcePath(), true) : request.getResourcePath();
        if (bl && string.startsWith("/")) {
            string = string.substring(1);
        }
        String string3 = "/" + string;
        string3 = string3.replaceAll("(?<=/)/", "%2F");
        StringBuilder stringBuilder = new StringBuilder(request.getEndpoint().toString());
        stringBuilder.append(string3);
        StringBuilder stringBuilder2 = new StringBuilder();
        Map<String, List<String>> map = request.getParameters();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String string4 : entry.getValue()) {
                stringBuilder2 = stringBuilder2.length() > 0 ? stringBuilder2.append("&") : stringBuilder2.append("?");
                stringBuilder2.append(SdkHttpUtils.urlEncode(entry.getKey(), false)).append("=").append(SdkHttpUtils.urlEncode(string4, false));
            }
        }
        stringBuilder.append(stringBuilder2.toString());
        try {
            return new URL(stringBuilder.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SdkClientException("Unable to convert request to well formed URL: " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static String getLambdaEnvironmentTraceId() {
        String string = RuntimeHttpUtils.getEnvironmentVariable(LAMBDA_FUNCTION_NAME_ENVIRONMENT_VARIABLE);
        String string2 = RuntimeHttpUtils.getEnvironmentVariable(TRACE_ID_ENVIRONMENT_VARIABLE);
        if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty(string2)) {
            return string2;
        }
        return null;
    }
}

