/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base64;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.LogFactory;

public class Md5Utils {
    private static final int SIXTEEN_K = 16384;

    public static byte[] computeMD5Hash(InputStream inputStream2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = new byte[16384];
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                LogFactory.getLog(Md5Utils.class).debug("Unable to close input stream of hash candidate: " + exception);
            }
        }
    }

    public static String md5AsBase64(InputStream inputStream2) throws IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(inputStream2));
    }

    public static byte[] computeMD5Hash(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static String md5AsBase64(byte[] byArray) {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(byArray));
    }

    public static byte[] computeMD5Hash(File file) throws FileNotFoundException, IOException {
        return Md5Utils.computeMD5Hash(new FileInputStream(file));
    }

    public static String md5AsBase64(File file) throws FileNotFoundException, IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(file));
    }
}

