/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.util.JodaTime;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.FixedDateTimeZone;

@ThreadSafe
public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    private static final long MILLI_SECONDS_OF_365_DAYS = 31536000000L;
    private static final int AWS_DATE_MILLI_SECOND_PRECISION = 3;
    protected static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);
    protected static final DateTimeFormatter ISO8601_DATE_FORMAT_WITH_OFFSET = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZZ");
    private static final List<DateTimeFormatter> ALTERNATE_ISO8601_FORMATTERS = Arrays.asList(alternateIso8601DateFormat, ISO8601_DATE_FORMAT_WITH_OFFSET);
    protected static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter compressedIso8601DateFormat = DateTimeFormat.forPattern("yyyyMMdd'T'HHmmss'Z'").withZone(GMT);

    public static Date parseISO8601Date(String string) {
        try {
            return DateUtils.doParseISO8601Date(string);
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    static Date doParseISO8601Date(String string) {
        String string2 = string;
        if (string2.endsWith("+0000")) {
            string2 = string2.substring(0, string2.length() - 5).concat("Z");
        }
        String string3 = DateUtils.tempDateStringForJodaTime(string2);
        try {
            if (string3.equals(string2)) {
                return new Date(iso8601DateFormat.parseMillis(string2));
            }
            long l = iso8601DateFormat.parseMillis(string3);
            long l2 = l + 31536000000L;
            if (l2 < 0L) {
                return new Date(iso8601DateFormat.parseMillis(string2));
            }
            return new Date(l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (DateTimeFormatter dateTimeFormatter : ALTERNATE_ISO8601_FORMATTERS) {
                try {
                    return new Date(dateTimeFormatter.parseMillis(string2));
                }
                catch (Exception exception) {
                }
            }
            throw illegalArgumentException;
        }
    }

    private static String tempDateStringForJodaTime(String string) {
        String string2 = "292278994-";
        String string3 = "292278993-";
        return string.startsWith("292278994-") ? "292278993-" + string.substring("292278994-".length()) : string;
    }

    private static <E extends RuntimeException> E handleException(E e) {
        if (JodaTime.hasExpectedBehavior()) {
            return e;
        }
        throw new IllegalStateException("Joda-time 2.2 or later version is required, but found version: " + JodaTime.getVersion(), e);
    }

    public static String formatISO8601Date(Date date) {
        try {
            return iso8601DateFormat.print(date.getTime());
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    public static String formatISO8601Date(DateTime dateTime) {
        try {
            return iso8601DateFormat.print(dateTime);
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    public static Date parseRFC822Date(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Date(rfc822DateFormat.parseMillis(string));
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    public static String formatRFC822Date(Date date) {
        try {
            return rfc822DateFormat.print(date.getTime());
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    public static Date parseCompressedISO8601Date(String string) {
        try {
            return new Date(compressedIso8601DateFormat.parseMillis(string));
        }
        catch (RuntimeException runtimeException) {
            throw DateUtils.handleException(runtimeException);
        }
    }

    public static Date parseServiceSpecificDate(String string) {
        if (string == null) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return new Date(bigDecimal.scaleByPowerOfTen(3).longValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SdkClientException("Unable to parse date : " + string, numberFormatException);
        }
    }

    public static Date parseUnixTimestampInMillis(String string) {
        if (string == null) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return new Date(bigDecimal.longValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SdkClientException("Unable to parse date : " + string, numberFormatException);
        }
    }

    public static String formatServiceSpecificDate(Date date) {
        if (date == null) {
            return null;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(date.getTime());
        return bigDecimal.scaleByPowerOfTen(-3).toPlainString();
    }

    public static String formatUnixTimestampInMills(Date date) {
        if (date == null) {
            return null;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(date.getTime());
        return bigDecimal.toPlainString();
    }

    public static Date cloneDate(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static long numberOfDaysSinceEpoch(long l) {
        return TimeUnit.MILLISECONDS.toDays(l);
    }
}

