/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32ChecksumCalculatingInputStream
extends SdkFilterInputStream {
    private CRC32 crc32 = new CRC32();

    public CRC32ChecksumCalculatingInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    public long getCRC32Checksum() {
        return this.crc32.getValue();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.crc32.reset();
        this.in.reset();
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        int n = this.in.read();
        if (n != -1) {
            this.crc32.update(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.abortIfNeeded();
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.crc32.update(byArray, n, n3);
        }
        return n3;
    }
}

